/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedChannelIds;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupCreateParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsergroupCreateParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsergroupCreateParams
implements UsergroupCreateParamsIF {
    private final List<String> rawChannelIds;
    private final transient Optional<String> encodedChannels;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String handle;
    @Nullable
    private final Boolean includeCount;

    private UsergroupCreateParams(List<String> rawChannelIds, String name, @Nullable String description, @Nullable String handle, @Nullable Boolean includeCount) {
        this.rawChannelIds = rawChannelIds;
        this.name = name;
        this.description = description;
        this.handle = handle;
        this.includeCount = includeCount;
        this.encodedChannels = Objects.requireNonNull(UsergroupCreateParamsIF.super.getEncodedChannels(), "encodedChannels");
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public List<String> getRawChannelIds() {
        return this.rawChannelIds;
    }

    @Override
    @JsonProperty(value="channels")
    public Optional<String> getEncodedChannels() {
        return this.encodedChannels;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> getHandle() {
        return Optional.ofNullable(this.handle);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    public final UsergroupCreateParams withRawChannelIds(String ... elements) {
        List<String> newValue = UsergroupCreateParams.createUnmodifiableList(false, UsergroupCreateParams.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupCreateParams(newValue, this.name, this.description, this.handle, this.includeCount);
    }

    public final UsergroupCreateParams withRawChannelIds(Iterable<String> elements) {
        if (this.rawChannelIds == elements) {
            return this;
        }
        List<String> newValue = UsergroupCreateParams.createUnmodifiableList(false, UsergroupCreateParams.createSafeList(elements, true, false));
        return new UsergroupCreateParams(newValue, this.name, this.description, this.handle, this.includeCount);
    }

    public final UsergroupCreateParams withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, newValue, this.description, this.handle, this.includeCount);
    }

    public final UsergroupCreateParams withDescription(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, newValue, this.handle, this.includeCount);
    }

    public final UsergroupCreateParams withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, value, this.handle, this.includeCount);
    }

    public final UsergroupCreateParams withHandle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.handle, newValue)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, this.description, newValue, this.includeCount);
    }

    public final UsergroupCreateParams withHandle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.handle, value)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, this.description, value, this.includeCount);
    }

    public final UsergroupCreateParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, this.description, this.handle, newValue);
    }

    public final UsergroupCreateParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupCreateParams(this.rawChannelIds, this.name, this.description, this.handle, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupCreateParams && this.equalTo(0, (UsergroupCreateParams)another);
    }

    private boolean equalTo(int synthetic, UsergroupCreateParams another) {
        return this.rawChannelIds.equals(another.rawChannelIds) && this.encodedChannels.equals(another.encodedChannels) && this.name.equals(another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.handle, another.handle) && Objects.equals(this.includeCount, another.includeCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.rawChannelIds.hashCode();
        h += (h << 5) + this.encodedChannels.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.handle);
        h += (h << 5) + Objects.hashCode(this.includeCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupCreateParams{");
        builder.append("rawChannelIds=").append(this.rawChannelIds);
        builder.append(", ");
        builder.append("encodedChannels=").append(this.encodedChannels);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.handle != null) {
            builder.append(", ");
            builder.append("handle=").append(this.handle);
        }
        if (this.includeCount != null) {
            builder.append(", ");
            builder.append("includeCount=").append(this.includeCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsergroupCreateParams fromJson(Json json) {
        Builder builder = UsergroupCreateParams.builder();
        if (json.rawChannelIds != null) {
            builder.addAllRawChannelIds(json.rawChannelIds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.handle != null) {
            builder.setHandle(json.handle);
        }
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        return builder.build();
    }

    public static UsergroupCreateParams copyOf(UsergroupCreateParamsIF instance) {
        if (instance instanceof UsergroupCreateParams) {
            return (UsergroupCreateParams)instance;
        }
        return UsergroupCreateParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UsergroupCreateParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private List<String> rawChannelIds = new ArrayList<String>();
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String handle;
        @Nullable
        private Boolean includeCount;

        private Builder() {
        }

        public final Builder from(HasCommaSeperatedChannelIds instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(UsergroupCreateParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasCommaSeperatedChannelIds instance;
            long bits = 0L;
            if (object instanceof HasCommaSeperatedChannelIds) {
                instance = (HasCommaSeperatedChannelIds)object;
                if ((bits & 1L) == 0L) {
                    this.addAllRawChannelIds(instance.getRawChannelIds());
                    bits |= 1L;
                }
            }
            if (object instanceof UsergroupCreateParamsIF) {
                Optional<Boolean> includeCountOptional;
                Optional<String> handleOptional;
                instance = (UsergroupCreateParamsIF)object;
                this.setName(instance.getName());
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.setDescription(descriptionOptional);
                }
                if ((handleOptional = instance.getHandle()).isPresent()) {
                    this.setHandle(handleOptional);
                }
                if ((includeCountOptional = instance.getIncludeCount()).isPresent()) {
                    this.setIncludeCount(includeCountOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllRawChannelIds(instance.getRawChannelIds());
                    bits |= 1L;
                }
            }
        }

        public final Builder addRawChannelIds(String element) {
            this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            return this;
        }

        public final Builder addRawChannelIds(String ... elements) {
            for (String element : elements) {
                this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            }
            return this;
        }

        public final Builder setRawChannelIds(Iterable<String> elements) {
            this.rawChannelIds.clear();
            return this.addAllRawChannelIds(elements);
        }

        public final Builder addAllRawChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
            }
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder setDescription(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder setHandle(@Nullable String handle) {
            this.handle = handle;
            return this;
        }

        public final Builder setHandle(Optional<String> handle) {
            this.handle = handle.orElse(null);
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public UsergroupCreateParams build() {
            this.checkRequiredAttributes();
            return new UsergroupCreateParams(UsergroupCreateParams.createUnmodifiableList(true, this.rawChannelIds), this.name, this.description, this.handle, this.includeCount);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build UsergroupCreateParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsergroupCreateParamsIF", generator="Immutables")
    static final class Json
    implements UsergroupCreateParamsIF {
        @Nullable
        List<String> rawChannelIds = Collections.emptyList();
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> handle = Optional.empty();
        @Nullable
        Optional<Boolean> includeCount = Optional.empty();

        Json() {
        }

        @JsonProperty
        @JsonIgnore
        public void setRawChannelIds(List<String> rawChannelIds) {
            this.rawChannelIds = rawChannelIds;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setHandle(Optional<String> handle) {
            this.handle = handle;
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @Override
        public List<String> getRawChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Optional<String> getEncodedChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHandle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }
    }
}

