/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.ResultSort;
import com.hubspot.slack.client.methods.ResultSortOrder;
import com.hubspot.slack.client.methods.params.search.SearchMessagesParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SearchMessagesParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SearchMessagesParams
implements SearchMessagesParamsIF {
    private final String query;
    private final boolean shouldHighlight;
    private final int count;
    private final int page;
    private final ResultSort sort;
    private final ResultSortOrder sortOrder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SearchMessagesParams(Builder builder) {
        this.query = builder.query;
        if (builder.shouldHighlightIsSet()) {
            this.initShim.setShouldHighlight(builder.shouldHighlight);
        }
        if (builder.countIsSet()) {
            this.initShim.setCount(builder.count);
        }
        if (builder.pageIsSet()) {
            this.initShim.setPage(builder.page);
        }
        if (builder.sort != null) {
            this.initShim.setSort(builder.sort);
        }
        if (builder.sortOrder != null) {
            this.initShim.setSortOrder(builder.sortOrder);
        }
        this.shouldHighlight = this.initShim.shouldHighlight();
        this.count = this.initShim.getCount();
        this.page = this.initShim.getPage();
        this.sort = this.initShim.getSort();
        this.sortOrder = this.initShim.getSortOrder();
        this.initShim = null;
    }

    private SearchMessagesParams(String query, boolean shouldHighlight, int count, int page, ResultSort sort, ResultSortOrder sortOrder) {
        this.query = query;
        this.shouldHighlight = shouldHighlight;
        this.count = count;
        this.page = page;
        this.sort = sort;
        this.sortOrder = sortOrder;
        this.initShim = null;
    }

    private boolean shouldHighlightInitialize() {
        return SearchMessagesParamsIF.super.shouldHighlight();
    }

    private int getCountInitialize() {
        return SearchMessagesParamsIF.super.getCount();
    }

    private int getPageInitialize() {
        return SearchMessagesParamsIF.super.getPage();
    }

    private ResultSort getSortInitialize() {
        return SearchMessagesParamsIF.super.getSort();
    }

    private ResultSortOrder getSortOrderInitialize() {
        return SearchMessagesParamsIF.super.getSortOrder();
    }

    @Override
    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @Override
    @JsonProperty
    public boolean shouldHighlight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shouldHighlight() : this.shouldHighlight;
    }

    @Override
    @JsonProperty
    public int getCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCount() : this.count;
    }

    @Override
    @JsonProperty
    public int getPage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPage() : this.page;
    }

    @Override
    @JsonProperty
    public ResultSort getSort() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSort() : this.sort;
    }

    @Override
    @JsonProperty(value="sort_dir")
    public ResultSortOrder getSortOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortOrder() : this.sortOrder;
    }

    public final SearchMessagesParams withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new SearchMessagesParams(newValue, this.shouldHighlight, this.count, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withShouldHighlight(boolean value) {
        if (this.shouldHighlight == value) {
            return this;
        }
        return new SearchMessagesParams(this.query, value, this.count, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, value, this.page, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withPage(int value) {
        if (this.page == value) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, value, this.sort, this.sortOrder);
    }

    public final SearchMessagesParams withSort(ResultSort value) {
        ResultSort newValue = Objects.requireNonNull(value, "sort");
        if (this.sort == newValue) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, newValue, this.sortOrder);
    }

    public final SearchMessagesParams withSortOrder(ResultSortOrder value) {
        ResultSortOrder newValue = Objects.requireNonNull(value, "sortOrder");
        if (this.sortOrder == newValue) {
            return this;
        }
        return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, this.sort, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SearchMessagesParams && this.equalTo(0, (SearchMessagesParams)another);
    }

    private boolean equalTo(int synthetic, SearchMessagesParams another) {
        return this.query.equals(another.query) && this.shouldHighlight == another.shouldHighlight && this.count == another.count && this.page == another.page && this.sort.equals((Object)another.sort) && this.sortOrder.equals((Object)another.sortOrder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + Boolean.hashCode(this.shouldHighlight);
        h += (h << 5) + this.count;
        h += (h << 5) + this.page;
        h += (h << 5) + this.sort.hashCode();
        h += (h << 5) + this.sortOrder.hashCode();
        return h;
    }

    public String toString() {
        return "SearchMessagesParams{query=" + this.query + ", shouldHighlight=" + this.shouldHighlight + ", count=" + this.count + ", page=" + this.page + ", sort=" + String.valueOf((Object)this.sort) + ", sortOrder=" + String.valueOf((Object)this.sortOrder) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SearchMessagesParams fromJson(Json json) {
        Builder builder = SearchMessagesParams.builder();
        if (json.query != null) {
            builder.setQuery(json.query);
        }
        if (json.shouldHighlightIsSet) {
            builder.setShouldHighlight(json.shouldHighlight);
        }
        if (json.countIsSet) {
            builder.setCount(json.count);
        }
        if (json.pageIsSet) {
            builder.setPage(json.page);
        }
        if (json.sort != null) {
            builder.setSort(json.sort);
        }
        if (json.sortOrder != null) {
            builder.setSortOrder(json.sortOrder);
        }
        return builder.build();
    }

    public static SearchMessagesParams copyOf(SearchMessagesParamsIF instance) {
        if (instance instanceof SearchMessagesParams) {
            return (SearchMessagesParams)instance;
        }
        return SearchMessagesParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SearchMessagesParamsIF", generator="Immutables")
    private final class InitShim {
        private byte shouldHighlightBuildStage = 0;
        private boolean shouldHighlight;
        private byte countBuildStage = 0;
        private int count;
        private byte pageBuildStage = 0;
        private int page;
        private byte sortBuildStage = 0;
        private ResultSort sort;
        private byte sortOrderBuildStage = 0;
        private ResultSortOrder sortOrder;

        private InitShim() {
        }

        boolean shouldHighlight() {
            if (this.shouldHighlightBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.shouldHighlightBuildStage == 0) {
                this.shouldHighlightBuildStage = (byte)-1;
                this.shouldHighlight = SearchMessagesParams.this.shouldHighlightInitialize();
                this.shouldHighlightBuildStage = 1;
            }
            return this.shouldHighlight;
        }

        void setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.shouldHighlightBuildStage = 1;
        }

        int getCount() {
            if (this.countBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.countBuildStage == 0) {
                this.countBuildStage = (byte)-1;
                this.count = SearchMessagesParams.this.getCountInitialize();
                this.countBuildStage = 1;
            }
            return this.count;
        }

        void setCount(int count) {
            this.count = count;
            this.countBuildStage = 1;
        }

        int getPage() {
            if (this.pageBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.pageBuildStage == 0) {
                this.pageBuildStage = (byte)-1;
                this.page = SearchMessagesParams.this.getPageInitialize();
                this.pageBuildStage = 1;
            }
            return this.page;
        }

        void setPage(int page) {
            this.page = page;
            this.pageBuildStage = 1;
        }

        ResultSort getSort() {
            if (this.sortBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sortBuildStage == 0) {
                this.sortBuildStage = (byte)-1;
                this.sort = Objects.requireNonNull(SearchMessagesParams.this.getSortInitialize(), "sort");
                this.sortBuildStage = 1;
            }
            return this.sort;
        }

        void setSort(ResultSort sort) {
            this.sort = sort;
            this.sortBuildStage = 1;
        }

        ResultSortOrder getSortOrder() {
            if (this.sortOrderBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sortOrderBuildStage == 0) {
                this.sortOrderBuildStage = (byte)-1;
                this.sortOrder = Objects.requireNonNull(SearchMessagesParams.this.getSortOrderInitialize(), "sortOrder");
                this.sortOrderBuildStage = 1;
            }
            return this.sortOrder;
        }

        void setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.sortOrderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.shouldHighlightBuildStage == -1) {
                attributes.add("shouldHighlight");
            }
            if (this.countBuildStage == -1) {
                attributes.add("count");
            }
            if (this.pageBuildStage == -1) {
                attributes.add("page");
            }
            if (this.sortBuildStage == -1) {
                attributes.add("sort");
            }
            if (this.sortOrderBuildStage == -1) {
                attributes.add("sortOrder");
            }
            return "Cannot build SearchMessagesParams, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="SearchMessagesParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_SHOULD_HIGHLIGHT = 1L;
        private static final long OPT_BIT_COUNT = 2L;
        private static final long OPT_BIT_PAGE = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String query;
        private boolean shouldHighlight;
        private int count;
        private int page;
        @Nullable
        private ResultSort sort;
        @Nullable
        private ResultSortOrder sortOrder;

        private Builder() {
        }

        public final Builder from(SearchMessagesParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setQuery(instance.getQuery());
            this.setShouldHighlight(instance.shouldHighlight());
            this.setCount(instance.getCount());
            this.setPage(instance.getPage());
            this.setSort(instance.getSort());
            this.setSortOrder(instance.getSortOrder());
            return this;
        }

        public final Builder setQuery(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setCount(int count) {
            this.count = count;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setPage(int page) {
            this.page = page;
            this.optBits |= 4L;
            return this;
        }

        public final Builder setSort(ResultSort sort) {
            this.sort = Objects.requireNonNull(sort, "sort");
            return this;
        }

        public final Builder setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder");
            return this;
        }

        public SearchMessagesParams build() {
            this.checkRequiredAttributes();
            return new SearchMessagesParams(this);
        }

        private boolean shouldHighlightIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean countIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean queryIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.queryIsSet()) {
                attributes.add("query");
            }
            return "Cannot build SearchMessagesParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchMessagesParamsIF", generator="Immutables")
    static final class Json
    implements SearchMessagesParamsIF {
        @Nullable
        String query;
        boolean shouldHighlight;
        boolean shouldHighlightIsSet;
        int count;
        boolean countIsSet;
        int page;
        boolean pageIsSet;
        @Nullable
        ResultSort sort;
        @Nullable
        ResultSortOrder sortOrder;

        Json() {
        }

        @JsonProperty
        public void setQuery(String query) {
            this.query = query;
        }

        @JsonProperty
        public void setShouldHighlight(boolean shouldHighlight) {
            this.shouldHighlight = shouldHighlight;
            this.shouldHighlightIsSet = true;
        }

        @JsonProperty
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty
        public void setPage(int page) {
            this.page = page;
            this.pageIsSet = true;
        }

        @JsonProperty
        public void setSort(ResultSort sort) {
            this.sort = sort;
        }

        @JsonProperty(value="sort_dir")
        public void setSortOrder(ResultSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public String getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldHighlight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSort getSort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSortOrder getSortOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

