/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.files.GetUploadUrlExternalParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GetUploadUrlExternalParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class GetUploadUrlExternalParams
implements GetUploadUrlExternalParamsIF {
    private final String filename;
    private final Long length;
    @Nullable
    private final String altText;
    @Nullable
    private final String snippetType;

    private GetUploadUrlExternalParams(String filename, Long length, @Nullable String altText, @Nullable String snippetType) {
        this.filename = filename;
        this.length = length;
        this.altText = altText;
        this.snippetType = snippetType;
    }

    @Override
    @JsonProperty
    public String getFilename() {
        return this.filename;
    }

    @Override
    @JsonProperty
    public Long getLength() {
        return this.length;
    }

    @Override
    @JsonProperty
    public Optional<String> getAltText() {
        return Optional.ofNullable(this.altText);
    }

    @Override
    @JsonProperty
    public Optional<String> getSnippetType() {
        return Optional.ofNullable(this.snippetType);
    }

    public final GetUploadUrlExternalParams withFilename(String value) {
        String newValue = Objects.requireNonNull(value, "filename");
        if (this.filename.equals(newValue)) {
            return this;
        }
        return new GetUploadUrlExternalParams(newValue, this.length, this.altText, this.snippetType);
    }

    public final GetUploadUrlExternalParams withLength(Long value) {
        Long newValue = Objects.requireNonNull(value, "length");
        if (this.length.equals(newValue)) {
            return this;
        }
        return new GetUploadUrlExternalParams(this.filename, newValue, this.altText, this.snippetType);
    }

    public final GetUploadUrlExternalParams withAltText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.altText, newValue)) {
            return this;
        }
        return new GetUploadUrlExternalParams(this.filename, this.length, newValue, this.snippetType);
    }

    public final GetUploadUrlExternalParams withAltText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.altText, value)) {
            return this;
        }
        return new GetUploadUrlExternalParams(this.filename, this.length, value, this.snippetType);
    }

    public final GetUploadUrlExternalParams withSnippetType(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.snippetType, newValue)) {
            return this;
        }
        return new GetUploadUrlExternalParams(this.filename, this.length, this.altText, newValue);
    }

    public final GetUploadUrlExternalParams withSnippetType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.snippetType, value)) {
            return this;
        }
        return new GetUploadUrlExternalParams(this.filename, this.length, this.altText, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetUploadUrlExternalParams && this.equalTo(0, (GetUploadUrlExternalParams)another);
    }

    private boolean equalTo(int synthetic, GetUploadUrlExternalParams another) {
        return this.filename.equals(another.filename) && this.length.equals(another.length) && Objects.equals(this.altText, another.altText) && Objects.equals(this.snippetType, another.snippetType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.filename.hashCode();
        h += (h << 5) + this.length.hashCode();
        h += (h << 5) + Objects.hashCode(this.altText);
        h += (h << 5) + Objects.hashCode(this.snippetType);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GetUploadUrlExternalParams{");
        builder.append("filename=").append(this.filename);
        builder.append(", ");
        builder.append("length=").append(this.length);
        if (this.altText != null) {
            builder.append(", ");
            builder.append("altText=").append(this.altText);
        }
        if (this.snippetType != null) {
            builder.append(", ");
            builder.append("snippetType=").append(this.snippetType);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetUploadUrlExternalParams fromJson(Json json) {
        Builder builder = GetUploadUrlExternalParams.builder();
        if (json.filename != null) {
            builder.setFilename(json.filename);
        }
        if (json.length != null) {
            builder.setLength(json.length);
        }
        if (json.altText != null) {
            builder.setAltText(json.altText);
        }
        if (json.snippetType != null) {
            builder.setSnippetType(json.snippetType);
        }
        return builder.build();
    }

    public static GetUploadUrlExternalParams copyOf(GetUploadUrlExternalParamsIF instance) {
        if (instance instanceof GetUploadUrlExternalParams) {
            return (GetUploadUrlExternalParams)instance;
        }
        return GetUploadUrlExternalParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GetUploadUrlExternalParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILENAME = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private long initBits = 3L;
        @Nullable
        private String filename;
        @Nullable
        private Long length;
        @Nullable
        private String altText;
        @Nullable
        private String snippetType;

        private Builder() {
        }

        public final Builder from(GetUploadUrlExternalParamsIF instance) {
            Optional<String> snippetTypeOptional;
            Objects.requireNonNull(instance, "instance");
            this.setFilename(instance.getFilename());
            this.setLength(instance.getLength());
            Optional<String> altTextOptional = instance.getAltText();
            if (altTextOptional.isPresent()) {
                this.setAltText(altTextOptional);
            }
            if ((snippetTypeOptional = instance.getSnippetType()).isPresent()) {
                this.setSnippetType(snippetTypeOptional);
            }
            return this;
        }

        public final Builder setFilename(String filename) {
            this.filename = Objects.requireNonNull(filename, "filename");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLength(Long length) {
            this.length = Objects.requireNonNull(length, "length");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setAltText(@Nullable String altText) {
            this.altText = altText;
            return this;
        }

        public final Builder setAltText(Optional<String> altText) {
            this.altText = altText.orElse(null);
            return this;
        }

        public final Builder setSnippetType(@Nullable String snippetType) {
            this.snippetType = snippetType;
            return this;
        }

        public final Builder setSnippetType(Optional<String> snippetType) {
            this.snippetType = snippetType.orElse(null);
            return this;
        }

        public GetUploadUrlExternalParams build() {
            this.checkRequiredAttributes();
            return new GetUploadUrlExternalParams(this.filename, this.length, this.altText, this.snippetType);
        }

        private boolean filenameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean lengthIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.filenameIsSet()) {
                attributes.add("filename");
            }
            if (!this.lengthIsSet()) {
                attributes.add("length");
            }
            return "Cannot build GetUploadUrlExternalParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GetUploadUrlExternalParamsIF", generator="Immutables")
    static final class Json
    implements GetUploadUrlExternalParamsIF {
        @Nullable
        String filename;
        @Nullable
        Long length;
        @Nullable
        Optional<String> altText = Optional.empty();
        @Nullable
        Optional<String> snippetType = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @JsonProperty
        public void setLength(Long length) {
            this.length = length;
        }

        @JsonProperty
        public void setAltText(Optional<String> altText) {
            this.altText = altText;
        }

        @JsonProperty
        public void setSnippetType(Optional<String> snippetType) {
            this.snippetType = snippetType;
        }

        @Override
        public String getFilename() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAltText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSnippetType() {
            throw new UnsupportedOperationException();
        }
    }
}

