/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.files.FileInfoIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FileInfoIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class FileInfo
implements FileInfoIF {
    private final String id;
    private final String title;

    private FileInfo(String id, String title) {
        this.id = id;
        this.title = title;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    public final FileInfo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new FileInfo(newValue, this.title);
    }

    public final FileInfo withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new FileInfo(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FileInfo && this.equalTo(0, (FileInfo)another);
    }

    private boolean equalTo(int synthetic, FileInfo another) {
        return this.id.equals(another.id) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "FileInfo{id=" + this.id + ", title=" + this.title + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static FileInfo fromJson(Json json) {
        Builder builder = FileInfo.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        return builder.build();
    }

    public static FileInfo copyOf(FileInfoIF instance) {
        if (instance instanceof FileInfo) {
            return (FileInfo)instance;
        }
        return FileInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileInfoIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(FileInfoIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setTitle(instance.getTitle());
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public FileInfo build() {
            this.checkRequiredAttributes();
            return new FileInfo(this.id, this.title);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            return "Cannot build FileInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileInfoIF", generator="Immutables")
    static final class Json
    implements FileInfoIF {
        @Nullable
        String id;
        @Nullable
        String title;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }
    }
}

