/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationsInfoParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationsInfoParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsInfoParams
implements ConversationsInfoParamsIF {
    private final String conversationId;
    @Nullable
    private final Boolean includeLocale;
    @Nullable
    private final Boolean includeNumMembers;

    private ConversationsInfoParams(String conversationId, @Nullable Boolean includeLocale, @Nullable Boolean includeNumMembers) {
        this.conversationId = conversationId;
        this.includeLocale = includeLocale;
        this.includeNumMembers = includeNumMembers;
    }

    @Override
    @JsonProperty(value="channel")
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeLocale() {
        return Optional.ofNullable(this.includeLocale);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeNumMembers() {
        return Optional.ofNullable(this.includeNumMembers);
    }

    public final ConversationsInfoParams withConversationId(String value) {
        String newValue = Objects.requireNonNull(value, "conversationId");
        if (this.conversationId.equals(newValue)) {
            return this;
        }
        return new ConversationsInfoParams(newValue, this.includeLocale, this.includeNumMembers);
    }

    public final ConversationsInfoParams withIncludeLocale(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeLocale, newValue)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, newValue, this.includeNumMembers);
    }

    public final ConversationsInfoParams withIncludeLocale(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeLocale, value)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, value, this.includeNumMembers);
    }

    public final ConversationsInfoParams withIncludeNumMembers(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeNumMembers, newValue)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, this.includeLocale, newValue);
    }

    public final ConversationsInfoParams withIncludeNumMembers(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeNumMembers, value)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, this.includeLocale, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsInfoParams && this.equalTo(0, (ConversationsInfoParams)another);
    }

    private boolean equalTo(int synthetic, ConversationsInfoParams another) {
        return this.conversationId.equals(another.conversationId) && Objects.equals(this.includeLocale, another.includeLocale) && Objects.equals(this.includeNumMembers, another.includeNumMembers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.conversationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.includeLocale);
        h += (h << 5) + Objects.hashCode(this.includeNumMembers);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsInfoParams{");
        builder.append("conversationId=").append(this.conversationId);
        if (this.includeLocale != null) {
            builder.append(", ");
            builder.append("includeLocale=").append(this.includeLocale);
        }
        if (this.includeNumMembers != null) {
            builder.append(", ");
            builder.append("includeNumMembers=").append(this.includeNumMembers);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsInfoParams fromJson(Json json) {
        Builder builder = ConversationsInfoParams.builder();
        if (json.conversationId != null) {
            builder.setConversationId(json.conversationId);
        }
        if (json.includeLocale != null) {
            builder.setIncludeLocale(json.includeLocale);
        }
        if (json.includeNumMembers != null) {
            builder.setIncludeNumMembers(json.includeNumMembers);
        }
        return builder.build();
    }

    public static ConversationsInfoParams copyOf(ConversationsInfoParamsIF instance) {
        if (instance instanceof ConversationsInfoParams) {
            return (ConversationsInfoParams)instance;
        }
        return ConversationsInfoParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConversationsInfoParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONVERSATION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String conversationId;
        @Nullable
        private Boolean includeLocale;
        @Nullable
        private Boolean includeNumMembers;

        private Builder() {
        }

        public final Builder from(ConversationsInfoParamsIF instance) {
            Optional<Boolean> includeNumMembersOptional;
            Objects.requireNonNull(instance, "instance");
            this.setConversationId(instance.getConversationId());
            Optional<Boolean> includeLocaleOptional = instance.getIncludeLocale();
            if (includeLocaleOptional.isPresent()) {
                this.setIncludeLocale(includeLocaleOptional);
            }
            if ((includeNumMembersOptional = instance.getIncludeNumMembers()).isPresent()) {
                this.setIncludeNumMembers(includeNumMembersOptional);
            }
            return this;
        }

        public final Builder setConversationId(String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeLocale(@Nullable Boolean includeLocale) {
            this.includeLocale = includeLocale;
            return this;
        }

        public final Builder setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale.orElse(null);
            return this;
        }

        public final Builder setIncludeNumMembers(@Nullable Boolean includeNumMembers) {
            this.includeNumMembers = includeNumMembers;
            return this;
        }

        public final Builder setIncludeNumMembers(Optional<Boolean> includeNumMembers) {
            this.includeNumMembers = includeNumMembers.orElse(null);
            return this;
        }

        public ConversationsInfoParams build() {
            this.checkRequiredAttributes();
            return new ConversationsInfoParams(this.conversationId, this.includeLocale, this.includeNumMembers);
        }

        private boolean conversationIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.conversationIdIsSet()) {
                attributes.add("conversationId");
            }
            return "Cannot build ConversationsInfoParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationsInfoParamsIF", generator="Immutables")
    static final class Json
    implements ConversationsInfoParamsIF {
        @Nullable
        String conversationId;
        @Nullable
        Optional<Boolean> includeLocale = Optional.empty();
        @Nullable
        Optional<Boolean> includeNumMembers = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @JsonProperty
        public void setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale;
        }

        @JsonProperty
        public void setIncludeNumMembers(Optional<Boolean> includeNumMembers) {
            this.includeNumMembers = includeNumMembers;
        }

        @Override
        public String getConversationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeNumMembers() {
            throw new UnsupportedOperationException();
        }
    }
}

