/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.flexpane;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.FlexPaneMetadata;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.WorkObjectFlexpaneError;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.WorkObjectFlexpaneParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WorkObjectFlexpaneParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class WorkObjectFlexpaneParams
implements WorkObjectFlexpaneParamsIF {
    private final String triggerId;
    private final FlexPaneMetadata metadata;
    @Nullable
    private final Boolean isUserAuthRequired;
    @Nullable
    private final String userAuthUrl;
    @Nullable
    private final WorkObjectFlexpaneError error;

    private WorkObjectFlexpaneParams(String triggerId, FlexPaneMetadata metadata, @Nullable Boolean isUserAuthRequired, @Nullable String userAuthUrl, @Nullable WorkObjectFlexpaneError error) {
        this.triggerId = triggerId;
        this.metadata = metadata;
        this.isUserAuthRequired = isUserAuthRequired;
        this.userAuthUrl = userAuthUrl;
        this.error = error;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public FlexPaneMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsUserAuthRequired() {
        return Optional.ofNullable(this.isUserAuthRequired);
    }

    @Override
    @JsonProperty
    public Optional<String> getUserAuthUrl() {
        return Optional.ofNullable(this.userAuthUrl);
    }

    @Override
    @JsonProperty
    public Optional<WorkObjectFlexpaneError> getError() {
        return Optional.ofNullable(this.error);
    }

    public final WorkObjectFlexpaneParams withTriggerId(String value) {
        String newValue = Objects.requireNonNull(value, "triggerId");
        if (this.triggerId.equals(newValue)) {
            return this;
        }
        return new WorkObjectFlexpaneParams(newValue, this.metadata, this.isUserAuthRequired, this.userAuthUrl, this.error);
    }

    public final WorkObjectFlexpaneParams withMetadata(FlexPaneMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        FlexPaneMetadata newValue = Objects.requireNonNull(value, "metadata");
        return new WorkObjectFlexpaneParams(this.triggerId, newValue, this.isUserAuthRequired, this.userAuthUrl, this.error);
    }

    public final WorkObjectFlexpaneParams withIsUserAuthRequired(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isUserAuthRequired, newValue)) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, newValue, this.userAuthUrl, this.error);
    }

    public final WorkObjectFlexpaneParams withIsUserAuthRequired(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isUserAuthRequired, value)) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, value, this.userAuthUrl, this.error);
    }

    public final WorkObjectFlexpaneParams withUserAuthUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.userAuthUrl, newValue)) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, this.isUserAuthRequired, newValue, this.error);
    }

    public final WorkObjectFlexpaneParams withUserAuthUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userAuthUrl, value)) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, this.isUserAuthRequired, value, this.error);
    }

    public final WorkObjectFlexpaneParams withError(@Nullable WorkObjectFlexpaneError value) {
        WorkObjectFlexpaneError newValue = value;
        if (this.error == newValue) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, this.isUserAuthRequired, this.userAuthUrl, newValue);
    }

    public final WorkObjectFlexpaneParams withError(Optional<? extends WorkObjectFlexpaneError> optional) {
        WorkObjectFlexpaneError value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, this.isUserAuthRequired, this.userAuthUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WorkObjectFlexpaneParams && this.equalTo(0, (WorkObjectFlexpaneParams)another);
    }

    private boolean equalTo(int synthetic, WorkObjectFlexpaneParams another) {
        return this.triggerId.equals(another.triggerId) && this.metadata.equals(another.metadata) && Objects.equals(this.isUserAuthRequired, another.isUserAuthRequired) && Objects.equals(this.userAuthUrl, another.userAuthUrl) && Objects.equals(this.error, another.error);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggerId.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + Objects.hashCode(this.isUserAuthRequired);
        h += (h << 5) + Objects.hashCode(this.userAuthUrl);
        h += (h << 5) + Objects.hashCode(this.error);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WorkObjectFlexpaneParams{");
        builder.append("triggerId=").append(this.triggerId);
        builder.append(", ");
        builder.append("metadata=").append(this.metadata);
        if (this.isUserAuthRequired != null) {
            builder.append(", ");
            builder.append("isUserAuthRequired=").append(this.isUserAuthRequired);
        }
        if (this.userAuthUrl != null) {
            builder.append(", ");
            builder.append("userAuthUrl=").append(this.userAuthUrl);
        }
        if (this.error != null) {
            builder.append(", ");
            builder.append("error=").append(this.error);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static WorkObjectFlexpaneParams fromJson(Json json) {
        Builder builder = WorkObjectFlexpaneParams.builder();
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.metadata != null) {
            builder.setMetadata(json.metadata);
        }
        if (json.isUserAuthRequired != null) {
            builder.setIsUserAuthRequired(json.isUserAuthRequired);
        }
        if (json.userAuthUrl != null) {
            builder.setUserAuthUrl(json.userAuthUrl);
        }
        if (json.error != null) {
            builder.setError(json.error);
        }
        return builder.build();
    }

    public static WorkObjectFlexpaneParams copyOf(WorkObjectFlexpaneParamsIF instance) {
        if (instance instanceof WorkObjectFlexpaneParams) {
            return (WorkObjectFlexpaneParams)instance;
        }
        return WorkObjectFlexpaneParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WorkObjectFlexpaneParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRIGGER_ID = 1L;
        private static final long INIT_BIT_METADATA = 2L;
        private long initBits = 3L;
        @Nullable
        private String triggerId;
        @Nullable
        private FlexPaneMetadata metadata;
        @Nullable
        private Boolean isUserAuthRequired;
        @Nullable
        private String userAuthUrl;
        @Nullable
        private WorkObjectFlexpaneError error;

        private Builder() {
        }

        public final Builder from(WorkObjectFlexpaneParamsIF instance) {
            Optional<WorkObjectFlexpaneError> errorOptional;
            Optional<String> userAuthUrlOptional;
            Objects.requireNonNull(instance, "instance");
            this.setTriggerId(instance.getTriggerId());
            this.setMetadata(instance.getMetadata());
            Optional<Boolean> isUserAuthRequiredOptional = instance.getIsUserAuthRequired();
            if (isUserAuthRequiredOptional.isPresent()) {
                this.setIsUserAuthRequired(isUserAuthRequiredOptional);
            }
            if ((userAuthUrlOptional = instance.getUserAuthUrl()).isPresent()) {
                this.setUserAuthUrl(userAuthUrlOptional);
            }
            if ((errorOptional = instance.getError()).isPresent()) {
                this.setError(errorOptional);
            }
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMetadata(FlexPaneMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setIsUserAuthRequired(@Nullable Boolean isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired;
            return this;
        }

        public final Builder setIsUserAuthRequired(Optional<Boolean> isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired.orElse(null);
            return this;
        }

        public final Builder setUserAuthUrl(@Nullable String userAuthUrl) {
            this.userAuthUrl = userAuthUrl;
            return this;
        }

        public final Builder setUserAuthUrl(Optional<String> userAuthUrl) {
            this.userAuthUrl = userAuthUrl.orElse(null);
            return this;
        }

        public final Builder setError(@Nullable WorkObjectFlexpaneError error) {
            this.error = error;
            return this;
        }

        public final Builder setError(Optional<? extends WorkObjectFlexpaneError> error) {
            this.error = error.orElse(null);
            return this;
        }

        public WorkObjectFlexpaneParams build() {
            this.checkRequiredAttributes();
            return new WorkObjectFlexpaneParams(this.triggerId, this.metadata, this.isUserAuthRequired, this.userAuthUrl, this.error);
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean metadataIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.metadataIsSet()) {
                attributes.add("metadata");
            }
            return "Cannot build WorkObjectFlexpaneParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkObjectFlexpaneParamsIF", generator="Immutables")
    static final class Json
    implements WorkObjectFlexpaneParamsIF {
        @Nullable
        String triggerId;
        @Nullable
        FlexPaneMetadata metadata;
        @Nullable
        Optional<Boolean> isUserAuthRequired = Optional.empty();
        @Nullable
        Optional<String> userAuthUrl = Optional.empty();
        @Nullable
        Optional<WorkObjectFlexpaneError> error = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setMetadata(FlexPaneMetadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty
        public void setIsUserAuthRequired(Optional<Boolean> isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired;
        }

        @JsonProperty
        public void setUserAuthUrl(Optional<String> userAuthUrl) {
            this.userAuthUrl = userAuthUrl;
        }

        @JsonProperty
        public void setError(Optional<WorkObjectFlexpaneError> error) {
            this.error = error;
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FlexPaneMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsUserAuthRequired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUserAuthUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WorkObjectFlexpaneError> getError() {
            throw new UnsupportedOperationException();
        }
    }
}

