/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.flexpane;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectAction;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.MessageFormat;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.WorkObjectFlexpaneErrorIF;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.WorkObjectFlexpaneErrorStatus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WorkObjectFlexpaneErrorIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class WorkObjectFlexpaneError
implements WorkObjectFlexpaneErrorIF {
    private final WorkObjectFlexpaneErrorStatus status;
    @Nullable
    private final String customTitle;
    @Nullable
    private final String customMessage;
    private final MessageFormat messageFormat;
    private final List<WorkObjectAction> actions;

    private WorkObjectFlexpaneError(WorkObjectFlexpaneErrorStatus status, @Nullable String customTitle, @Nullable String customMessage, MessageFormat messageFormat, List<WorkObjectAction> actions) {
        this.status = status;
        this.customTitle = customTitle;
        this.customMessage = customMessage;
        this.messageFormat = messageFormat;
        this.actions = actions;
    }

    @Override
    @JsonProperty
    public WorkObjectFlexpaneErrorStatus getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty
    public Optional<String> getCustomTitle() {
        return Optional.ofNullable(this.customTitle);
    }

    @Override
    @JsonProperty
    public Optional<String> getCustomMessage() {
        return Optional.ofNullable(this.customMessage);
    }

    @Override
    @JsonProperty
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    @JsonProperty
    public List<WorkObjectAction> getActions() {
        return this.actions;
    }

    public final WorkObjectFlexpaneError withStatus(WorkObjectFlexpaneErrorStatus value) {
        WorkObjectFlexpaneErrorStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new WorkObjectFlexpaneError(newValue, this.customTitle, this.customMessage, this.messageFormat, this.actions);
    }

    public final WorkObjectFlexpaneError withCustomTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.customTitle, newValue)) {
            return this;
        }
        return new WorkObjectFlexpaneError(this.status, newValue, this.customMessage, this.messageFormat, this.actions);
    }

    public final WorkObjectFlexpaneError withCustomTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.customTitle, value)) {
            return this;
        }
        return new WorkObjectFlexpaneError(this.status, value, this.customMessage, this.messageFormat, this.actions);
    }

    public final WorkObjectFlexpaneError withCustomMessage(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.customMessage, newValue)) {
            return this;
        }
        return new WorkObjectFlexpaneError(this.status, this.customTitle, newValue, this.messageFormat, this.actions);
    }

    public final WorkObjectFlexpaneError withCustomMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.customMessage, value)) {
            return this;
        }
        return new WorkObjectFlexpaneError(this.status, this.customTitle, value, this.messageFormat, this.actions);
    }

    public final WorkObjectFlexpaneError withMessageFormat(MessageFormat value) {
        MessageFormat newValue = Objects.requireNonNull(value, "messageFormat");
        if (this.messageFormat == newValue) {
            return this;
        }
        return new WorkObjectFlexpaneError(this.status, this.customTitle, this.customMessage, newValue, this.actions);
    }

    public final WorkObjectFlexpaneError withActions(WorkObjectAction ... elements) {
        List<WorkObjectAction> newValue = WorkObjectFlexpaneError.createUnmodifiableList(false, WorkObjectFlexpaneError.createSafeList(Arrays.asList(elements), true, false));
        return new WorkObjectFlexpaneError(this.status, this.customTitle, this.customMessage, this.messageFormat, newValue);
    }

    public final WorkObjectFlexpaneError withActions(Iterable<? extends WorkObjectAction> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<WorkObjectAction> newValue = WorkObjectFlexpaneError.createUnmodifiableList(false, WorkObjectFlexpaneError.createSafeList(elements, true, false));
        return new WorkObjectFlexpaneError(this.status, this.customTitle, this.customMessage, this.messageFormat, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WorkObjectFlexpaneError && this.equalTo(0, (WorkObjectFlexpaneError)another);
    }

    private boolean equalTo(int synthetic, WorkObjectFlexpaneError another) {
        return this.status.equals((Object)another.status) && Objects.equals(this.customTitle, another.customTitle) && Objects.equals(this.customMessage, another.customMessage) && this.messageFormat.equals((Object)another.messageFormat) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.customTitle);
        h += (h << 5) + Objects.hashCode(this.customMessage);
        h += (h << 5) + this.messageFormat.hashCode();
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WorkObjectFlexpaneError{");
        builder.append("status=").append((Object)this.status);
        if (this.customTitle != null) {
            builder.append(", ");
            builder.append("customTitle=").append(this.customTitle);
        }
        if (this.customMessage != null) {
            builder.append(", ");
            builder.append("customMessage=").append(this.customMessage);
        }
        builder.append(", ");
        builder.append("messageFormat=").append((Object)this.messageFormat);
        builder.append(", ");
        builder.append("actions=").append(this.actions);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static WorkObjectFlexpaneError fromJson(Json json) {
        Builder builder = WorkObjectFlexpaneError.builder();
        if (json.status != null) {
            builder.setStatus(json.status);
        }
        if (json.customTitle != null) {
            builder.setCustomTitle(json.customTitle);
        }
        if (json.customMessage != null) {
            builder.setCustomMessage(json.customMessage);
        }
        if (json.messageFormat != null) {
            builder.setMessageFormat(json.messageFormat);
        }
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        return builder.build();
    }

    public static WorkObjectFlexpaneError copyOf(WorkObjectFlexpaneErrorIF instance) {
        if (instance instanceof WorkObjectFlexpaneError) {
            return (WorkObjectFlexpaneError)instance;
        }
        return WorkObjectFlexpaneError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WorkObjectFlexpaneErrorIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_MESSAGE_FORMAT = 2L;
        private long initBits = 3L;
        @Nullable
        private WorkObjectFlexpaneErrorStatus status;
        @Nullable
        private String customTitle;
        @Nullable
        private String customMessage;
        @Nullable
        private MessageFormat messageFormat;
        private List<WorkObjectAction> actions = new ArrayList<WorkObjectAction>();

        private Builder() {
        }

        public final Builder from(WorkObjectFlexpaneErrorIF instance) {
            Optional<String> customMessageOptional;
            Objects.requireNonNull(instance, "instance");
            this.setStatus(instance.getStatus());
            Optional<String> customTitleOptional = instance.getCustomTitle();
            if (customTitleOptional.isPresent()) {
                this.setCustomTitle(customTitleOptional);
            }
            if ((customMessageOptional = instance.getCustomMessage()).isPresent()) {
                this.setCustomMessage(customMessageOptional);
            }
            this.setMessageFormat(instance.getMessageFormat());
            this.addAllActions(instance.getActions());
            return this;
        }

        public final Builder setStatus(WorkObjectFlexpaneErrorStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCustomTitle(@Nullable String customTitle) {
            this.customTitle = customTitle;
            return this;
        }

        public final Builder setCustomTitle(Optional<String> customTitle) {
            this.customTitle = customTitle.orElse(null);
            return this;
        }

        public final Builder setCustomMessage(@Nullable String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final Builder setCustomMessage(Optional<String> customMessage) {
            this.customMessage = customMessage.orElse(null);
            return this;
        }

        public final Builder setMessageFormat(MessageFormat messageFormat) {
            this.messageFormat = Objects.requireNonNull(messageFormat, "messageFormat");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addActions(WorkObjectAction element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(WorkObjectAction ... elements) {
            for (WorkObjectAction element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        public final Builder setActions(Iterable<? extends WorkObjectAction> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<? extends WorkObjectAction> elements) {
            for (WorkObjectAction workObjectAction : elements) {
                this.actions.add(Objects.requireNonNull(workObjectAction, "actions element"));
            }
            return this;
        }

        public WorkObjectFlexpaneError build() {
            this.checkRequiredAttributes();
            return new WorkObjectFlexpaneError(this.status, this.customTitle, this.customMessage, this.messageFormat, WorkObjectFlexpaneError.createUnmodifiableList(true, this.actions));
        }

        private boolean statusIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageFormatIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.statusIsSet()) {
                attributes.add("status");
            }
            if (!this.messageFormatIsSet()) {
                attributes.add("messageFormat");
            }
            return "Cannot build WorkObjectFlexpaneError, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkObjectFlexpaneErrorIF", generator="Immutables")
    static final class Json
    implements WorkObjectFlexpaneErrorIF {
        @Nullable
        WorkObjectFlexpaneErrorStatus status;
        @Nullable
        Optional<String> customTitle = Optional.empty();
        @Nullable
        Optional<String> customMessage = Optional.empty();
        @Nullable
        MessageFormat messageFormat;
        @Nullable
        List<WorkObjectAction> actions = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setStatus(WorkObjectFlexpaneErrorStatus status) {
            this.status = status;
        }

        @JsonProperty
        public void setCustomTitle(Optional<String> customTitle) {
            this.customTitle = customTitle;
        }

        @JsonProperty
        public void setCustomMessage(Optional<String> customMessage) {
            this.customMessage = customMessage;
        }

        @JsonProperty
        public void setMessageFormat(MessageFormat messageFormat) {
            this.messageFormat = messageFormat;
        }

        @JsonProperty
        public void setActions(List<WorkObjectAction> actions) {
            this.actions = actions;
        }

        @Override
        public WorkObjectFlexpaneErrorStatus getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCustomTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCustomMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageFormat getMessageFormat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WorkObjectAction> getActions() {
            throw new UnsupportedOperationException();
        }
    }
}

