/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.flexpane;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.EntityType;
import com.hubspot.slack.client.methods.params.chat.workobject.ExternalRef;
import com.hubspot.slack.client.methods.params.chat.workobject.WorkObjectBase;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayload;
import com.hubspot.slack.client.methods.params.chat.workobject.flexpane.FlexPaneMetadataIF;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.EntityTypeDeserializer;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.EntityTypeSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FlexPaneMetadataIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class FlexPaneMetadata
implements FlexPaneMetadataIF {
    private final EntityType entityType;
    private final EntityPayload entityPayload;
    private final String url;
    private final ExternalRef externalRef;

    private FlexPaneMetadata(EntityType entityType, EntityPayload entityPayload, String url, ExternalRef externalRef) {
        this.entityType = entityType;
        this.entityPayload = entityPayload;
        this.url = url;
        this.externalRef = externalRef;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=EntityTypeSerializer.class)
    @JsonDeserialize(using=EntityTypeDeserializer.class)
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    @JsonProperty
    public EntityPayload getEntityPayload() {
        return this.entityPayload;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty
    public ExternalRef getExternalRef() {
        return this.externalRef;
    }

    public final FlexPaneMetadata withEntityType(EntityType value) {
        EntityType newValue = Objects.requireNonNull(value, "entityType");
        if (this.entityType == newValue) {
            return this;
        }
        return new FlexPaneMetadata(newValue, this.entityPayload, this.url, this.externalRef);
    }

    public final FlexPaneMetadata withEntityPayload(EntityPayload value) {
        if (this.entityPayload == value) {
            return this;
        }
        EntityPayload newValue = Objects.requireNonNull(value, "entityPayload");
        return new FlexPaneMetadata(this.entityType, newValue, this.url, this.externalRef);
    }

    public final FlexPaneMetadata withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new FlexPaneMetadata(this.entityType, this.entityPayload, newValue, this.externalRef);
    }

    public final FlexPaneMetadata withExternalRef(ExternalRef value) {
        if (this.externalRef == value) {
            return this;
        }
        ExternalRef newValue = Objects.requireNonNull(value, "externalRef");
        return new FlexPaneMetadata(this.entityType, this.entityPayload, this.url, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FlexPaneMetadata && this.equalTo(0, (FlexPaneMetadata)another);
    }

    private boolean equalTo(int synthetic, FlexPaneMetadata another) {
        return this.entityType.equals((Object)another.entityType) && this.entityPayload.equals(another.entityPayload) && this.url.equals(another.url) && this.externalRef.equals(another.externalRef);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entityType.hashCode();
        h += (h << 5) + this.entityPayload.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.externalRef.hashCode();
        return h;
    }

    public String toString() {
        return "FlexPaneMetadata{entityType=" + String.valueOf((Object)this.entityType) + ", entityPayload=" + String.valueOf(this.entityPayload) + ", url=" + this.url + ", externalRef=" + String.valueOf(this.externalRef) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static FlexPaneMetadata fromJson(Json json) {
        Builder builder = FlexPaneMetadata.builder();
        if (json.entityType != null) {
            builder.setEntityType(json.entityType);
        }
        if (json.entityPayload != null) {
            builder.setEntityPayload(json.entityPayload);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.externalRef != null) {
            builder.setExternalRef(json.externalRef);
        }
        return builder.build();
    }

    public static FlexPaneMetadata copyOf(FlexPaneMetadataIF instance) {
        if (instance instanceof FlexPaneMetadata) {
            return (FlexPaneMetadata)instance;
        }
        return FlexPaneMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FlexPaneMetadataIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_TYPE = 1L;
        private static final long INIT_BIT_ENTITY_PAYLOAD = 2L;
        private static final long INIT_BIT_URL = 4L;
        private static final long INIT_BIT_EXTERNAL_REF = 8L;
        private long initBits = 15L;
        @Nullable
        private EntityType entityType;
        @Nullable
        private EntityPayload entityPayload;
        @Nullable
        private String url;
        @Nullable
        private ExternalRef externalRef;

        private Builder() {
        }

        public final Builder from(FlexPaneMetadataIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(WorkObjectBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            WorkObjectBase instance;
            long bits = 0L;
            if (object instanceof FlexPaneMetadataIF) {
                instance = (FlexPaneMetadataIF)object;
                if ((bits & 4L) == 0L) {
                    this.setExternalRef(instance.getExternalRef());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.setEntityType(instance.getEntityType());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.setUrl(instance.getUrl());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.setEntityPayload(instance.getEntityPayload());
                    bits |= 2L;
                }
            }
            if (object instanceof WorkObjectBase) {
                instance = (WorkObjectBase)object;
                if ((bits & 4L) == 0L) {
                    this.setExternalRef(instance.getExternalRef());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.setEntityType(instance.getEntityType());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.setUrl(instance.getUrl());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.setEntityPayload(instance.getEntityPayload());
                    bits |= 2L;
                }
            }
        }

        public final Builder setEntityType(EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setEntityPayload(EntityPayload entityPayload) {
            this.entityPayload = Objects.requireNonNull(entityPayload, "entityPayload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setExternalRef(ExternalRef externalRef) {
            this.externalRef = Objects.requireNonNull(externalRef, "externalRef");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public FlexPaneMetadata build() {
            this.checkRequiredAttributes();
            return new FlexPaneMetadata(this.entityType, this.entityPayload, this.url, this.externalRef);
        }

        private boolean entityTypeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean entityPayloadIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean externalRefIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.entityTypeIsSet()) {
                attributes.add("entityType");
            }
            if (!this.entityPayloadIsSet()) {
                attributes.add("entityPayload");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.externalRefIsSet()) {
                attributes.add("externalRef");
            }
            return "Cannot build FlexPaneMetadata, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FlexPaneMetadataIF", generator="Immutables")
    static final class Json
    implements FlexPaneMetadataIF {
        @Nullable
        EntityType entityType;
        @Nullable
        EntityPayload entityPayload;
        @Nullable
        String url;
        @Nullable
        ExternalRef externalRef;

        Json() {
        }

        @JsonProperty
        @JsonSerialize(using=EntityTypeSerializer.class)
        @JsonDeserialize(using=EntityTypeDeserializer.class)
        public void setEntityType(EntityType entityType) {
            this.entityType = entityType;
        }

        @JsonProperty
        public void setEntityPayload(EntityPayload entityPayload) {
            this.entityPayload = entityPayload;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setExternalRef(ExternalRef externalRef) {
            this.externalRef = externalRef;
        }

        @Override
        public EntityType getEntityType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityPayload getEntityPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExternalRef getExternalRef() {
            throw new UnsupportedOperationException();
        }
    }
}

