/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.IconIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="IconIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Icon
implements IconIF {
    private final String url;
    private final String altText;

    private Icon(String url, String altText) {
        this.url = url;
        this.altText = altText;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty
    public String getAltText() {
        return this.altText;
    }

    public final Icon withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new Icon(newValue, this.altText);
    }

    public final Icon withAltText(String value) {
        String newValue = Objects.requireNonNull(value, "altText");
        if (this.altText.equals(newValue)) {
            return this;
        }
        return new Icon(this.url, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Icon && this.equalTo(0, (Icon)another);
    }

    private boolean equalTo(int synthetic, Icon another) {
        return this.url.equals(another.url) && this.altText.equals(another.altText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.altText.hashCode();
        return h;
    }

    public String toString() {
        return "Icon{url=" + this.url + ", altText=" + this.altText + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Icon fromJson(Json json) {
        Builder builder = Icon.builder();
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.altText != null) {
            builder.setAltText(json.altText);
        }
        return builder.build();
    }

    public static Icon copyOf(IconIF instance) {
        if (instance instanceof Icon) {
            return (Icon)instance;
        }
        return Icon.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IconIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_ALT_TEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String url;
        @Nullable
        private String altText;

        private Builder() {
        }

        public final Builder from(IconIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUrl(instance.getUrl());
            this.setAltText(instance.getAltText());
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAltText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Icon build() {
            this.checkRequiredAttributes();
            return new Icon(this.url, this.altText);
        }

        private boolean urlIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean altTextIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.altTextIsSet()) {
                attributes.add("altText");
            }
            return "Cannot build Icon, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IconIF", generator="Immutables")
    static final class Json
    implements IconIF {
        @Nullable
        String url;
        @Nullable
        String altText;

        Json() {
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setAltText(String altText) {
            this.altText = altText;
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAltText() {
            throw new UnsupportedOperationException();
        }
    }
}

