/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.DisplayType;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayloadAttributeTitle;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayloadAttributesIF;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.Icon;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.DisplayTypeDeserializer;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.DisplayTypeSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EntityPayloadAttributesIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class EntityPayloadAttributes
implements EntityPayloadAttributesIF {
    private final EntityPayloadAttributeTitle title;
    @Nullable
    private final String displayId;
    @Nullable
    private final DisplayType displayType;
    @Nullable
    private final String productName;
    @Nullable
    private final Icon productIcon;
    @Nullable
    private final String locale;

    private EntityPayloadAttributes(EntityPayloadAttributeTitle title, @Nullable String displayId, @Nullable DisplayType displayType, @Nullable String productName, @Nullable Icon productIcon, @Nullable String locale) {
        this.title = title;
        this.displayId = displayId;
        this.displayType = displayType;
        this.productName = productName;
        this.productIcon = productIcon;
        this.locale = locale;
    }

    @Override
    @JsonProperty
    public EntityPayloadAttributeTitle getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> getDisplayId() {
        return Optional.ofNullable(this.displayId);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonSerialize(using=DisplayTypeSerializer.class)
    @JsonDeserialize(using=DisplayTypeDeserializer.class)
    public Optional<DisplayType> getDisplayType() {
        return Optional.ofNullable(this.displayType);
    }

    @Override
    @JsonProperty
    public Optional<String> getProductName() {
        return Optional.ofNullable(this.productName);
    }

    @Override
    @JsonProperty
    public Optional<Icon> getProductIcon() {
        return Optional.ofNullable(this.productIcon);
    }

    @Override
    @JsonProperty
    public Optional<String> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    public final EntityPayloadAttributes withTitle(EntityPayloadAttributeTitle value) {
        if (this.title == value) {
            return this;
        }
        EntityPayloadAttributeTitle newValue = Objects.requireNonNull(value, "title");
        return new EntityPayloadAttributes(newValue, this.displayId, this.displayType, this.productName, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withDisplayId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.displayId, newValue)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, newValue, this.displayType, this.productName, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withDisplayId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.displayId, value)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, value, this.displayType, this.productName, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withDisplayType(@Nullable DisplayType value) {
        DisplayType newValue = value;
        if (this.displayType == newValue) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, newValue, this.productName, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withDisplayType(Optional<? extends DisplayType> optional) {
        DisplayType value = optional.orElse(null);
        if (this.displayType == value) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, value, this.productName, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withProductName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.productName, newValue)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, newValue, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withProductName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.productName, value)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, value, this.productIcon, this.locale);
    }

    public final EntityPayloadAttributes withProductIcon(@Nullable Icon value) {
        Icon newValue = value;
        if (this.productIcon == newValue) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, this.productName, newValue, this.locale);
    }

    public final EntityPayloadAttributes withProductIcon(Optional<? extends Icon> optional) {
        Icon value = optional.orElse(null);
        if (this.productIcon == value) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, this.productName, value, this.locale);
    }

    public final EntityPayloadAttributes withLocale(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.locale, newValue)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, this.productName, this.productIcon, newValue);
    }

    public final EntityPayloadAttributes withLocale(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.locale, value)) {
            return this;
        }
        return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, this.productName, this.productIcon, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EntityPayloadAttributes && this.equalTo(0, (EntityPayloadAttributes)another);
    }

    private boolean equalTo(int synthetic, EntityPayloadAttributes another) {
        return this.title.equals(another.title) && Objects.equals(this.displayId, another.displayId) && Objects.equals((Object)this.displayType, (Object)another.displayType) && Objects.equals(this.productName, another.productName) && Objects.equals(this.productIcon, another.productIcon) && Objects.equals(this.locale, another.locale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.displayId);
        h += (h << 5) + Objects.hashCode((Object)this.displayType);
        h += (h << 5) + Objects.hashCode(this.productName);
        h += (h << 5) + Objects.hashCode(this.productIcon);
        h += (h << 5) + Objects.hashCode(this.locale);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EntityPayloadAttributes{");
        builder.append("title=").append(this.title);
        if (this.displayId != null) {
            builder.append(", ");
            builder.append("displayId=").append(this.displayId);
        }
        if (this.displayType != null) {
            builder.append(", ");
            builder.append("displayType=").append((Object)this.displayType);
        }
        if (this.productName != null) {
            builder.append(", ");
            builder.append("productName=").append(this.productName);
        }
        if (this.productIcon != null) {
            builder.append(", ");
            builder.append("productIcon=").append(this.productIcon);
        }
        if (this.locale != null) {
            builder.append(", ");
            builder.append("locale=").append(this.locale);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static EntityPayloadAttributes fromJson(Json json) {
        Builder builder = EntityPayloadAttributes.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.displayId != null) {
            builder.setDisplayId(json.displayId);
        }
        if (json.displayType != null) {
            builder.setDisplayType(json.displayType);
        }
        if (json.productName != null) {
            builder.setProductName(json.productName);
        }
        if (json.productIcon != null) {
            builder.setProductIcon(json.productIcon);
        }
        if (json.locale != null) {
            builder.setLocale(json.locale);
        }
        return builder.build();
    }

    public static EntityPayloadAttributes copyOf(EntityPayloadAttributesIF instance) {
        if (instance instanceof EntityPayloadAttributes) {
            return (EntityPayloadAttributes)instance;
        }
        return EntityPayloadAttributes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntityPayloadAttributesIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private EntityPayloadAttributeTitle title;
        @Nullable
        private String displayId;
        @Nullable
        private DisplayType displayType;
        @Nullable
        private String productName;
        @Nullable
        private Icon productIcon;
        @Nullable
        private String locale;

        private Builder() {
        }

        public final Builder from(EntityPayloadAttributesIF instance) {
            Optional<String> localeOptional;
            Optional<Icon> productIconOptional;
            Optional<String> productNameOptional;
            Optional<DisplayType> displayTypeOptional;
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            Optional<String> displayIdOptional = instance.getDisplayId();
            if (displayIdOptional.isPresent()) {
                this.setDisplayId(displayIdOptional);
            }
            if ((displayTypeOptional = instance.getDisplayType()).isPresent()) {
                this.setDisplayType(displayTypeOptional);
            }
            if ((productNameOptional = instance.getProductName()).isPresent()) {
                this.setProductName(productNameOptional);
            }
            if ((productIconOptional = instance.getProductIcon()).isPresent()) {
                this.setProductIcon(productIconOptional);
            }
            if ((localeOptional = instance.getLocale()).isPresent()) {
                this.setLocale(localeOptional);
            }
            return this;
        }

        public final Builder setTitle(EntityPayloadAttributeTitle title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDisplayId(@Nullable String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final Builder setDisplayId(Optional<String> displayId) {
            this.displayId = displayId.orElse(null);
            return this;
        }

        public final Builder setDisplayType(@Nullable DisplayType displayType) {
            this.displayType = displayType;
            return this;
        }

        public final Builder setDisplayType(Optional<? extends DisplayType> displayType) {
            this.displayType = displayType.orElse(null);
            return this;
        }

        public final Builder setProductName(@Nullable String productName) {
            this.productName = productName;
            return this;
        }

        public final Builder setProductName(Optional<String> productName) {
            this.productName = productName.orElse(null);
            return this;
        }

        public final Builder setProductIcon(@Nullable Icon productIcon) {
            this.productIcon = productIcon;
            return this;
        }

        public final Builder setProductIcon(Optional<? extends Icon> productIcon) {
            this.productIcon = productIcon.orElse(null);
            return this;
        }

        public final Builder setLocale(@Nullable String locale) {
            this.locale = locale;
            return this;
        }

        public final Builder setLocale(Optional<String> locale) {
            this.locale = locale.orElse(null);
            return this;
        }

        public EntityPayloadAttributes build() {
            this.checkRequiredAttributes();
            return new EntityPayloadAttributes(this.title, this.displayId, this.displayType, this.productName, this.productIcon, this.locale);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            return "Cannot build EntityPayloadAttributes, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntityPayloadAttributesIF", generator="Immutables")
    static final class Json
    implements EntityPayloadAttributesIF {
        @Nullable
        EntityPayloadAttributeTitle title;
        @Nullable
        Optional<String> displayId = Optional.empty();
        @Nullable
        Optional<DisplayType> displayType = Optional.empty();
        @Nullable
        Optional<String> productName = Optional.empty();
        @Nullable
        Optional<Icon> productIcon = Optional.empty();
        @Nullable
        Optional<String> locale = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(EntityPayloadAttributeTitle title) {
            this.title = title;
        }

        @JsonProperty
        public void setDisplayId(Optional<String> displayId) {
            this.displayId = displayId;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonSerialize(using=DisplayTypeSerializer.class)
        @JsonDeserialize(using=DisplayTypeDeserializer.class)
        public void setDisplayType(Optional<DisplayType> displayType) {
            this.displayType = displayType;
        }

        @JsonProperty
        public void setProductName(Optional<String> productName) {
            this.productName = productName;
        }

        @JsonProperty
        public void setProductIcon(Optional<Icon> productIcon) {
            this.productIcon = productIcon;
        }

        @JsonProperty
        public void setLocale(Optional<String> locale) {
            this.locale = locale;
        }

        @Override
        public EntityPayloadAttributeTitle getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDisplayId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DisplayType> getDisplayType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getProductName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Icon> getProductIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLocale() {
            throw new UnsupportedOperationException();
        }
    }
}

