/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectActionBlock;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayloadAttributes;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayloadAttributesCustomField;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayloadIF;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.fields.EntityPayloadFields;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EntityPayloadIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class EntityPayload
implements EntityPayloadIF {
    private final EntityPayloadAttributes attributes;
    @Nullable
    private final EntityPayloadFields fields;
    private final List<EntityPayloadAttributesCustomField> customFields;
    private final List<String> displayOrder;
    @Nullable
    private final WorkObjectActionBlock actions;

    private EntityPayload(EntityPayloadAttributes attributes, @Nullable EntityPayloadFields fields, List<EntityPayloadAttributesCustomField> customFields, List<String> displayOrder, @Nullable WorkObjectActionBlock actions) {
        this.attributes = attributes;
        this.fields = fields;
        this.customFields = customFields;
        this.displayOrder = displayOrder;
        this.actions = actions;
    }

    @Override
    @JsonProperty
    public EntityPayloadAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonProperty
    public Optional<EntityPayloadFields> getFields() {
        return Optional.ofNullable(this.fields);
    }

    @Override
    @JsonProperty
    public List<EntityPayloadAttributesCustomField> getCustomFields() {
        return this.customFields;
    }

    @Override
    @JsonProperty
    public List<String> getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    @JsonProperty
    public Optional<WorkObjectActionBlock> getActions() {
        return Optional.ofNullable(this.actions);
    }

    public final EntityPayload withAttributes(EntityPayloadAttributes value) {
        if (this.attributes == value) {
            return this;
        }
        EntityPayloadAttributes newValue = Objects.requireNonNull(value, "attributes");
        return new EntityPayload(newValue, this.fields, this.customFields, this.displayOrder, this.actions);
    }

    public final EntityPayload withFields(@Nullable EntityPayloadFields value) {
        EntityPayloadFields newValue = value;
        if (this.fields == newValue) {
            return this;
        }
        return new EntityPayload(this.attributes, newValue, this.customFields, this.displayOrder, this.actions);
    }

    public final EntityPayload withFields(Optional<? extends EntityPayloadFields> optional) {
        EntityPayloadFields value = optional.orElse(null);
        if (this.fields == value) {
            return this;
        }
        return new EntityPayload(this.attributes, value, this.customFields, this.displayOrder, this.actions);
    }

    public final EntityPayload withCustomFields(EntityPayloadAttributesCustomField ... elements) {
        List<EntityPayloadAttributesCustomField> newValue = EntityPayload.createUnmodifiableList(false, EntityPayload.createSafeList(Arrays.asList(elements), true, false));
        return new EntityPayload(this.attributes, this.fields, newValue, this.displayOrder, this.actions);
    }

    public final EntityPayload withCustomFields(Iterable<? extends EntityPayloadAttributesCustomField> elements) {
        if (this.customFields == elements) {
            return this;
        }
        List<EntityPayloadAttributesCustomField> newValue = EntityPayload.createUnmodifiableList(false, EntityPayload.createSafeList(elements, true, false));
        return new EntityPayload(this.attributes, this.fields, newValue, this.displayOrder, this.actions);
    }

    public final EntityPayload withDisplayOrder(String ... elements) {
        List<String> newValue = EntityPayload.createUnmodifiableList(false, EntityPayload.createSafeList(Arrays.asList(elements), true, false));
        return new EntityPayload(this.attributes, this.fields, this.customFields, newValue, this.actions);
    }

    public final EntityPayload withDisplayOrder(Iterable<String> elements) {
        if (this.displayOrder == elements) {
            return this;
        }
        List<String> newValue = EntityPayload.createUnmodifiableList(false, EntityPayload.createSafeList(elements, true, false));
        return new EntityPayload(this.attributes, this.fields, this.customFields, newValue, this.actions);
    }

    public final EntityPayload withActions(@Nullable WorkObjectActionBlock value) {
        WorkObjectActionBlock newValue = value;
        if (this.actions == newValue) {
            return this;
        }
        return new EntityPayload(this.attributes, this.fields, this.customFields, this.displayOrder, newValue);
    }

    public final EntityPayload withActions(Optional<? extends WorkObjectActionBlock> optional) {
        WorkObjectActionBlock value = optional.orElse(null);
        if (this.actions == value) {
            return this;
        }
        return new EntityPayload(this.attributes, this.fields, this.customFields, this.displayOrder, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EntityPayload && this.equalTo(0, (EntityPayload)another);
    }

    private boolean equalTo(int synthetic, EntityPayload another) {
        return this.attributes.equals(another.attributes) && Objects.equals(this.fields, another.fields) && this.customFields.equals(another.customFields) && this.displayOrder.equals(another.displayOrder) && Objects.equals(this.actions, another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attributes.hashCode();
        h += (h << 5) + Objects.hashCode(this.fields);
        h += (h << 5) + this.customFields.hashCode();
        h += (h << 5) + this.displayOrder.hashCode();
        h += (h << 5) + Objects.hashCode(this.actions);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EntityPayload{");
        builder.append("attributes=").append(this.attributes);
        if (this.fields != null) {
            builder.append(", ");
            builder.append("fields=").append(this.fields);
        }
        builder.append(", ");
        builder.append("customFields=").append(this.customFields);
        builder.append(", ");
        builder.append("displayOrder=").append(this.displayOrder);
        if (this.actions != null) {
            builder.append(", ");
            builder.append("actions=").append(this.actions);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static EntityPayload fromJson(Json json) {
        Builder builder = EntityPayload.builder();
        if (json.attributes != null) {
            builder.setAttributes(json.attributes);
        }
        if (json.fields != null) {
            builder.setFields(json.fields);
        }
        if (json.customFields != null) {
            builder.addAllCustomFields(json.customFields);
        }
        if (json.displayOrder != null) {
            builder.addAllDisplayOrder(json.displayOrder);
        }
        if (json.actions != null) {
            builder.setActions(json.actions);
        }
        return builder.build();
    }

    public static EntityPayload copyOf(EntityPayloadIF instance) {
        if (instance instanceof EntityPayload) {
            return (EntityPayload)instance;
        }
        return EntityPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EntityPayloadIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ATTRIBUTES = 1L;
        private long initBits = 1L;
        @Nullable
        private EntityPayloadAttributes attributes;
        @Nullable
        private EntityPayloadFields fields;
        private List<EntityPayloadAttributesCustomField> customFields = new ArrayList<EntityPayloadAttributesCustomField>();
        private List<String> displayOrder = new ArrayList<String>();
        @Nullable
        private WorkObjectActionBlock actions;

        private Builder() {
        }

        public final Builder from(EntityPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setAttributes(instance.getAttributes());
            Optional<EntityPayloadFields> fieldsOptional = instance.getFields();
            if (fieldsOptional.isPresent()) {
                this.setFields(fieldsOptional);
            }
            this.addAllCustomFields(instance.getCustomFields());
            this.addAllDisplayOrder(instance.getDisplayOrder());
            Optional<WorkObjectActionBlock> actionsOptional = instance.getActions();
            if (actionsOptional.isPresent()) {
                this.setActions(actionsOptional);
            }
            return this;
        }

        public final Builder setAttributes(EntityPayloadAttributes attributes) {
            this.attributes = Objects.requireNonNull(attributes, "attributes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setFields(@Nullable EntityPayloadFields fields) {
            this.fields = fields;
            return this;
        }

        public final Builder setFields(Optional<? extends EntityPayloadFields> fields) {
            this.fields = fields.orElse(null);
            return this;
        }

        public final Builder addCustomFields(EntityPayloadAttributesCustomField element) {
            this.customFields.add(Objects.requireNonNull(element, "customFields element"));
            return this;
        }

        public final Builder addCustomFields(EntityPayloadAttributesCustomField ... elements) {
            for (EntityPayloadAttributesCustomField element : elements) {
                this.customFields.add(Objects.requireNonNull(element, "customFields element"));
            }
            return this;
        }

        public final Builder setCustomFields(Iterable<? extends EntityPayloadAttributesCustomField> elements) {
            this.customFields.clear();
            return this.addAllCustomFields(elements);
        }

        public final Builder addAllCustomFields(Iterable<? extends EntityPayloadAttributesCustomField> elements) {
            for (EntityPayloadAttributesCustomField entityPayloadAttributesCustomField : elements) {
                this.customFields.add(Objects.requireNonNull(entityPayloadAttributesCustomField, "customFields element"));
            }
            return this;
        }

        public final Builder addDisplayOrder(String element) {
            this.displayOrder.add(Objects.requireNonNull(element, "displayOrder element"));
            return this;
        }

        public final Builder addDisplayOrder(String ... elements) {
            for (String element : elements) {
                this.displayOrder.add(Objects.requireNonNull(element, "displayOrder element"));
            }
            return this;
        }

        public final Builder setDisplayOrder(Iterable<String> elements) {
            this.displayOrder.clear();
            return this.addAllDisplayOrder(elements);
        }

        public final Builder addAllDisplayOrder(Iterable<String> elements) {
            for (String element : elements) {
                this.displayOrder.add(Objects.requireNonNull(element, "displayOrder element"));
            }
            return this;
        }

        public final Builder setActions(@Nullable WorkObjectActionBlock actions) {
            this.actions = actions;
            return this;
        }

        public final Builder setActions(Optional<? extends WorkObjectActionBlock> actions) {
            this.actions = actions.orElse(null);
            return this;
        }

        public EntityPayload build() {
            this.checkRequiredAttributes();
            return new EntityPayload(this.attributes, this.fields, EntityPayload.createUnmodifiableList(true, this.customFields), EntityPayload.createUnmodifiableList(true, this.displayOrder), this.actions);
        }

        private boolean attributesIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.attributesIsSet()) {
                attributes.add("attributes");
            }
            return "Cannot build EntityPayload, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntityPayloadIF", generator="Immutables")
    static final class Json
    implements EntityPayloadIF {
        @Nullable
        EntityPayloadAttributes attributes;
        @Nullable
        Optional<EntityPayloadFields> fields = Optional.empty();
        @Nullable
        List<EntityPayloadAttributesCustomField> customFields = Collections.emptyList();
        @Nullable
        List<String> displayOrder = Collections.emptyList();
        @Nullable
        Optional<WorkObjectActionBlock> actions = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setAttributes(EntityPayloadAttributes attributes) {
            this.attributes = attributes;
        }

        @JsonProperty
        public void setFields(Optional<EntityPayloadFields> fields) {
            this.fields = fields;
        }

        @JsonProperty
        public void setCustomFields(List<EntityPayloadAttributesCustomField> customFields) {
            this.customFields = customFields;
        }

        @JsonProperty
        public void setDisplayOrder(List<String> displayOrder) {
            this.displayOrder = displayOrder;
        }

        @JsonProperty
        public void setActions(Optional<WorkObjectActionBlock> actions) {
            this.actions = actions;
        }

        @Override
        public EntityPayloadAttributes getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<EntityPayloadFields> getFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EntityPayloadAttributesCustomField> getCustomFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDisplayOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WorkObjectActionBlock> getActions() {
            throw new UnsupportedOperationException();
        }
    }
}

