/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectAction;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectActionBlockIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WorkObjectActionBlockIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class WorkObjectActionBlock
implements WorkObjectActionBlockIF {
    private final List<WorkObjectAction> primaryActions;
    private final List<WorkObjectAction> overflowActions;

    private WorkObjectActionBlock(List<WorkObjectAction> primaryActions, List<WorkObjectAction> overflowActions) {
        this.primaryActions = primaryActions;
        this.overflowActions = overflowActions;
    }

    @Override
    @JsonProperty
    public List<WorkObjectAction> getPrimaryActions() {
        return this.primaryActions;
    }

    @Override
    @JsonProperty
    public List<WorkObjectAction> getOverflowActions() {
        return this.overflowActions;
    }

    public final WorkObjectActionBlock withPrimaryActions(WorkObjectAction ... elements) {
        List<WorkObjectAction> newValue = WorkObjectActionBlock.createUnmodifiableList(false, WorkObjectActionBlock.createSafeList(Arrays.asList(elements), true, false));
        return new WorkObjectActionBlock(newValue, this.overflowActions);
    }

    public final WorkObjectActionBlock withPrimaryActions(Iterable<? extends WorkObjectAction> elements) {
        if (this.primaryActions == elements) {
            return this;
        }
        List<WorkObjectAction> newValue = WorkObjectActionBlock.createUnmodifiableList(false, WorkObjectActionBlock.createSafeList(elements, true, false));
        return new WorkObjectActionBlock(newValue, this.overflowActions);
    }

    public final WorkObjectActionBlock withOverflowActions(WorkObjectAction ... elements) {
        List<WorkObjectAction> newValue = WorkObjectActionBlock.createUnmodifiableList(false, WorkObjectActionBlock.createSafeList(Arrays.asList(elements), true, false));
        return new WorkObjectActionBlock(this.primaryActions, newValue);
    }

    public final WorkObjectActionBlock withOverflowActions(Iterable<? extends WorkObjectAction> elements) {
        if (this.overflowActions == elements) {
            return this;
        }
        List<WorkObjectAction> newValue = WorkObjectActionBlock.createUnmodifiableList(false, WorkObjectActionBlock.createSafeList(elements, true, false));
        return new WorkObjectActionBlock(this.primaryActions, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WorkObjectActionBlock && this.equalTo(0, (WorkObjectActionBlock)another);
    }

    private boolean equalTo(int synthetic, WorkObjectActionBlock another) {
        return this.primaryActions.equals(another.primaryActions) && this.overflowActions.equals(another.overflowActions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.primaryActions.hashCode();
        h += (h << 5) + this.overflowActions.hashCode();
        return h;
    }

    public String toString() {
        return "WorkObjectActionBlock{primaryActions=" + String.valueOf(this.primaryActions) + ", overflowActions=" + String.valueOf(this.overflowActions) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static WorkObjectActionBlock fromJson(Json json) {
        Builder builder = WorkObjectActionBlock.builder();
        if (json.primaryActions != null) {
            builder.addAllPrimaryActions(json.primaryActions);
        }
        if (json.overflowActions != null) {
            builder.addAllOverflowActions(json.overflowActions);
        }
        return builder.build();
    }

    public static WorkObjectActionBlock copyOf(WorkObjectActionBlockIF instance) {
        if (instance instanceof WorkObjectActionBlock) {
            return (WorkObjectActionBlock)instance;
        }
        return WorkObjectActionBlock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WorkObjectActionBlockIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<WorkObjectAction> primaryActions = new ArrayList<WorkObjectAction>();
        private List<WorkObjectAction> overflowActions = new ArrayList<WorkObjectAction>();

        private Builder() {
        }

        public final Builder from(WorkObjectActionBlockIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPrimaryActions(instance.getPrimaryActions());
            this.addAllOverflowActions(instance.getOverflowActions());
            return this;
        }

        public final Builder addPrimaryActions(WorkObjectAction element) {
            this.primaryActions.add(Objects.requireNonNull(element, "primaryActions element"));
            return this;
        }

        public final Builder addPrimaryActions(WorkObjectAction ... elements) {
            for (WorkObjectAction element : elements) {
                this.primaryActions.add(Objects.requireNonNull(element, "primaryActions element"));
            }
            return this;
        }

        public final Builder setPrimaryActions(Iterable<? extends WorkObjectAction> elements) {
            this.primaryActions.clear();
            return this.addAllPrimaryActions(elements);
        }

        public final Builder addAllPrimaryActions(Iterable<? extends WorkObjectAction> elements) {
            for (WorkObjectAction workObjectAction : elements) {
                this.primaryActions.add(Objects.requireNonNull(workObjectAction, "primaryActions element"));
            }
            return this;
        }

        public final Builder addOverflowActions(WorkObjectAction element) {
            this.overflowActions.add(Objects.requireNonNull(element, "overflowActions element"));
            return this;
        }

        public final Builder addOverflowActions(WorkObjectAction ... elements) {
            for (WorkObjectAction element : elements) {
                this.overflowActions.add(Objects.requireNonNull(element, "overflowActions element"));
            }
            return this;
        }

        public final Builder setOverflowActions(Iterable<? extends WorkObjectAction> elements) {
            this.overflowActions.clear();
            return this.addAllOverflowActions(elements);
        }

        public final Builder addAllOverflowActions(Iterable<? extends WorkObjectAction> elements) {
            for (WorkObjectAction workObjectAction : elements) {
                this.overflowActions.add(Objects.requireNonNull(workObjectAction, "overflowActions element"));
            }
            return this;
        }

        public WorkObjectActionBlock build() {
            return new WorkObjectActionBlock(WorkObjectActionBlock.createUnmodifiableList(true, this.primaryActions), WorkObjectActionBlock.createUnmodifiableList(true, this.overflowActions));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkObjectActionBlockIF", generator="Immutables")
    static final class Json
    implements WorkObjectActionBlockIF {
        @Nullable
        List<WorkObjectAction> primaryActions = Collections.emptyList();
        @Nullable
        List<WorkObjectAction> overflowActions = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setPrimaryActions(List<WorkObjectAction> primaryActions) {
            this.primaryActions = primaryActions;
        }

        @JsonProperty
        public void setOverflowActions(List<WorkObjectAction> overflowActions) {
            this.overflowActions = overflowActions;
        }

        @Override
        public List<WorkObjectAction> getPrimaryActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WorkObjectAction> getOverflowActions() {
            throw new UnsupportedOperationException();
        }
    }
}

