/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectActionIF;
import com.hubspot.slack.client.methods.params.chat.workobject.actions.WorkObjectActionStyle;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WorkObjectActionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class WorkObjectAction
implements WorkObjectActionIF {
    private final String text;
    private final String actionId;
    @Nullable
    private final String value;
    @Nullable
    private final WorkObjectActionStyle style;
    @Nullable
    private final String url;
    @Nullable
    private final String accessibilityLabel;

    private WorkObjectAction(String text, String actionId, @Nullable String value, @Nullable WorkObjectActionStyle style, @Nullable String url, @Nullable String accessibilityLabel) {
        this.text = text;
        this.actionId = actionId;
        this.value = value;
        this.style = style;
        this.url = url;
        this.accessibilityLabel = accessibilityLabel;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public Optional<WorkObjectActionStyle> getStyle() {
        return Optional.ofNullable(this.style);
    }

    @Override
    @JsonProperty
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    @JsonProperty
    public Optional<String> getAccessibilityLabel() {
        return Optional.ofNullable(this.accessibilityLabel);
    }

    public final WorkObjectAction withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new WorkObjectAction(newValue, this.actionId, this.value, this.style, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new WorkObjectAction(this.text, newValue, this.value, this.style, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, newValue, this.style, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, value, this.style, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withStyle(@Nullable WorkObjectActionStyle value) {
        WorkObjectActionStyle newValue = value;
        if (this.style == newValue) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, newValue, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withStyle(Optional<? extends WorkObjectActionStyle> optional) {
        WorkObjectActionStyle value = optional.orElse(null);
        if (this.style == value) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, value, this.url, this.accessibilityLabel);
    }

    public final WorkObjectAction withUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, this.style, newValue, this.accessibilityLabel);
    }

    public final WorkObjectAction withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, this.style, value, this.accessibilityLabel);
    }

    public final WorkObjectAction withAccessibilityLabel(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.accessibilityLabel, newValue)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, this.style, this.url, newValue);
    }

    public final WorkObjectAction withAccessibilityLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accessibilityLabel, value)) {
            return this;
        }
        return new WorkObjectAction(this.text, this.actionId, this.value, this.style, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WorkObjectAction && this.equalTo(0, (WorkObjectAction)another);
    }

    private boolean equalTo(int synthetic, WorkObjectAction another) {
        return this.text.equals(another.text) && this.actionId.equals(another.actionId) && Objects.equals(this.value, another.value) && Objects.equals((Object)this.style, (Object)another.style) && Objects.equals(this.url, another.url) && Objects.equals(this.accessibilityLabel, another.accessibilityLabel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode((Object)this.style);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.accessibilityLabel);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WorkObjectAction{");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        if (this.style != null) {
            builder.append(", ");
            builder.append("style=").append((Object)this.style);
        }
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        if (this.accessibilityLabel != null) {
            builder.append(", ");
            builder.append("accessibilityLabel=").append(this.accessibilityLabel);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static WorkObjectAction fromJson(Json json) {
        Builder builder = WorkObjectAction.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.style != null) {
            builder.setStyle(json.style);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.accessibilityLabel != null) {
            builder.setAccessibilityLabel(json.accessibilityLabel);
        }
        return builder.build();
    }

    public static WorkObjectAction copyOf(WorkObjectActionIF instance) {
        if (instance instanceof WorkObjectAction) {
            return (WorkObjectAction)instance;
        }
        return WorkObjectAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WorkObjectActionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String text;
        @Nullable
        private String actionId;
        @Nullable
        private String value;
        @Nullable
        private WorkObjectActionStyle style;
        @Nullable
        private String url;
        @Nullable
        private String accessibilityLabel;

        private Builder() {
        }

        public final Builder from(WorkObjectActionIF instance) {
            Optional<String> accessibilityLabelOptional;
            Optional<String> urlOptional;
            Optional<WorkObjectActionStyle> styleOptional;
            Objects.requireNonNull(instance, "instance");
            this.setText(instance.getText());
            this.setActionId(instance.getActionId());
            Optional<String> valueOptional = instance.getValue();
            if (valueOptional.isPresent()) {
                this.setValue(valueOptional);
            }
            if ((styleOptional = instance.getStyle()).isPresent()) {
                this.setStyle(styleOptional);
            }
            if ((urlOptional = instance.getUrl()).isPresent()) {
                this.setUrl(urlOptional);
            }
            if ((accessibilityLabelOptional = instance.getAccessibilityLabel()).isPresent()) {
                this.setAccessibilityLabel(accessibilityLabelOptional);
            }
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setStyle(@Nullable WorkObjectActionStyle style) {
            this.style = style;
            return this;
        }

        public final Builder setStyle(Optional<? extends WorkObjectActionStyle> style) {
            this.style = style.orElse(null);
            return this;
        }

        public final Builder setUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder setUrl(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public final Builder setAccessibilityLabel(@Nullable String accessibilityLabel) {
            this.accessibilityLabel = accessibilityLabel;
            return this;
        }

        public final Builder setAccessibilityLabel(Optional<String> accessibilityLabel) {
            this.accessibilityLabel = accessibilityLabel.orElse(null);
            return this;
        }

        public WorkObjectAction build() {
            this.checkRequiredAttributes();
            return new WorkObjectAction(this.text, this.actionId, this.value, this.style, this.url, this.accessibilityLabel);
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build WorkObjectAction, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkObjectActionIF", generator="Immutables")
    static final class Json
    implements WorkObjectActionIF {
        @Nullable
        String text;
        @Nullable
        String actionId;
        @Nullable
        Optional<String> value = Optional.empty();
        @Nullable
        Optional<WorkObjectActionStyle> style = Optional.empty();
        @Nullable
        Optional<String> url = Optional.empty();
        @Nullable
        Optional<String> accessibilityLabel = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setStyle(Optional<WorkObjectActionStyle> style) {
            this.style = style;
        }

        @JsonProperty
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @JsonProperty
        public void setAccessibilityLabel(Optional<String> accessibilityLabel) {
            this.accessibilityLabel = accessibilityLabel;
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WorkObjectActionStyle> getStyle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAccessibilityLabel() {
            throw new UnsupportedOperationException();
        }
    }
}

