/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.EntityType;
import com.hubspot.slack.client.methods.params.chat.workobject.ExternalRef;
import com.hubspot.slack.client.methods.params.chat.workobject.WorkObjectBase;
import com.hubspot.slack.client.methods.params.chat.workobject.WorkObjectIF;
import com.hubspot.slack.client.methods.params.chat.workobject.entity.EntityPayload;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.EntityTypeDeserializer;
import com.hubspot.slack.client.methods.params.chat.workobject.serializers.EntityTypeSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WorkObjectIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class WorkObject
implements WorkObjectIF {
    private final EntityType entityType;
    private final EntityPayload entityPayload;
    private final String url;
    private final ExternalRef externalRef;
    private final String appUnfurlUrl;

    private WorkObject(EntityType entityType, EntityPayload entityPayload, String url, ExternalRef externalRef, String appUnfurlUrl) {
        this.entityType = entityType;
        this.entityPayload = entityPayload;
        this.url = url;
        this.externalRef = externalRef;
        this.appUnfurlUrl = appUnfurlUrl;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=EntityTypeSerializer.class)
    @JsonDeserialize(using=EntityTypeDeserializer.class)
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    @JsonProperty
    public EntityPayload getEntityPayload() {
        return this.entityPayload;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty
    public ExternalRef getExternalRef() {
        return this.externalRef;
    }

    @Override
    @JsonProperty
    public String getAppUnfurlUrl() {
        return this.appUnfurlUrl;
    }

    public final WorkObject withEntityType(EntityType value) {
        EntityType newValue = Objects.requireNonNull(value, "entityType");
        if (this.entityType == newValue) {
            return this;
        }
        return new WorkObject(newValue, this.entityPayload, this.url, this.externalRef, this.appUnfurlUrl);
    }

    public final WorkObject withEntityPayload(EntityPayload value) {
        if (this.entityPayload == value) {
            return this;
        }
        EntityPayload newValue = Objects.requireNonNull(value, "entityPayload");
        return new WorkObject(this.entityType, newValue, this.url, this.externalRef, this.appUnfurlUrl);
    }

    public final WorkObject withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new WorkObject(this.entityType, this.entityPayload, newValue, this.externalRef, this.appUnfurlUrl);
    }

    public final WorkObject withExternalRef(ExternalRef value) {
        if (this.externalRef == value) {
            return this;
        }
        ExternalRef newValue = Objects.requireNonNull(value, "externalRef");
        return new WorkObject(this.entityType, this.entityPayload, this.url, newValue, this.appUnfurlUrl);
    }

    public final WorkObject withAppUnfurlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "appUnfurlUrl");
        if (this.appUnfurlUrl.equals(newValue)) {
            return this;
        }
        return new WorkObject(this.entityType, this.entityPayload, this.url, this.externalRef, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WorkObject && this.equalTo(0, (WorkObject)another);
    }

    private boolean equalTo(int synthetic, WorkObject another) {
        return this.entityType.equals((Object)another.entityType) && this.entityPayload.equals(another.entityPayload) && this.url.equals(another.url) && this.externalRef.equals(another.externalRef) && this.appUnfurlUrl.equals(another.appUnfurlUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entityType.hashCode();
        h += (h << 5) + this.entityPayload.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.externalRef.hashCode();
        h += (h << 5) + this.appUnfurlUrl.hashCode();
        return h;
    }

    public String toString() {
        return "WorkObject{entityType=" + String.valueOf((Object)this.entityType) + ", entityPayload=" + String.valueOf(this.entityPayload) + ", url=" + this.url + ", externalRef=" + String.valueOf(this.externalRef) + ", appUnfurlUrl=" + this.appUnfurlUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static WorkObject fromJson(Json json) {
        Builder builder = WorkObject.builder();
        if (json.entityType != null) {
            builder.setEntityType(json.entityType);
        }
        if (json.entityPayload != null) {
            builder.setEntityPayload(json.entityPayload);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.externalRef != null) {
            builder.setExternalRef(json.externalRef);
        }
        if (json.appUnfurlUrl != null) {
            builder.setAppUnfurlUrl(json.appUnfurlUrl);
        }
        return builder.build();
    }

    public static WorkObject copyOf(WorkObjectIF instance) {
        if (instance instanceof WorkObject) {
            return (WorkObject)instance;
        }
        return WorkObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WorkObjectIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_TYPE = 1L;
        private static final long INIT_BIT_ENTITY_PAYLOAD = 2L;
        private static final long INIT_BIT_URL = 4L;
        private static final long INIT_BIT_EXTERNAL_REF = 8L;
        private static final long INIT_BIT_APP_UNFURL_URL = 16L;
        private long initBits = 31L;
        @Nullable
        private EntityType entityType;
        @Nullable
        private EntityPayload entityPayload;
        @Nullable
        private String url;
        @Nullable
        private ExternalRef externalRef;
        @Nullable
        private String appUnfurlUrl;

        private Builder() {
        }

        public final Builder from(WorkObjectIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(WorkObjectBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            WorkObjectBase instance;
            long bits = 0L;
            if (object instanceof WorkObjectIF) {
                instance = (WorkObjectIF)object;
                this.setAppUnfurlUrl(instance.getAppUnfurlUrl());
                if ((bits & 4L) == 0L) {
                    this.setExternalRef(instance.getExternalRef());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.setEntityType(instance.getEntityType());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.setUrl(instance.getUrl());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.setEntityPayload(instance.getEntityPayload());
                    bits |= 2L;
                }
            }
            if (object instanceof WorkObjectBase) {
                instance = (WorkObjectBase)object;
                if ((bits & 4L) == 0L) {
                    this.setExternalRef(instance.getExternalRef());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.setEntityType(instance.getEntityType());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.setUrl(instance.getUrl());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.setEntityPayload(instance.getEntityPayload());
                    bits |= 2L;
                }
            }
        }

        public final Builder setEntityType(EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setEntityPayload(EntityPayload entityPayload) {
            this.entityPayload = Objects.requireNonNull(entityPayload, "entityPayload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setExternalRef(ExternalRef externalRef) {
            this.externalRef = Objects.requireNonNull(externalRef, "externalRef");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setAppUnfurlUrl(String appUnfurlUrl) {
            this.appUnfurlUrl = Objects.requireNonNull(appUnfurlUrl, "appUnfurlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public WorkObject build() {
            this.checkRequiredAttributes();
            return new WorkObject(this.entityType, this.entityPayload, this.url, this.externalRef, this.appUnfurlUrl);
        }

        private boolean entityTypeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean entityPayloadIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean externalRefIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean appUnfurlUrlIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.entityTypeIsSet()) {
                attributes.add("entityType");
            }
            if (!this.entityPayloadIsSet()) {
                attributes.add("entityPayload");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.externalRefIsSet()) {
                attributes.add("externalRef");
            }
            if (!this.appUnfurlUrlIsSet()) {
                attributes.add("appUnfurlUrl");
            }
            return "Cannot build WorkObject, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkObjectIF", generator="Immutables")
    static final class Json
    implements WorkObjectIF {
        @Nullable
        EntityType entityType;
        @Nullable
        EntityPayload entityPayload;
        @Nullable
        String url;
        @Nullable
        ExternalRef externalRef;
        @Nullable
        String appUnfurlUrl;

        Json() {
        }

        @JsonProperty
        @JsonSerialize(using=EntityTypeSerializer.class)
        @JsonDeserialize(using=EntityTypeDeserializer.class)
        public void setEntityType(EntityType entityType) {
            this.entityType = entityType;
        }

        @JsonProperty
        public void setEntityPayload(EntityPayload entityPayload) {
            this.entityPayload = entityPayload;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setExternalRef(ExternalRef externalRef) {
            this.externalRef = externalRef;
        }

        @JsonProperty
        public void setAppUnfurlUrl(String appUnfurlUrl) {
            this.appUnfurlUrl = appUnfurlUrl;
        }

        @Override
        public EntityType getEntityType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityPayload getEntityPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExternalRef getExternalRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAppUnfurlUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

