/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat.workobject;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.chat.workobject.MetadataIF;
import com.hubspot.slack.client.methods.params.chat.workobject.WorkObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MetadataIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Metadata
implements MetadataIF {
    private final List<WorkObject> entities;

    private Metadata(List<WorkObject> entities) {
        this.entities = entities;
    }

    @Override
    @JsonProperty
    public List<WorkObject> getEntities() {
        return this.entities;
    }

    public final Metadata withEntities(WorkObject ... elements) {
        List<WorkObject> newValue = Metadata.createUnmodifiableList(false, Metadata.createSafeList(Arrays.asList(elements), true, false));
        return new Metadata(newValue);
    }

    public final Metadata withEntities(Iterable<? extends WorkObject> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<WorkObject> newValue = Metadata.createUnmodifiableList(false, Metadata.createSafeList(elements, true, false));
        return new Metadata(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Metadata && this.equalTo(0, (Metadata)another);
    }

    private boolean equalTo(int synthetic, Metadata another) {
        return this.entities.equals(another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entities.hashCode();
        return h;
    }

    public String toString() {
        return "Metadata{entities=" + String.valueOf(this.entities) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Metadata fromJson(Json json) {
        Builder builder = Metadata.builder();
        if (json.entities != null) {
            builder.addAllEntities(json.entities);
        }
        return builder.build();
    }

    public static Metadata copyOf(MetadataIF instance) {
        if (instance instanceof Metadata) {
            return (Metadata)instance;
        }
        return Metadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MetadataIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<WorkObject> entities = new ArrayList<WorkObject>();

        private Builder() {
        }

        public final Builder from(MetadataIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEntities(instance.getEntities());
            return this;
        }

        public final Builder addEntities(WorkObject element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(WorkObject ... elements) {
            for (WorkObject element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder setEntities(Iterable<? extends WorkObject> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends WorkObject> elements) {
            for (WorkObject workObject : elements) {
                this.entities.add(Objects.requireNonNull(workObject, "entities element"));
            }
            return this;
        }

        public Metadata build() {
            return new Metadata(Metadata.createUnmodifiableList(true, this.entities));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MetadataIF", generator="Immutables")
    static final class Json
    implements MetadataIF {
        @Nullable
        List<WorkObject> entities = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setEntities(List<WorkObject> entities) {
            this.entities = entities;
        }

        @Override
        public List<WorkObject> getEntities() {
            throw new UnsupportedOperationException();
        }
    }
}

