/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatUnfurlParamsIF;
import com.hubspot.slack.client.methods.params.chat.workobject.Metadata;
import com.hubspot.slack.client.models.ChatUnfurlBlocksOrAttachment;
import com.hubspot.slack.client.models.json.BlockOrAttachmentDeserializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatUnfurlParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatUnfurlParams
implements ChatUnfurlParamsIF {
    private final String channelId;
    private final String ts;
    private final Map<String, ChatUnfurlBlocksOrAttachment> unfurls;
    @Nullable
    private final Boolean isUserAuthRequired;
    @Nullable
    private final String userAuthMessage;
    @Nullable
    private final URI userAuthUrl;
    @Nullable
    private final Metadata metadata;

    private ChatUnfurlParams(String channelId, String ts, Map<String, ChatUnfurlBlocksOrAttachment> unfurls, @Nullable Boolean isUserAuthRequired, @Nullable String userAuthMessage, @Nullable URI userAuthUrl, @Nullable Metadata metadata) {
        this.channelId = channelId;
        this.ts = ts;
        this.unfurls = unfurls;
        this.isUserAuthRequired = isUserAuthRequired;
        this.userAuthMessage = userAuthMessage;
        this.userAuthUrl = userAuthUrl;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=BlockOrAttachmentDeserializer.class)
    public Map<String, ChatUnfurlBlocksOrAttachment> getUnfurls() {
        return this.unfurls;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsUserAuthRequired() {
        return Optional.ofNullable(this.isUserAuthRequired);
    }

    @Override
    @JsonProperty
    public Optional<String> getUserAuthMessage() {
        return Optional.ofNullable(this.userAuthMessage);
    }

    @Override
    @JsonProperty
    public Optional<URI> getUserAuthUrl() {
        return Optional.ofNullable(this.userAuthUrl);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public final ChatUnfurlParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatUnfurlParams(newValue, this.ts, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, newValue, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withUnfurls(Map<String, ? extends ChatUnfurlBlocksOrAttachment> entries) {
        if (this.unfurls == entries) {
            return this;
        }
        Map<String, ChatUnfurlBlocksOrAttachment> newValue = ChatUnfurlParams.createUnmodifiableMap(true, false, entries);
        return new ChatUnfurlParams(this.channelId, this.ts, newValue, this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withIsUserAuthRequired(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isUserAuthRequired, newValue)) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, newValue, this.userAuthMessage, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withIsUserAuthRequired(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isUserAuthRequired, value)) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, value, this.userAuthMessage, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withUserAuthMessage(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.userAuthMessage, newValue)) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, newValue, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withUserAuthMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userAuthMessage, value)) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, value, this.userAuthUrl, this.metadata);
    }

    public final ChatUnfurlParams withUserAuthUrl(@Nullable URI value) {
        URI newValue = value;
        if (this.userAuthUrl == newValue) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, newValue, this.metadata);
    }

    public final ChatUnfurlParams withUserAuthUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.userAuthUrl == value) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, value, this.metadata);
    }

    public final ChatUnfurlParams withMetadata(@Nullable Metadata value) {
        Metadata newValue = value;
        if (this.metadata == newValue) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, newValue);
    }

    public final ChatUnfurlParams withMetadata(Optional<? extends Metadata> optional) {
        Metadata value = optional.orElse(null);
        if (this.metadata == value) {
            return this;
        }
        return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatUnfurlParams && this.equalTo(0, (ChatUnfurlParams)another);
    }

    private boolean equalTo(int synthetic, ChatUnfurlParams another) {
        return this.channelId.equals(another.channelId) && this.ts.equals(another.ts) && this.unfurls.equals(another.unfurls) && Objects.equals(this.isUserAuthRequired, another.isUserAuthRequired) && Objects.equals(this.userAuthMessage, another.userAuthMessage) && Objects.equals(this.userAuthUrl, another.userAuthUrl) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + this.unfurls.hashCode();
        h += (h << 5) + Objects.hashCode(this.isUserAuthRequired);
        h += (h << 5) + Objects.hashCode(this.userAuthMessage);
        h += (h << 5) + Objects.hashCode(this.userAuthUrl);
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatUnfurlParams{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        builder.append(", ");
        builder.append("unfurls=").append(this.unfurls);
        if (this.isUserAuthRequired != null) {
            builder.append(", ");
            builder.append("isUserAuthRequired=").append(this.isUserAuthRequired);
        }
        if (this.userAuthMessage != null) {
            builder.append(", ");
            builder.append("userAuthMessage=").append(this.userAuthMessage);
        }
        if (this.userAuthUrl != null) {
            builder.append(", ");
            builder.append("userAuthUrl=").append(this.userAuthUrl);
        }
        if (this.metadata != null) {
            builder.append(", ");
            builder.append("metadata=").append(this.metadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatUnfurlParams fromJson(Json json) {
        Builder builder = ChatUnfurlParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.unfurls != null) {
            builder.putAllUnfurls(json.unfurls);
        }
        if (json.isUserAuthRequired != null) {
            builder.setIsUserAuthRequired(json.isUserAuthRequired);
        }
        if (json.userAuthMessage != null) {
            builder.setUserAuthMessage(json.userAuthMessage);
        }
        if (json.userAuthUrl != null) {
            builder.setUserAuthUrl(json.userAuthUrl);
        }
        if (json.metadata != null) {
            builder.setMetadata(json.metadata);
        }
        return builder.build();
    }

    public static ChatUnfurlParams copyOf(ChatUnfurlParamsIF instance) {
        if (instance instanceof ChatUnfurlParams) {
            return (ChatUnfurlParams)instance;
        }
        return ChatUnfurlParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ChatUnfurlParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String ts;
        private Map<String, ChatUnfurlBlocksOrAttachment> unfurls = new LinkedHashMap<String, ChatUnfurlBlocksOrAttachment>();
        @Nullable
        private Boolean isUserAuthRequired;
        @Nullable
        private String userAuthMessage;
        @Nullable
        private URI userAuthUrl;
        @Nullable
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatUnfurlParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatUnfurlParamsIF) {
                Optional<String> userAuthMessageOptional;
                Optional<Metadata> metadataOptional;
                instance = (ChatUnfurlParamsIF)object;
                Optional<Boolean> isUserAuthRequiredOptional = instance.getIsUserAuthRequired();
                if (isUserAuthRequiredOptional.isPresent()) {
                    this.setIsUserAuthRequired(isUserAuthRequiredOptional);
                }
                if ((metadataOptional = instance.getMetadata()).isPresent()) {
                    this.setMetadata(metadataOptional);
                }
                this.putAllUnfurls(instance.getUnfurls());
                Optional<URI> userAuthUrlOptional = instance.getUserAuthUrl();
                if (userAuthUrlOptional.isPresent()) {
                    this.setUserAuthUrl(userAuthUrlOptional);
                }
                if ((userAuthMessageOptional = instance.getUserAuthMessage()).isPresent()) {
                    this.setUserAuthMessage(userAuthMessageOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
                this.setTs(instance.getTs());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putUnfurls(String key, ChatUnfurlBlocksOrAttachment value) {
            this.unfurls.put(Objects.requireNonNull(key, "unfurls key"), Objects.requireNonNull(value, value == null ? "unfurls value for key: " + key : null));
            return this;
        }

        public final Builder putUnfurls(Map.Entry<String, ? extends ChatUnfurlBlocksOrAttachment> entry) {
            ChatUnfurlBlocksOrAttachment v;
            String k = entry.getKey();
            this.unfurls.put(Objects.requireNonNull(k, "unfurls key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "unfurls value for key: " + k : null));
            return this;
        }

        public final Builder setUnfurls(Map<String, ? extends ChatUnfurlBlocksOrAttachment> entries) {
            this.unfurls.clear();
            return this.putAllUnfurls(entries);
        }

        public final Builder putAllUnfurls(Map<String, ? extends ChatUnfurlBlocksOrAttachment> entries) {
            for (Map.Entry<String, ? extends ChatUnfurlBlocksOrAttachment> e : entries.entrySet()) {
                ChatUnfurlBlocksOrAttachment v;
                String k = e.getKey();
                this.unfurls.put(Objects.requireNonNull(k, "unfurls key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "unfurls value for key: " + k : null));
            }
            return this;
        }

        public final Builder setIsUserAuthRequired(@Nullable Boolean isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired;
            return this;
        }

        public final Builder setIsUserAuthRequired(Optional<Boolean> isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired.orElse(null);
            return this;
        }

        public final Builder setUserAuthMessage(@Nullable String userAuthMessage) {
            this.userAuthMessage = userAuthMessage;
            return this;
        }

        public final Builder setUserAuthMessage(Optional<String> userAuthMessage) {
            this.userAuthMessage = userAuthMessage.orElse(null);
            return this;
        }

        public final Builder setUserAuthUrl(@Nullable URI userAuthUrl) {
            this.userAuthUrl = userAuthUrl;
            return this;
        }

        public final Builder setUserAuthUrl(Optional<? extends URI> userAuthUrl) {
            this.userAuthUrl = userAuthUrl.orElse(null);
            return this;
        }

        public final Builder setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder setMetadata(Optional<? extends Metadata> metadata) {
            this.metadata = metadata.orElse(null);
            return this;
        }

        public ChatUnfurlParams build() {
            this.checkRequiredAttributes();
            return new ChatUnfurlParams(this.channelId, this.ts, ChatUnfurlParams.createUnmodifiableMap(false, false, this.unfurls), this.isUserAuthRequired, this.userAuthMessage, this.userAuthUrl, this.metadata);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build ChatUnfurlParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatUnfurlParamsIF", generator="Immutables")
    static final class Json
    implements ChatUnfurlParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String ts;
        @Nullable
        Map<String, ChatUnfurlBlocksOrAttachment> unfurls = Collections.emptyMap();
        @Nullable
        Optional<Boolean> isUserAuthRequired = Optional.empty();
        @Nullable
        Optional<String> userAuthMessage = Optional.empty();
        @Nullable
        Optional<URI> userAuthUrl = Optional.empty();
        @Nullable
        Optional<Metadata> metadata = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=BlockOrAttachmentDeserializer.class)
        public void setUnfurls(Map<String, ChatUnfurlBlocksOrAttachment> unfurls) {
            this.unfurls = unfurls;
        }

        @JsonProperty
        public void setIsUserAuthRequired(Optional<Boolean> isUserAuthRequired) {
            this.isUserAuthRequired = isUserAuthRequired;
        }

        @JsonProperty
        public void setUserAuthMessage(Optional<String> userAuthMessage) {
            this.userAuthMessage = userAuthMessage;
        }

        @JsonProperty
        public void setUserAuthUrl(Optional<URI> userAuthUrl) {
            this.userAuthUrl = userAuthUrl;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setMetadata(Optional<Metadata> metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ChatUnfurlBlocksOrAttachment> getUnfurls() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsUserAuthRequired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUserAuthMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> getUserAuthUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Metadata> getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

