/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.ChatScheduledMessagesListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatScheduledMessagesListParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatScheduledMessagesListParams
implements ChatScheduledMessagesListParamsIF {
    private final String channelId;
    private final String cursor;
    private final String newestTimestamp;
    private final String oldestTimestamp;
    private final String teamId;
    private final Integer limit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ChatScheduledMessagesListParams(Builder builder) {
        if (builder.channelId != null) {
            this.initShim.setChannelId(builder.channelId);
        }
        if (builder.cursor != null) {
            this.initShim.setCursor(builder.cursor);
        }
        if (builder.newestTimestamp != null) {
            this.initShim.setNewestTimestamp(builder.newestTimestamp);
        }
        if (builder.oldestTimestamp != null) {
            this.initShim.setOldestTimestamp(builder.oldestTimestamp);
        }
        if (builder.teamId != null) {
            this.initShim.setTeamId(builder.teamId);
        }
        if (builder.limit != null) {
            this.initShim.setLimit(builder.limit);
        }
        this.channelId = this.initShim.getChannelId();
        this.cursor = this.initShim.getCursor();
        this.newestTimestamp = this.initShim.getNewestTimestamp();
        this.oldestTimestamp = this.initShim.getOldestTimestamp();
        this.teamId = this.initShim.getTeamId();
        this.limit = this.initShim.getLimit();
        this.initShim = null;
    }

    private ChatScheduledMessagesListParams(String channelId, String cursor, String newestTimestamp, String oldestTimestamp, String teamId, Integer limit) {
        this.channelId = channelId;
        this.cursor = cursor;
        this.newestTimestamp = newestTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.teamId = teamId;
        this.limit = limit;
        this.initShim = null;
    }

    private String getChannelIdInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getChannelId();
    }

    private String getCursorInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getCursor();
    }

    private String getNewestTimestampInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getNewestTimestamp();
    }

    private String getOldestTimestampInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getOldestTimestamp();
    }

    private String getTeamIdInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getTeamId();
    }

    private Integer getLimitInitialize() {
        return ChatScheduledMessagesListParamsIF.super.getLimit();
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getChannelId() : this.channelId;
    }

    @Override
    @JsonProperty
    public String getCursor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCursor() : this.cursor;
    }

    @Override
    @JsonProperty(value="latest")
    public String getNewestTimestamp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNewestTimestamp() : this.newestTimestamp;
    }

    @Override
    @JsonProperty(value="oldest")
    public String getOldestTimestamp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOldestTimestamp() : this.oldestTimestamp;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTeamId() : this.teamId;
    }

    @Override
    @JsonProperty
    public Integer getLimit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLimit() : this.limit;
    }

    public final ChatScheduledMessagesListParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(newValue, this.cursor, this.newestTimestamp, this.oldestTimestamp, this.teamId, this.limit);
    }

    public final ChatScheduledMessagesListParams withCursor(String value) {
        String newValue = Objects.requireNonNull(value, "cursor");
        if (this.cursor.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(this.channelId, newValue, this.newestTimestamp, this.oldestTimestamp, this.teamId, this.limit);
    }

    public final ChatScheduledMessagesListParams withNewestTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "newestTimestamp");
        if (this.newestTimestamp.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(this.channelId, this.cursor, newValue, this.oldestTimestamp, this.teamId, this.limit);
    }

    public final ChatScheduledMessagesListParams withOldestTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "oldestTimestamp");
        if (this.oldestTimestamp.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(this.channelId, this.cursor, this.newestTimestamp, newValue, this.teamId, this.limit);
    }

    public final ChatScheduledMessagesListParams withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(this.channelId, this.cursor, this.newestTimestamp, this.oldestTimestamp, newValue, this.limit);
    }

    public final ChatScheduledMessagesListParams withLimit(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "limit");
        if (this.limit.equals(newValue)) {
            return this;
        }
        return new ChatScheduledMessagesListParams(this.channelId, this.cursor, this.newestTimestamp, this.oldestTimestamp, this.teamId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatScheduledMessagesListParams && this.equalTo(0, (ChatScheduledMessagesListParams)another);
    }

    private boolean equalTo(int synthetic, ChatScheduledMessagesListParams another) {
        return this.channelId.equals(another.channelId) && this.cursor.equals(another.cursor) && this.newestTimestamp.equals(another.newestTimestamp) && this.oldestTimestamp.equals(another.oldestTimestamp) && this.teamId.equals(another.teamId) && this.limit.equals(another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.cursor.hashCode();
        h += (h << 5) + this.newestTimestamp.hashCode();
        h += (h << 5) + this.oldestTimestamp.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + this.limit.hashCode();
        return h;
    }

    public String toString() {
        return "ChatScheduledMessagesListParams{channelId=" + this.channelId + ", cursor=" + this.cursor + ", newestTimestamp=" + this.newestTimestamp + ", oldestTimestamp=" + this.oldestTimestamp + ", teamId=" + this.teamId + ", limit=" + this.limit + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatScheduledMessagesListParams fromJson(Json json) {
        Builder builder = ChatScheduledMessagesListParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.newestTimestamp != null) {
            builder.setNewestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.setOldestTimestamp(json.oldestTimestamp);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        return builder.build();
    }

    public static ChatScheduledMessagesListParams copyOf(ChatScheduledMessagesListParamsIF instance) {
        if (instance instanceof ChatScheduledMessagesListParams) {
            return (ChatScheduledMessagesListParams)instance;
        }
        return ChatScheduledMessagesListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatScheduledMessagesListParamsIF", generator="Immutables")
    private final class InitShim {
        private byte channelIdBuildStage = 0;
        private String channelId;
        private byte cursorBuildStage = 0;
        private String cursor;
        private byte newestTimestampBuildStage = 0;
        private String newestTimestamp;
        private byte oldestTimestampBuildStage = 0;
        private String oldestTimestamp;
        private byte teamIdBuildStage = 0;
        private String teamId;
        private byte limitBuildStage = 0;
        private Integer limit;

        private InitShim() {
        }

        String getChannelId() {
            if (this.channelIdBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.channelIdBuildStage == 0) {
                this.channelIdBuildStage = (byte)-1;
                this.channelId = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getChannelIdInitialize(), "channelId");
                this.channelIdBuildStage = 1;
            }
            return this.channelId;
        }

        void setChannelId(String channelId) {
            this.channelId = channelId;
            this.channelIdBuildStage = 1;
        }

        String getCursor() {
            if (this.cursorBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.cursorBuildStage == 0) {
                this.cursorBuildStage = (byte)-1;
                this.cursor = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getCursorInitialize(), "cursor");
                this.cursorBuildStage = 1;
            }
            return this.cursor;
        }

        void setCursor(String cursor) {
            this.cursor = cursor;
            this.cursorBuildStage = 1;
        }

        String getNewestTimestamp() {
            if (this.newestTimestampBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.newestTimestampBuildStage == 0) {
                this.newestTimestampBuildStage = (byte)-1;
                this.newestTimestamp = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getNewestTimestampInitialize(), "newestTimestamp");
                this.newestTimestampBuildStage = 1;
            }
            return this.newestTimestamp;
        }

        void setNewestTimestamp(String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
            this.newestTimestampBuildStage = 1;
        }

        String getOldestTimestamp() {
            if (this.oldestTimestampBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.oldestTimestampBuildStage == 0) {
                this.oldestTimestampBuildStage = (byte)-1;
                this.oldestTimestamp = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getOldestTimestampInitialize(), "oldestTimestamp");
                this.oldestTimestampBuildStage = 1;
            }
            return this.oldestTimestamp;
        }

        void setOldestTimestamp(String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
            this.oldestTimestampBuildStage = 1;
        }

        String getTeamId() {
            if (this.teamIdBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.teamIdBuildStage == 0) {
                this.teamIdBuildStage = (byte)-1;
                this.teamId = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getTeamIdInitialize(), "teamId");
                this.teamIdBuildStage = 1;
            }
            return this.teamId;
        }

        void setTeamId(String teamId) {
            this.teamId = teamId;
            this.teamIdBuildStage = 1;
        }

        Integer getLimit() {
            if (this.limitBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.limitBuildStage == 0) {
                this.limitBuildStage = (byte)-1;
                this.limit = Objects.requireNonNull(ChatScheduledMessagesListParams.this.getLimitInitialize(), "limit");
                this.limitBuildStage = 1;
            }
            return this.limit;
        }

        void setLimit(Integer limit) {
            this.limit = limit;
            this.limitBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.channelIdBuildStage == -1) {
                attributes.add("channelId");
            }
            if (this.cursorBuildStage == -1) {
                attributes.add("cursor");
            }
            if (this.newestTimestampBuildStage == -1) {
                attributes.add("newestTimestamp");
            }
            if (this.oldestTimestampBuildStage == -1) {
                attributes.add("oldestTimestamp");
            }
            if (this.teamIdBuildStage == -1) {
                attributes.add("teamId");
            }
            if (this.limitBuildStage == -1) {
                attributes.add("limit");
            }
            return "Cannot build ChatScheduledMessagesListParams, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="ChatScheduledMessagesListParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String channelId;
        @Nullable
        private String cursor;
        @Nullable
        private String newestTimestamp;
        @Nullable
        private String oldestTimestamp;
        @Nullable
        private String teamId;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        public final Builder from(ChatScheduledMessagesListParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setChannelId(instance.getChannelId());
            this.setCursor(instance.getCursor());
            this.setNewestTimestamp(instance.getNewestTimestamp());
            this.setOldestTimestamp(instance.getOldestTimestamp());
            this.setTeamId(instance.getTeamId());
            this.setLimit(instance.getLimit());
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            return this;
        }

        public final Builder setCursor(String cursor) {
            this.cursor = Objects.requireNonNull(cursor, "cursor");
            return this;
        }

        public final Builder setNewestTimestamp(String newestTimestamp) {
            this.newestTimestamp = Objects.requireNonNull(newestTimestamp, "newestTimestamp");
            return this;
        }

        public final Builder setOldestTimestamp(String oldestTimestamp) {
            this.oldestTimestamp = Objects.requireNonNull(oldestTimestamp, "oldestTimestamp");
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            return this;
        }

        public final Builder setLimit(Integer limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        public ChatScheduledMessagesListParams build() {
            return new ChatScheduledMessagesListParams(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatScheduledMessagesListParamsIF", generator="Immutables")
    static final class Json
    implements ChatScheduledMessagesListParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String cursor;
        @Nullable
        String newestTimestamp;
        @Nullable
        String oldestTimestamp;
        @Nullable
        String teamId;
        @Nullable
        Integer limit;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @JsonProperty(value="latest")
        public void setNewestTimestamp(String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldest")
        public void setOldestTimestamp(String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getLimit() {
            throw new UnsupportedOperationException();
        }
    }
}

