/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.AbstractChatMessageParams;
import com.hubspot.slack.client.methods.params.chat.AbstractChatPostMessageParams;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractChatPostMessageParams", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatPostMessageParams
extends AbstractChatPostMessageParams {
    private final List<Attachment> attachments;
    private final List<Block> blocks;
    private final String channelId;
    @Nullable
    private final String text;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String username;
    @Nullable
    private final Boolean asUser;
    @Nullable
    private final String iconEmoji;
    @Nullable
    private final String iconUrl;
    @Nullable
    private final Boolean linkNames;
    @Nullable
    private final Boolean unfurlLinks;
    @Nullable
    private final Boolean unfurlMedia;
    @Nullable
    private final Boolean replyBroadcast;

    private ChatPostMessageParams(Builder builder) {
        this.attachments = ChatPostMessageParams.createUnmodifiableList(true, builder.attachments);
        this.channelId = builder.channelId;
        this.text = builder.text;
        this.threadTs = builder.threadTs;
        this.username = builder.username;
        this.asUser = builder.asUser;
        this.iconEmoji = builder.iconEmoji;
        this.iconUrl = builder.iconUrl;
        this.linkNames = builder.linkNames;
        this.unfurlLinks = builder.unfurlLinks;
        this.unfurlMedia = builder.unfurlMedia;
        this.replyBroadcast = builder.replyBroadcast;
        this.blocks = builder.blocksIsSet() ? ChatPostMessageParams.createUnmodifiableList(true, builder.blocks) : ChatPostMessageParams.createUnmodifiableList(false, ChatPostMessageParams.createSafeList(super.getBlocks(), true, false));
    }

    private ChatPostMessageParams(List<Attachment> attachments, List<Block> blocks, String channelId, @Nullable String text, @Nullable String threadTs, @Nullable String username, @Nullable Boolean asUser, @Nullable String iconEmoji, @Nullable String iconUrl, @Nullable Boolean linkNames, @Nullable Boolean unfurlLinks, @Nullable Boolean unfurlMedia, @Nullable Boolean replyBroadcast) {
        this.attachments = attachments;
        this.blocks = blocks;
        this.channelId = channelId;
        this.text = text;
        this.threadTs = threadTs;
        this.username = username;
        this.asUser = asUser;
        this.iconEmoji = iconEmoji;
        this.iconUrl = iconUrl;
        this.linkNames = linkNames;
        this.unfurlLinks = unfurlLinks;
        this.unfurlMedia = unfurlMedia;
        this.replyBroadcast = replyBroadcast;
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Boolean> getAsUser() {
        return Optional.ofNullable(this.asUser);
    }

    @Override
    @JsonProperty
    public Optional<String> getIconEmoji() {
        return Optional.ofNullable(this.iconEmoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getIconUrl() {
        return Optional.ofNullable(this.iconUrl);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getLinkNames() {
        return Optional.ofNullable(this.linkNames);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlLinks() {
        return Optional.ofNullable(this.unfurlLinks);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlMedia() {
        return Optional.ofNullable(this.unfurlMedia);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getReplyBroadcast() {
        return Optional.ofNullable(this.replyBroadcast);
    }

    public final ChatPostMessageParams withAttachments(Attachment ... elements) {
        List<Attachment> newValue = ChatPostMessageParams.createUnmodifiableList(false, ChatPostMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatPostMessageParams.validate(new ChatPostMessageParams(newValue, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = ChatPostMessageParams.createUnmodifiableList(false, ChatPostMessageParams.createSafeList(elements, true, false));
        return ChatPostMessageParams.validate(new ChatPostMessageParams(newValue, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withBlocks(Block ... elements) {
        List<Block> newValue = ChatPostMessageParams.createUnmodifiableList(false, ChatPostMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, newValue, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ChatPostMessageParams.createUnmodifiableList(false, ChatPostMessageParams.createSafeList(elements, true, false));
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, newValue, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, newValue, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, newValue, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, value, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, newValue, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, value, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, newValue, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, value, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withAsUser(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.asUser, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, newValue, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withAsUser(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.asUser, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, value, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withIconEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.iconEmoji, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, newValue, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withIconEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.iconEmoji, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, value, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withIconUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.iconUrl, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, newValue, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withIconUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.iconUrl, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, value, this.linkNames, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withLinkNames(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.linkNames, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, newValue, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withLinkNames(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.linkNames, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, value, this.unfurlLinks, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUnfurlLinks(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlLinks, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, newValue, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUnfurlLinks(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlLinks, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, value, this.unfurlMedia, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUnfurlMedia(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlMedia, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, newValue, this.replyBroadcast));
    }

    public final ChatPostMessageParams withUnfurlMedia(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlMedia, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, value, this.replyBroadcast));
    }

    public final ChatPostMessageParams withReplyBroadcast(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.replyBroadcast, newValue)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, newValue));
    }

    public final ChatPostMessageParams withReplyBroadcast(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.replyBroadcast, value)) {
            return this;
        }
        return ChatPostMessageParams.validate(new ChatPostMessageParams(this.attachments, this.blocks, this.channelId, this.text, this.threadTs, this.username, this.asUser, this.iconEmoji, this.iconUrl, this.linkNames, this.unfurlLinks, this.unfurlMedia, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatPostMessageParams && this.equalTo(0, (ChatPostMessageParams)another);
    }

    private boolean equalTo(int synthetic, ChatPostMessageParams another) {
        return this.attachments.equals(another.attachments) && this.blocks.equals(another.blocks) && this.channelId.equals(another.channelId) && Objects.equals(this.text, another.text) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.username, another.username) && Objects.equals(this.asUser, another.asUser) && Objects.equals(this.iconEmoji, another.iconEmoji) && Objects.equals(this.iconUrl, another.iconUrl) && Objects.equals(this.linkNames, another.linkNames) && Objects.equals(this.unfurlLinks, another.unfurlLinks) && Objects.equals(this.unfurlMedia, another.unfurlMedia) && Objects.equals(this.replyBroadcast, another.replyBroadcast);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.asUser);
        h += (h << 5) + Objects.hashCode(this.iconEmoji);
        h += (h << 5) + Objects.hashCode(this.iconUrl);
        h += (h << 5) + Objects.hashCode(this.linkNames);
        h += (h << 5) + Objects.hashCode(this.unfurlLinks);
        h += (h << 5) + Objects.hashCode(this.unfurlMedia);
        h += (h << 5) + Objects.hashCode(this.replyBroadcast);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatPostMessageParams{");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        if (this.asUser != null) {
            builder.append(", ");
            builder.append("asUser=").append(this.asUser);
        }
        if (this.iconEmoji != null) {
            builder.append(", ");
            builder.append("iconEmoji=").append(this.iconEmoji);
        }
        if (this.iconUrl != null) {
            builder.append(", ");
            builder.append("iconUrl=").append(this.iconUrl);
        }
        if (this.linkNames != null) {
            builder.append(", ");
            builder.append("linkNames=").append(this.linkNames);
        }
        if (this.unfurlLinks != null) {
            builder.append(", ");
            builder.append("unfurlLinks=").append(this.unfurlLinks);
        }
        if (this.unfurlMedia != null) {
            builder.append(", ");
            builder.append("unfurlMedia=").append(this.unfurlMedia);
        }
        if (this.replyBroadcast != null) {
            builder.append(", ");
            builder.append("replyBroadcast=").append(this.replyBroadcast);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatPostMessageParams fromJson(Json json) {
        Builder builder = ChatPostMessageParams.builder();
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.blocksIsSet) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.asUser != null) {
            builder.setAsUser(json.asUser);
        }
        if (json.iconEmoji != null) {
            builder.setIconEmoji(json.iconEmoji);
        }
        if (json.iconUrl != null) {
            builder.setIconUrl(json.iconUrl);
        }
        if (json.linkNames != null) {
            builder.setLinkNames(json.linkNames);
        }
        if (json.unfurlLinks != null) {
            builder.setUnfurlLinks(json.unfurlLinks);
        }
        if (json.unfurlMedia != null) {
            builder.setUnfurlMedia(json.unfurlMedia);
        }
        if (json.replyBroadcast != null) {
            builder.setReplyBroadcast(json.replyBroadcast);
        }
        return builder.build();
    }

    private static ChatPostMessageParams validate(ChatPostMessageParams instance) {
        instance.check();
        return instance;
    }

    public static ChatPostMessageParams copyOf(AbstractChatPostMessageParams instance) {
        if (instance instanceof ChatPostMessageParams) {
            return (ChatPostMessageParams)instance;
        }
        return ChatPostMessageParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractChatPostMessageParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long OPT_BIT_BLOCKS = 1L;
        private long initBits = 1L;
        private long optBits;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String channelId;
        @Nullable
        private String text;
        @Nullable
        private String threadTs;
        @Nullable
        private String username;
        @Nullable
        private Boolean asUser;
        @Nullable
        private String iconEmoji;
        @Nullable
        private String iconUrl;
        @Nullable
        private Boolean linkNames;
        @Nullable
        private Boolean unfurlLinks;
        @Nullable
        private Boolean unfurlMedia;
        @Nullable
        private Boolean replyBroadcast;

        private Builder() {
        }

        public final Builder from(AbstractChatPostMessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractChatMessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> usernameOptional;
            Optional<Boolean> asUserOptional;
            Optional<String> threadTsOptional;
            Optional<String> iconUrlOptional;
            Optional<String> textOptional;
            Optional<Boolean> linkNamesOptional;
            Optional<Boolean> replyBroadcastOptional;
            Optional<Boolean> unfurlLinksOptional;
            Optional<String> iconEmojiOptional;
            Optional<Boolean> unfurlMediaOptional;
            HasChannel instance;
            long bits = 0L;
            if (object instanceof AbstractChatPostMessageParams) {
                instance = (AbstractChatPostMessageParams)object;
                if ((bits & 1L) == 0L) {
                    unfurlMediaOptional = ((AbstractChatMessageParams)instance).getUnfurlMedia();
                    if (unfurlMediaOptional.isPresent()) {
                        this.setUnfurlMedia(unfurlMediaOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    iconEmojiOptional = ((AbstractChatMessageParams)instance).getIconEmoji();
                    if (iconEmojiOptional.isPresent()) {
                        this.setIconEmoji(iconEmojiOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    unfurlLinksOptional = ((AbstractChatMessageParams)instance).getUnfurlLinks();
                    if (unfurlLinksOptional.isPresent()) {
                        this.setUnfurlLinks(unfurlLinksOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    replyBroadcastOptional = ((AbstractChatMessageParams)instance).getReplyBroadcast();
                    if (replyBroadcastOptional.isPresent()) {
                        this.setReplyBroadcast(replyBroadcastOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    linkNamesOptional = ((AbstractChatMessageParams)instance).getLinkNames();
                    if (linkNamesOptional.isPresent()) {
                        this.setLinkNames(linkNamesOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    textOptional = ((AbstractChatMessageParams)instance).getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    iconUrlOptional = ((AbstractChatMessageParams)instance).getIconUrl();
                    if (iconUrlOptional.isPresent()) {
                        this.setIconUrl(iconUrlOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    threadTsOptional = ((AbstractChatMessageParams)instance).getThreadTs();
                    if (threadTsOptional.isPresent()) {
                        this.setThreadTs(threadTsOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x800L) == 0L) {
                    asUserOptional = ((AbstractChatMessageParams)instance).getAsUser();
                    if (asUserOptional.isPresent()) {
                        this.setAsUser(asUserOptional);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    usernameOptional = ((AbstractChatMessageParams)instance).getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 0x1000L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 0x400L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x400L;
                }
            }
            if (object instanceof MessageParams) {
                instance = (MessageParams)object;
                if ((bits & 2L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 0x20L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x400L;
                }
            }
            if (object instanceof AbstractChatMessageParams) {
                instance = (AbstractChatMessageParams)object;
                if ((bits & 1L) == 0L) {
                    unfurlMediaOptional = ((AbstractChatMessageParams)instance).getUnfurlMedia();
                    if (unfurlMediaOptional.isPresent()) {
                        this.setUnfurlMedia(unfurlMediaOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    iconEmojiOptional = ((AbstractChatMessageParams)instance).getIconEmoji();
                    if (iconEmojiOptional.isPresent()) {
                        this.setIconEmoji(iconEmojiOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    unfurlLinksOptional = ((AbstractChatMessageParams)instance).getUnfurlLinks();
                    if (unfurlLinksOptional.isPresent()) {
                        this.setUnfurlLinks(unfurlLinksOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    replyBroadcastOptional = ((AbstractChatMessageParams)instance).getReplyBroadcast();
                    if (replyBroadcastOptional.isPresent()) {
                        this.setReplyBroadcast(replyBroadcastOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    linkNamesOptional = ((AbstractChatMessageParams)instance).getLinkNames();
                    if (linkNamesOptional.isPresent()) {
                        this.setLinkNames(linkNamesOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    textOptional = ((AbstractChatMessageParams)instance).getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    iconUrlOptional = ((AbstractChatMessageParams)instance).getIconUrl();
                    if (iconUrlOptional.isPresent()) {
                        this.setIconUrl(iconUrlOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    threadTsOptional = ((AbstractChatMessageParams)instance).getThreadTs();
                    if (threadTsOptional.isPresent()) {
                        this.setThreadTs(threadTsOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setChannelId(((AbstractChatMessageParams)instance).getChannelId());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    asUserOptional = ((AbstractChatMessageParams)instance).getAsUser();
                    if (asUserOptional.isPresent()) {
                        this.setAsUser(asUserOptional);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    usernameOptional = ((AbstractChatMessageParams)instance).getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 0x1000L;
                }
            }
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setAsUser(@Nullable Boolean asUser) {
            this.asUser = asUser;
            return this;
        }

        public final Builder setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser.orElse(null);
            return this;
        }

        public final Builder setIconEmoji(@Nullable String iconEmoji) {
            this.iconEmoji = iconEmoji;
            return this;
        }

        public final Builder setIconEmoji(Optional<String> iconEmoji) {
            this.iconEmoji = iconEmoji.orElse(null);
            return this;
        }

        public final Builder setIconUrl(@Nullable String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final Builder setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl.orElse(null);
            return this;
        }

        public final Builder setLinkNames(@Nullable Boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public final Builder setLinkNames(Optional<Boolean> linkNames) {
            this.linkNames = linkNames.orElse(null);
            return this;
        }

        public final Builder setUnfurlLinks(@Nullable Boolean unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
            return this;
        }

        public final Builder setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks.orElse(null);
            return this;
        }

        public final Builder setUnfurlMedia(@Nullable Boolean unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
            return this;
        }

        public final Builder setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia.orElse(null);
            return this;
        }

        public final Builder setReplyBroadcast(@Nullable Boolean replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
            return this;
        }

        public final Builder setReplyBroadcast(Optional<Boolean> replyBroadcast) {
            this.replyBroadcast = replyBroadcast.orElse(null);
            return this;
        }

        public ChatPostMessageParams build() {
            this.checkRequiredAttributes();
            return ChatPostMessageParams.validate(new ChatPostMessageParams(this));
        }

        private boolean blocksIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ChatPostMessageParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractChatPostMessageParams", generator="Immutables")
    static final class Json
    extends AbstractChatPostMessageParams {
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        List<Block> blocks = Collections.emptyList();
        boolean blocksIsSet;
        @Nullable
        String channelId;
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        Optional<String> threadTs = Optional.empty();
        @Nullable
        Optional<String> username = Optional.empty();
        @Nullable
        Optional<Boolean> asUser = Optional.empty();
        @Nullable
        Optional<String> iconEmoji = Optional.empty();
        @Nullable
        Optional<String> iconUrl = Optional.empty();
        @Nullable
        Optional<Boolean> linkNames = Optional.empty();
        @Nullable
        Optional<Boolean> unfurlLinks = Optional.empty();
        @Nullable
        Optional<Boolean> unfurlMedia = Optional.empty();
        @Nullable
        Optional<Boolean> replyBroadcast = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksIsSet = null != blocks;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public void setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser;
        }

        @JsonProperty
        public void setIconEmoji(Optional<String> iconEmoji) {
            this.iconEmoji = iconEmoji;
        }

        @JsonProperty
        public void setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl;
        }

        @JsonProperty
        public void setLinkNames(Optional<Boolean> linkNames) {
            this.linkNames = linkNames;
        }

        @JsonProperty
        public void setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
        }

        @JsonProperty
        public void setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
        }

        @JsonProperty
        public void setReplyBroadcast(Optional<Boolean> replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getAsUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIconEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIconUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getLinkNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlMedia() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getReplyBroadcast() {
            throw new UnsupportedOperationException();
        }
    }
}

