/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatPostEphemeralMessageParamsIF;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatPostEphemeralMessageParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatPostEphemeralMessageParams
implements ChatPostEphemeralMessageParamsIF {
    @Nullable
    private final String text;
    private final List<Attachment> attachments;
    private final List<Block> blocks;
    private final String channelId;
    private final String userToSendTo;
    @Nullable
    private final Boolean sendAsUser;
    @Nullable
    private final String threadTs;
    private final boolean shouldLinkNames;
    private final String parseMode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ChatPostEphemeralMessageParams(Builder builder) {
        this.text = builder.text;
        this.attachments = ChatPostEphemeralMessageParams.createUnmodifiableList(true, builder.attachments);
        this.channelId = builder.channelId;
        this.userToSendTo = builder.userToSendTo;
        this.sendAsUser = builder.sendAsUser;
        this.threadTs = builder.threadTs;
        if (builder.blocksIsSet()) {
            this.initShim.setBlocks(ChatPostEphemeralMessageParams.createUnmodifiableList(true, builder.blocks));
        }
        if (builder.shouldLinkNamesIsSet()) {
            this.initShim.setShouldLinkNames(builder.shouldLinkNames);
        }
        if (builder.parseMode != null) {
            this.initShim.setParseMode(builder.parseMode);
        }
        this.blocks = this.initShim.getBlocks();
        this.shouldLinkNames = this.initShim.getShouldLinkNames();
        this.parseMode = this.initShim.getParseMode();
        this.initShim = null;
    }

    private ChatPostEphemeralMessageParams(@Nullable String text, List<Attachment> attachments, List<Block> blocks, String channelId, String userToSendTo, @Nullable Boolean sendAsUser, @Nullable String threadTs, boolean shouldLinkNames, String parseMode) {
        this.text = text;
        this.attachments = attachments;
        this.blocks = blocks;
        this.channelId = channelId;
        this.userToSendTo = userToSendTo;
        this.sendAsUser = sendAsUser;
        this.threadTs = threadTs;
        this.shouldLinkNames = shouldLinkNames;
        this.parseMode = parseMode;
        this.initShim = null;
    }

    private List<Block> getBlocksInitialize() {
        return ChatPostEphemeralMessageParamsIF.super.getBlocks();
    }

    private boolean getShouldLinkNamesInitialize() {
        return ChatPostEphemeralMessageParamsIF.super.getShouldLinkNames();
    }

    private String getParseModeInitialize() {
        return ChatPostEphemeralMessageParamsIF.super.getParseMode();
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBlocks() : this.blocks;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserToSendTo() {
        return this.userToSendTo;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="as_user")
    public Optional<Boolean> getSendAsUser() {
        return Optional.ofNullable(this.sendAsUser);
    }

    @Override
    @JsonProperty(value="thread_ts")
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty(value="link_names")
    public boolean getShouldLinkNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getShouldLinkNames() : this.shouldLinkNames;
    }

    @Override
    @JsonProperty(value="parse")
    public String getParseMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParseMode() : this.parseMode;
    }

    public final ChatPostEphemeralMessageParams withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(newValue, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(value, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withAttachments(Attachment ... elements) {
        List<Attachment> newValue = ChatPostEphemeralMessageParams.createUnmodifiableList(false, ChatPostEphemeralMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, newValue, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = ChatPostEphemeralMessageParams.createUnmodifiableList(false, ChatPostEphemeralMessageParams.createSafeList(elements, true, false));
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, newValue, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withBlocks(Block ... elements) {
        List<Block> newValue = ChatPostEphemeralMessageParams.createUnmodifiableList(false, ChatPostEphemeralMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, newValue, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ChatPostEphemeralMessageParams.createUnmodifiableList(false, ChatPostEphemeralMessageParams.createSafeList(elements, true, false));
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, newValue, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, newValue, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withUserToSendTo(String value) {
        String newValue = Objects.requireNonNull(value, "userToSendTo");
        if (this.userToSendTo.equals(newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, newValue, this.sendAsUser, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withSendAsUser(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.sendAsUser, newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, newValue, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withSendAsUser(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.sendAsUser, value)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, value, this.threadTs, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, newValue, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, value, this.shouldLinkNames, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withShouldLinkNames(boolean value) {
        if (this.shouldLinkNames == value) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, value, this.parseMode));
    }

    public final ChatPostEphemeralMessageParams withParseMode(String value) {
        String newValue = Objects.requireNonNull(value, "parseMode");
        if (this.parseMode.equals(newValue)) {
            return this;
        }
        return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.userToSendTo, this.sendAsUser, this.threadTs, this.shouldLinkNames, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatPostEphemeralMessageParams && this.equalTo(0, (ChatPostEphemeralMessageParams)another);
    }

    private boolean equalTo(int synthetic, ChatPostEphemeralMessageParams another) {
        return Objects.equals(this.text, another.text) && this.attachments.equals(another.attachments) && this.blocks.equals(another.blocks) && this.channelId.equals(another.channelId) && this.userToSendTo.equals(another.userToSendTo) && Objects.equals(this.sendAsUser, another.sendAsUser) && Objects.equals(this.threadTs, another.threadTs) && this.shouldLinkNames == another.shouldLinkNames && this.parseMode.equals(another.parseMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.userToSendTo.hashCode();
        h += (h << 5) + Objects.hashCode(this.sendAsUser);
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + Boolean.hashCode(this.shouldLinkNames);
        h += (h << 5) + this.parseMode.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatPostEphemeralMessageParams{");
        if (this.text != null) {
            builder.append("text=").append(this.text);
        }
        if (builder.length() > 31) {
            builder.append(", ");
        }
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("userToSendTo=").append(this.userToSendTo);
        if (this.sendAsUser != null) {
            builder.append(", ");
            builder.append("sendAsUser=").append(this.sendAsUser);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        builder.append(", ");
        builder.append("shouldLinkNames=").append(this.shouldLinkNames);
        builder.append(", ");
        builder.append("parseMode=").append(this.parseMode);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatPostEphemeralMessageParams fromJson(Json json) {
        Builder builder = ChatPostEphemeralMessageParams.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.blocksIsSet) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.userToSendTo != null) {
            builder.setUserToSendTo(json.userToSendTo);
        }
        if (json.sendAsUser != null) {
            builder.setSendAsUser(json.sendAsUser);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.shouldLinkNamesIsSet) {
            builder.setShouldLinkNames(json.shouldLinkNames);
        }
        if (json.parseMode != null) {
            builder.setParseMode(json.parseMode);
        }
        return builder.build();
    }

    private static ChatPostEphemeralMessageParams validate(ChatPostEphemeralMessageParams instance) {
        instance.check();
        return instance;
    }

    public static ChatPostEphemeralMessageParams copyOf(ChatPostEphemeralMessageParamsIF instance) {
        if (instance instanceof ChatPostEphemeralMessageParams) {
            return (ChatPostEphemeralMessageParams)instance;
        }
        return ChatPostEphemeralMessageParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ChatPostEphemeralMessageParamsIF", generator="Immutables")
    private final class InitShim {
        private byte blocksBuildStage = 0;
        private List<Block> blocks;
        private byte shouldLinkNamesBuildStage = 0;
        private boolean shouldLinkNames;
        private byte parseModeBuildStage = 0;
        private String parseMode;

        private InitShim() {
        }

        List<Block> getBlocks() {
            if (this.blocksBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.blocksBuildStage == 0) {
                this.blocksBuildStage = (byte)-1;
                this.blocks = ChatPostEphemeralMessageParams.createUnmodifiableList(false, ChatPostEphemeralMessageParams.createSafeList(ChatPostEphemeralMessageParams.this.getBlocksInitialize(), true, false));
                this.blocksBuildStage = 1;
            }
            return this.blocks;
        }

        void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksBuildStage = 1;
        }

        boolean getShouldLinkNames() {
            if (this.shouldLinkNamesBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.shouldLinkNamesBuildStage == 0) {
                this.shouldLinkNamesBuildStage = (byte)-1;
                this.shouldLinkNames = ChatPostEphemeralMessageParams.this.getShouldLinkNamesInitialize();
                this.shouldLinkNamesBuildStage = 1;
            }
            return this.shouldLinkNames;
        }

        void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesBuildStage = 1;
        }

        String getParseMode() {
            if (this.parseModeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.parseModeBuildStage == 0) {
                this.parseModeBuildStage = (byte)-1;
                this.parseMode = Objects.requireNonNull(ChatPostEphemeralMessageParams.this.getParseModeInitialize(), "parseMode");
                this.parseModeBuildStage = 1;
            }
            return this.parseMode;
        }

        void setParseMode(String parseMode) {
            this.parseMode = parseMode;
            this.parseModeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.blocksBuildStage == -1) {
                attributes.add("blocks");
            }
            if (this.shouldLinkNamesBuildStage == -1) {
                attributes.add("shouldLinkNames");
            }
            if (this.parseModeBuildStage == -1) {
                attributes.add("parseMode");
            }
            return "Cannot build ChatPostEphemeralMessageParams, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="ChatPostEphemeralMessageParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_USER_TO_SEND_TO = 2L;
        private static final long OPT_BIT_BLOCKS = 1L;
        private static final long OPT_BIT_SHOULD_LINK_NAMES = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String channelId;
        @Nullable
        private String userToSendTo;
        @Nullable
        private Boolean sendAsUser;
        @Nullable
        private String threadTs;
        private boolean shouldLinkNames;
        @Nullable
        private String parseMode;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatPostEphemeralMessageParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof MessageParams) {
                instance = (MessageParams)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof ChatPostEphemeralMessageParamsIF) {
                instance = (ChatPostEphemeralMessageParamsIF)object;
                Optional<Boolean> sendAsUserOptional = instance.getSendAsUser();
                if (sendAsUserOptional.isPresent()) {
                    this.setSendAsUser(sendAsUserOptional);
                }
                this.setUserToSendTo(instance.getUserToSendTo());
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 1L;
                }
                this.setShouldLinkNames(instance.getShouldLinkNames());
                if ((bits & 2L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 4L;
                }
                this.setParseMode(instance.getParseMode());
                Optional<String> threadTsOptional = instance.getThreadTs();
                if (threadTsOptional.isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUserToSendTo(String userToSendTo) {
            this.userToSendTo = Objects.requireNonNull(userToSendTo, "userToSendTo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSendAsUser(@Nullable Boolean sendAsUser) {
            this.sendAsUser = sendAsUser;
            return this;
        }

        public final Builder setSendAsUser(Optional<Boolean> sendAsUser) {
            this.sendAsUser = sendAsUser.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setParseMode(String parseMode) {
            this.parseMode = Objects.requireNonNull(parseMode, "parseMode");
            return this;
        }

        public ChatPostEphemeralMessageParams build() {
            this.checkRequiredAttributes();
            return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this));
        }

        private boolean blocksIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean shouldLinkNamesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userToSendToIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.userToSendToIsSet()) {
                attributes.add("userToSendTo");
            }
            return "Cannot build ChatPostEphemeralMessageParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatPostEphemeralMessageParamsIF", generator="Immutables")
    static final class Json
    implements ChatPostEphemeralMessageParamsIF {
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        List<Block> blocks = Collections.emptyList();
        boolean blocksIsSet;
        @Nullable
        String channelId;
        @Nullable
        String userToSendTo;
        @Nullable
        Optional<Boolean> sendAsUser = Optional.empty();
        @Nullable
        Optional<String> threadTs = Optional.empty();
        boolean shouldLinkNames;
        boolean shouldLinkNamesIsSet;
        @Nullable
        String parseMode;

        Json() {
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksIsSet = null != blocks;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUserToSendTo(String userToSendTo) {
            this.userToSendTo = userToSendTo;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="as_user")
        public void setSendAsUser(Optional<Boolean> sendAsUser) {
            this.sendAsUser = sendAsUser;
        }

        @JsonProperty(value="thread_ts")
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty(value="link_names")
        public void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesIsSet = true;
        }

        @JsonProperty(value="parse")
        public void setParseMode(String parseMode) {
            this.parseMode = parseMode;
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserToSendTo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getSendAsUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getShouldLinkNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParseMode() {
            throw new UnsupportedOperationException();
        }
    }
}

