/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatGetPermalinkParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatGetPermalinkParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatGetPermalinkParams
implements ChatGetPermalinkParamsIF {
    private final String channelId;
    private final String messageTs;

    private ChatGetPermalinkParams(String channelId, String messageTs) {
        this.channelId = channelId;
        this.messageTs = messageTs;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    public final ChatGetPermalinkParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatGetPermalinkParams(newValue, this.messageTs);
    }

    public final ChatGetPermalinkParams withMessageTs(String value) {
        String newValue = Objects.requireNonNull(value, "messageTs");
        if (this.messageTs.equals(newValue)) {
            return this;
        }
        return new ChatGetPermalinkParams(this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatGetPermalinkParams && this.equalTo(0, (ChatGetPermalinkParams)another);
    }

    private boolean equalTo(int synthetic, ChatGetPermalinkParams another) {
        return this.channelId.equals(another.channelId) && this.messageTs.equals(another.messageTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.messageTs.hashCode();
        return h;
    }

    public String toString() {
        return "ChatGetPermalinkParams{channelId=" + this.channelId + ", messageTs=" + this.messageTs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatGetPermalinkParams fromJson(Json json) {
        Builder builder = ChatGetPermalinkParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        return builder.build();
    }

    public static ChatGetPermalinkParams copyOf(ChatGetPermalinkParamsIF instance) {
        if (instance instanceof ChatGetPermalinkParams) {
            return (ChatGetPermalinkParams)instance;
        }
        return ChatGetPermalinkParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatGetPermalinkParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_MESSAGE_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String messageTs;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatGetPermalinkParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatGetPermalinkParamsIF) {
                instance = (ChatGetPermalinkParamsIF)object;
                this.setMessageTs(instance.getMessageTs());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ChatGetPermalinkParams build() {
            this.checkRequiredAttributes();
            return new ChatGetPermalinkParams(this.channelId, this.messageTs);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            return "Cannot build ChatGetPermalinkParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatGetPermalinkParamsIF", generator="Immutables")
    static final class Json
    implements ChatGetPermalinkParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String messageTs;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }
    }
}

