/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.AbstractChatDeleteParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractChatDeleteParams", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatDeleteParams
extends AbstractChatDeleteParams {
    private final String channelId;
    private final String messageToDeleteTs;
    private final boolean asUser;

    private ChatDeleteParams(Builder builder) {
        this.channelId = builder.channelId;
        this.messageToDeleteTs = builder.messageToDeleteTs;
        this.asUser = builder.asUserIsSet() ? builder.asUser : super.getAsUser();
    }

    private ChatDeleteParams(String channelId, String messageToDeleteTs, boolean asUser) {
        this.channelId = channelId;
        this.messageToDeleteTs = messageToDeleteTs;
        this.asUser = asUser;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="ts")
    public String getMessageToDeleteTs() {
        return this.messageToDeleteTs;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonProperty(value="as_user")
    public boolean getAsUser() {
        return this.asUser;
    }

    public final ChatDeleteParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatDeleteParams(newValue, this.messageToDeleteTs, this.asUser);
    }

    public final ChatDeleteParams withMessageToDeleteTs(String value) {
        String newValue = Objects.requireNonNull(value, "messageToDeleteTs");
        if (this.messageToDeleteTs.equals(newValue)) {
            return this;
        }
        return new ChatDeleteParams(this.channelId, newValue, this.asUser);
    }

    public final ChatDeleteParams withAsUser(boolean value) {
        if (this.asUser == value) {
            return this;
        }
        return new ChatDeleteParams(this.channelId, this.messageToDeleteTs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatDeleteParams && this.equalTo(0, (ChatDeleteParams)another);
    }

    private boolean equalTo(int synthetic, ChatDeleteParams another) {
        return this.channelId.equals(another.channelId) && this.messageToDeleteTs.equals(another.messageToDeleteTs) && this.asUser == another.asUser;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.messageToDeleteTs.hashCode();
        h += (h << 5) + Boolean.hashCode(this.asUser);
        return h;
    }

    public String toString() {
        return "ChatDeleteParams{channelId=" + this.channelId + ", messageToDeleteTs=" + this.messageToDeleteTs + ", asUser=" + this.asUser + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatDeleteParams fromJson(Json json) {
        Builder builder = ChatDeleteParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.messageToDeleteTs != null) {
            builder.setMessageToDeleteTs(json.messageToDeleteTs);
        }
        if (json.asUserIsSet) {
            builder.setAsUser(json.asUser);
        }
        return builder.build();
    }

    public static ChatDeleteParams copyOf(AbstractChatDeleteParams instance) {
        if (instance instanceof ChatDeleteParams) {
            return (ChatDeleteParams)instance;
        }
        return ChatDeleteParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractChatDeleteParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_MESSAGE_TO_DELETE_TS = 2L;
        private static final long OPT_BIT_AS_USER = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String channelId;
        @Nullable
        private String messageToDeleteTs;
        private boolean asUser;

        private Builder() {
        }

        public final Builder from(AbstractChatDeleteParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            if (object instanceof AbstractChatDeleteParams) {
                instance = (AbstractChatDeleteParams)object;
                this.setAsUser(((AbstractChatDeleteParams)instance).getAsUser());
                this.setMessageToDeleteTs(((AbstractChatDeleteParams)instance).getMessageToDeleteTs());
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                this.setChannelId(instance.getChannelId());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessageToDeleteTs(String messageToDeleteTs) {
            this.messageToDeleteTs = Objects.requireNonNull(messageToDeleteTs, "messageToDeleteTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setAsUser(boolean asUser) {
            this.asUser = asUser;
            this.optBits |= 1L;
            return this;
        }

        public ChatDeleteParams build() {
            this.checkRequiredAttributes();
            return new ChatDeleteParams(this);
        }

        private boolean asUserIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageToDeleteTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.messageToDeleteTsIsSet()) {
                attributes.add("messageToDeleteTs");
            }
            return "Cannot build ChatDeleteParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractChatDeleteParams", generator="Immutables")
    static final class Json
    extends AbstractChatDeleteParams {
        @Nullable
        String channelId;
        @Nullable
        String messageToDeleteTs;
        boolean asUser;
        boolean asUserIsSet;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="ts")
        public void setMessageToDeleteTs(String messageToDeleteTs) {
            this.messageToDeleteTs = messageToDeleteTs;
        }

        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        @JsonProperty(value="as_user")
        public void setAsUser(boolean asUser) {
            this.asUser = asUser;
            this.asUserIsSet = true;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessageToDeleteTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getAsUser() {
            throw new UnsupportedOperationException();
        }
    }
}

