/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.FindRepliesParamsIF;
import com.hubspot.slack.client.methods.params.channels.ReplyQueryParams;
import com.hubspot.slack.client.models.ChannelType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FindRepliesParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class FindRepliesParams
implements FindRepliesParamsIF {
    private final String threadTs;
    private final String channelId;
    private final transient ChannelType channelType;

    private FindRepliesParams(String threadTs, String channelId) {
        this.threadTs = threadTs;
        this.channelId = channelId;
        this.channelType = Objects.requireNonNull(FindRepliesParamsIF.super.getChannelType(), "channelType");
    }

    @Override
    @JsonProperty(value="thread_ts")
    public String getThreadTs() {
        return this.threadTs;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public final FindRepliesParams withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new FindRepliesParams(newValue, this.channelId);
    }

    public final FindRepliesParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new FindRepliesParams(this.threadTs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FindRepliesParams && this.equalTo(0, (FindRepliesParams)another);
    }

    private boolean equalTo(int synthetic, FindRepliesParams another) {
        return this.threadTs.equals(another.threadTs) && this.channelId.equals(another.channelId) && this.channelType.equals((Object)another.channelType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.threadTs.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channelType.hashCode();
        return h;
    }

    public String toString() {
        return "FindRepliesParams{threadTs=" + this.threadTs + ", channelId=" + this.channelId + ", channelType=" + String.valueOf((Object)this.channelType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static FindRepliesParams fromJson(Json json) {
        Builder builder = FindRepliesParams.builder();
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static FindRepliesParams copyOf(FindRepliesParamsIF instance) {
        if (instance instanceof FindRepliesParams) {
            return (FindRepliesParams)instance;
        }
        return FindRepliesParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FindRepliesParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_THREAD_TS = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String threadTs;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(FindRepliesParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ReplyQueryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof FindRepliesParamsIF) {
                instance = (FindRepliesParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setThreadTs(instance.getThreadTs());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof ReplyQueryParams) {
                instance = (ReplyQueryParams)object;
                if ((bits & 1L) == 0L) {
                    this.setThreadTs(instance.getThreadTs());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public FindRepliesParams build() {
            this.checkRequiredAttributes();
            return new FindRepliesParams(this.threadTs, this.channelId);
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build FindRepliesParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FindRepliesParamsIF", generator="Immutables")
    static final class Json
    implements FindRepliesParamsIF {
        @Nullable
        String threadTs;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty(value="thread_ts")
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }
    }
}

