/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.calls.CallsUpdateParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CallsUpdateParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class CallsUpdateParams
implements CallsUpdateParamsIF {
    private final String id;
    @Nullable
    private final String desktopAppJoinUrl;
    @Nullable
    private final String joinUrl;
    @Nullable
    private final String title;

    private CallsUpdateParams(String id, @Nullable String desktopAppJoinUrl, @Nullable String joinUrl, @Nullable String title) {
        this.id = id;
        this.desktopAppJoinUrl = desktopAppJoinUrl;
        this.joinUrl = joinUrl;
        this.title = title;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<String> getDesktopAppJoinUrl() {
        return Optional.ofNullable(this.desktopAppJoinUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getJoinUrl() {
        return Optional.ofNullable(this.joinUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public final CallsUpdateParams withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new CallsUpdateParams(newValue, this.desktopAppJoinUrl, this.joinUrl, this.title);
    }

    public final CallsUpdateParams withDesktopAppJoinUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.desktopAppJoinUrl, newValue)) {
            return this;
        }
        return new CallsUpdateParams(this.id, newValue, this.joinUrl, this.title);
    }

    public final CallsUpdateParams withDesktopAppJoinUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.desktopAppJoinUrl, value)) {
            return this;
        }
        return new CallsUpdateParams(this.id, value, this.joinUrl, this.title);
    }

    public final CallsUpdateParams withJoinUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.joinUrl, newValue)) {
            return this;
        }
        return new CallsUpdateParams(this.id, this.desktopAppJoinUrl, newValue, this.title);
    }

    public final CallsUpdateParams withJoinUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.joinUrl, value)) {
            return this;
        }
        return new CallsUpdateParams(this.id, this.desktopAppJoinUrl, value, this.title);
    }

    public final CallsUpdateParams withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new CallsUpdateParams(this.id, this.desktopAppJoinUrl, this.joinUrl, newValue);
    }

    public final CallsUpdateParams withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new CallsUpdateParams(this.id, this.desktopAppJoinUrl, this.joinUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CallsUpdateParams && this.equalTo(0, (CallsUpdateParams)another);
    }

    private boolean equalTo(int synthetic, CallsUpdateParams another) {
        return this.id.equals(another.id) && Objects.equals(this.desktopAppJoinUrl, another.desktopAppJoinUrl) && Objects.equals(this.joinUrl, another.joinUrl) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.desktopAppJoinUrl);
        h += (h << 5) + Objects.hashCode(this.joinUrl);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CallsUpdateParams{");
        builder.append("id=").append(this.id);
        if (this.desktopAppJoinUrl != null) {
            builder.append(", ");
            builder.append("desktopAppJoinUrl=").append(this.desktopAppJoinUrl);
        }
        if (this.joinUrl != null) {
            builder.append(", ");
            builder.append("joinUrl=").append(this.joinUrl);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CallsUpdateParams fromJson(Json json) {
        Builder builder = CallsUpdateParams.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.desktopAppJoinUrl != null) {
            builder.setDesktopAppJoinUrl(json.desktopAppJoinUrl);
        }
        if (json.joinUrl != null) {
            builder.setJoinUrl(json.joinUrl);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        return builder.build();
    }

    public static CallsUpdateParams copyOf(CallsUpdateParamsIF instance) {
        if (instance instanceof CallsUpdateParams) {
            return (CallsUpdateParams)instance;
        }
        return CallsUpdateParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CallsUpdateParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String desktopAppJoinUrl;
        @Nullable
        private String joinUrl;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(CallsUpdateParamsIF instance) {
            Optional<String> titleOptional;
            Optional<String> joinUrlOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            Optional<String> desktopAppJoinUrlOptional = instance.getDesktopAppJoinUrl();
            if (desktopAppJoinUrlOptional.isPresent()) {
                this.setDesktopAppJoinUrl(desktopAppJoinUrlOptional);
            }
            if ((joinUrlOptional = instance.getJoinUrl()).isPresent()) {
                this.setJoinUrl(joinUrlOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDesktopAppJoinUrl(@Nullable String desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
            return this;
        }

        public final Builder setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl.orElse(null);
            return this;
        }

        public final Builder setJoinUrl(@Nullable String joinUrl) {
            this.joinUrl = joinUrl;
            return this;
        }

        public final Builder setJoinUrl(Optional<String> joinUrl) {
            this.joinUrl = joinUrl.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public CallsUpdateParams build() {
            this.checkRequiredAttributes();
            return new CallsUpdateParams(this.id, this.desktopAppJoinUrl, this.joinUrl, this.title);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build CallsUpdateParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CallsUpdateParamsIF", generator="Immutables")
    static final class Json
    implements CallsUpdateParamsIF {
        @Nullable
        String id;
        @Nullable
        Optional<String> desktopAppJoinUrl = Optional.empty();
        @Nullable
        Optional<String> joinUrl = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
        }

        @JsonProperty
        public void setJoinUrl(Optional<String> joinUrl) {
            this.joinUrl = joinUrl;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDesktopAppJoinUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getJoinUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }
    }
}

