/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.calls.CallsEndParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CallsEndParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class CallsEndParams
implements CallsEndParamsIF {
    private final String id;
    @Nullable
    private final Duration duration;
    private final transient Optional<Integer> durationSeconds;

    private CallsEndParams(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.duration = null;
        this.durationSeconds = Objects.requireNonNull(CallsEndParamsIF.super.getDurationSeconds(), "durationSeconds");
    }

    private CallsEndParams(String id, @Nullable Duration duration) {
        this.id = id;
        this.duration = duration;
        this.durationSeconds = Objects.requireNonNull(CallsEndParamsIF.super.getDurationSeconds(), "durationSeconds");
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    @Override
    @JsonProperty(value="duration")
    public Optional<Integer> getDurationSeconds() {
        return this.durationSeconds;
    }

    public final CallsEndParams withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new CallsEndParams(newValue, this.duration);
    }

    public final CallsEndParams withDuration(@Nullable Duration value) {
        Duration newValue = value;
        if (this.duration == newValue) {
            return this;
        }
        return new CallsEndParams(this.id, newValue);
    }

    public final CallsEndParams withDuration(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.duration == value) {
            return this;
        }
        return new CallsEndParams(this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CallsEndParams && this.equalTo(0, (CallsEndParams)another);
    }

    private boolean equalTo(int synthetic, CallsEndParams another) {
        return this.id.equals(another.id) && Objects.equals(this.duration, another.duration) && this.durationSeconds.equals(another.durationSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.duration);
        h += (h << 5) + this.durationSeconds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CallsEndParams{");
        builder.append("id=").append(this.id);
        if (this.duration != null) {
            builder.append(", ");
            builder.append("duration=").append(this.duration);
        }
        builder.append(", ");
        builder.append("durationSeconds=").append(this.durationSeconds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CallsEndParams fromJson(Json json) {
        Builder builder = CallsEndParams.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.duration != null) {
            builder.setDuration(json.duration);
        }
        return builder.build();
    }

    public static CallsEndParams of(String id) {
        return new CallsEndParams(id);
    }

    public static CallsEndParams copyOf(CallsEndParamsIF instance) {
        if (instance instanceof CallsEndParams) {
            return (CallsEndParams)instance;
        }
        return CallsEndParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CallsEndParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private Duration duration;

        private Builder() {
        }

        public final Builder from(CallsEndParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            Optional<Duration> durationOptional = instance.getDuration();
            if (durationOptional.isPresent()) {
                this.setDuration(durationOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDuration(@Nullable Duration duration) {
            this.duration = duration;
            return this;
        }

        public final Builder setDuration(Optional<? extends Duration> duration) {
            this.duration = duration.orElse(null);
            return this;
        }

        public CallsEndParams build() {
            this.checkRequiredAttributes();
            return new CallsEndParams(this.id, this.duration);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build CallsEndParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CallsEndParamsIF", generator="Immutables")
    static final class Json
    implements CallsEndParamsIF {
        @Nullable
        String id;
        @Nullable
        Optional<Duration> duration = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        @JsonIgnore
        public void setDuration(Optional<Duration> duration) {
            this.duration = duration;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Duration> getDuration() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Optional<Integer> getDurationSeconds() {
            throw new UnsupportedOperationException();
        }
    }
}

