/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.bookmarks.BookmarksRemoveParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarksRemoveParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BookmarksRemoveParams
implements BookmarksRemoveParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String bookmarkId;

    private BookmarksRemoveParams(String channelId, String bookmarkId) {
        this.channelId = channelId;
        this.bookmarkId = bookmarkId;
        this.channel = Objects.requireNonNull(BookmarksRemoveParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getBookmarkId() {
        return this.bookmarkId;
    }

    public final BookmarksRemoveParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new BookmarksRemoveParams(newValue, this.bookmarkId);
    }

    public final BookmarksRemoveParams withBookmarkId(String value) {
        String newValue = Objects.requireNonNull(value, "bookmarkId");
        if (this.bookmarkId.equals(newValue)) {
            return this;
        }
        return new BookmarksRemoveParams(this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BookmarksRemoveParams && this.equalTo(0, (BookmarksRemoveParams)another);
    }

    private boolean equalTo(int synthetic, BookmarksRemoveParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.bookmarkId.equals(another.bookmarkId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.bookmarkId.hashCode();
        return h;
    }

    public String toString() {
        return "BookmarksRemoveParams{channelId=" + this.channelId + ", channel=" + this.channel + ", bookmarkId=" + this.bookmarkId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BookmarksRemoveParams fromJson(Json json) {
        Builder builder = BookmarksRemoveParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.bookmarkId != null) {
            builder.setBookmarkId(json.bookmarkId);
        }
        return builder.build();
    }

    public static BookmarksRemoveParams copyOf(BookmarksRemoveParamsIF instance) {
        if (instance instanceof BookmarksRemoveParams) {
            return (BookmarksRemoveParams)instance;
        }
        return BookmarksRemoveParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookmarksRemoveParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_BOOKMARK_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String bookmarkId;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BookmarksRemoveParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof BookmarksRemoveParamsIF) {
                instance = (BookmarksRemoveParamsIF)object;
                this.setBookmarkId(instance.getBookmarkId());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBookmarkId(String bookmarkId) {
            this.bookmarkId = Objects.requireNonNull(bookmarkId, "bookmarkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BookmarksRemoveParams build() {
            this.checkRequiredAttributes();
            return new BookmarksRemoveParams(this.channelId, this.bookmarkId);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean bookmarkIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.bookmarkIdIsSet()) {
                attributes.add("bookmarkId");
            }
            return "Cannot build BookmarksRemoveParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarksRemoveParamsIF", generator="Immutables")
    static final class Json
    implements BookmarksRemoveParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String bookmarkId;

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setBookmarkId(String bookmarkId) {
            this.bookmarkId = bookmarkId;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBookmarkId() {
            throw new UnsupportedOperationException();
        }
    }
}

