/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.bookmarks.BookmarksAddParamsIF;
import com.hubspot.slack.client.models.bookmarks.BookmarkType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarksAddParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BookmarksAddParams
implements BookmarksAddParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String title;
    private final BookmarkType type;
    @Nullable
    private final String emoji;
    @Nullable
    private final String entityId;
    @Nullable
    private final String link;
    @Nullable
    private final String parentId;

    private BookmarksAddParams(String channelId, String title, BookmarkType type, @Nullable String emoji, @Nullable String entityId, @Nullable String link, @Nullable String parentId) {
        this.channelId = channelId;
        this.title = title;
        this.type = type;
        this.emoji = emoji;
        this.entityId = entityId;
        this.link = link;
        this.parentId = parentId;
        this.channel = Objects.requireNonNull(BookmarksAddParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public BookmarkType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    @Override
    @JsonProperty
    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Override
    @JsonProperty
    public Optional<String> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public final BookmarksAddParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new BookmarksAddParams(newValue, this.title, this.type, this.emoji, this.entityId, this.link, this.parentId);
    }

    public final BookmarksAddParams withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, newValue, this.type, this.emoji, this.entityId, this.link, this.parentId);
    }

    public final BookmarksAddParams withType(BookmarkType value) {
        BookmarkType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, newValue, this.emoji, this.entityId, this.link, this.parentId);
    }

    public final BookmarksAddParams withEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.emoji, newValue)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, newValue, this.entityId, this.link, this.parentId);
    }

    public final BookmarksAddParams withEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emoji, value)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, value, this.entityId, this.link, this.parentId);
    }

    public final BookmarksAddParams withEntityId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.entityId, newValue)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, newValue, this.link, this.parentId);
    }

    public final BookmarksAddParams withEntityId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.entityId, value)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, value, this.link, this.parentId);
    }

    public final BookmarksAddParams withLink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.link, newValue)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, this.entityId, newValue, this.parentId);
    }

    public final BookmarksAddParams withLink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.link, value)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, this.entityId, value, this.parentId);
    }

    public final BookmarksAddParams withParentId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.parentId, newValue)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, this.entityId, this.link, newValue);
    }

    public final BookmarksAddParams withParentId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parentId, value)) {
            return this;
        }
        return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, this.entityId, this.link, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BookmarksAddParams && this.equalTo(0, (BookmarksAddParams)another);
    }

    private boolean equalTo(int synthetic, BookmarksAddParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.title.equals(another.title) && this.type.equals((Object)another.type) && Objects.equals(this.emoji, another.emoji) && Objects.equals(this.entityId, another.entityId) && Objects.equals(this.link, another.link) && Objects.equals(this.parentId, another.parentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.emoji);
        h += (h << 5) + Objects.hashCode(this.entityId);
        h += (h << 5) + Objects.hashCode(this.link);
        h += (h << 5) + Objects.hashCode(this.parentId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BookmarksAddParams{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        if (this.emoji != null) {
            builder.append(", ");
            builder.append("emoji=").append(this.emoji);
        }
        if (this.entityId != null) {
            builder.append(", ");
            builder.append("entityId=").append(this.entityId);
        }
        if (this.link != null) {
            builder.append(", ");
            builder.append("link=").append(this.link);
        }
        if (this.parentId != null) {
            builder.append(", ");
            builder.append("parentId=").append(this.parentId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BookmarksAddParams fromJson(Json json) {
        Builder builder = BookmarksAddParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.emoji != null) {
            builder.setEmoji(json.emoji);
        }
        if (json.entityId != null) {
            builder.setEntityId(json.entityId);
        }
        if (json.link != null) {
            builder.setLink(json.link);
        }
        if (json.parentId != null) {
            builder.setParentId(json.parentId);
        }
        return builder.build();
    }

    public static BookmarksAddParams copyOf(BookmarksAddParamsIF instance) {
        if (instance instanceof BookmarksAddParams) {
            return (BookmarksAddParams)instance;
        }
        return BookmarksAddParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookmarksAddParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String channelId;
        @Nullable
        private String title;
        @Nullable
        private BookmarkType type;
        @Nullable
        private String emoji;
        @Nullable
        private String entityId;
        @Nullable
        private String link;
        @Nullable
        private String parentId;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BookmarksAddParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof BookmarksAddParamsIF) {
                Optional<String> entityIdOptional;
                Optional<String> linkOptional;
                instance = (BookmarksAddParamsIF)object;
                Optional<String> emojiOptional = instance.getEmoji();
                if (emojiOptional.isPresent()) {
                    this.setEmoji(emojiOptional);
                }
                if ((linkOptional = instance.getLink()).isPresent()) {
                    this.setLink(linkOptional);
                }
                if ((entityIdOptional = instance.getEntityId()).isPresent()) {
                    this.setEntityId(entityIdOptional);
                }
                this.setTitle(instance.getTitle());
                this.setType(instance.getType());
                Optional<String> parentIdOptional = instance.getParentId();
                if (parentIdOptional.isPresent()) {
                    this.setParentId(parentIdOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setType(BookmarkType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setEmoji(@Nullable String emoji) {
            this.emoji = emoji;
            return this;
        }

        public final Builder setEmoji(Optional<String> emoji) {
            this.emoji = emoji.orElse(null);
            return this;
        }

        public final Builder setEntityId(@Nullable String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Builder setEntityId(Optional<String> entityId) {
            this.entityId = entityId.orElse(null);
            return this;
        }

        public final Builder setLink(@Nullable String link) {
            this.link = link;
            return this;
        }

        public final Builder setLink(Optional<String> link) {
            this.link = link.orElse(null);
            return this;
        }

        public final Builder setParentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final Builder setParentId(Optional<String> parentId) {
            this.parentId = parentId.orElse(null);
            return this;
        }

        public BookmarksAddParams build() {
            this.checkRequiredAttributes();
            return new BookmarksAddParams(this.channelId, this.title, this.type, this.emoji, this.entityId, this.link, this.parentId);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build BookmarksAddParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarksAddParamsIF", generator="Immutables")
    static final class Json
    implements BookmarksAddParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String title;
        @Nullable
        BookmarkType type;
        @Nullable
        Optional<String> emoji = Optional.empty();
        @Nullable
        Optional<String> entityId = Optional.empty();
        @Nullable
        Optional<String> link = Optional.empty();
        @Nullable
        Optional<String> parentId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setType(BookmarkType type) {
            this.type = type;
        }

        @JsonProperty
        public void setEmoji(Optional<String> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty
        public void setEntityId(Optional<String> entityId) {
            this.entityId = entityId;
        }

        @JsonProperty
        public void setLink(Optional<String> link) {
            this.link = link;
        }

        @JsonProperty
        public void setParentId(Optional<String> parentId) {
            this.parentId = parentId;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BookmarkType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEntityId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getParentId() {
            throw new UnsupportedOperationException();
        }
    }
}

