/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.assistant.SetTitleParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SetTitleParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SetTitleParams
implements SetTitleParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String threadTs;
    private final String title;

    private SetTitleParams(String channelId, String threadTs, String title) {
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.title = title;
        this.channel = Objects.requireNonNull(SetTitleParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    public final SetTitleParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SetTitleParams(newValue, this.threadTs, this.title);
    }

    public final SetTitleParams withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new SetTitleParams(this.channelId, newValue, this.title);
    }

    public final SetTitleParams withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new SetTitleParams(this.channelId, this.threadTs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SetTitleParams && this.equalTo(0, (SetTitleParams)another);
    }

    private boolean equalTo(int synthetic, SetTitleParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.threadTs.equals(another.threadTs) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "SetTitleParams{channelId=" + this.channelId + ", channel=" + this.channel + ", threadTs=" + this.threadTs + ", title=" + this.title + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SetTitleParams fromJson(Json json) {
        Builder builder = SetTitleParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        return builder.build();
    }

    public static SetTitleParams copyOf(SetTitleParamsIF instance) {
        if (instance instanceof SetTitleParams) {
            return (SetTitleParams)instance;
        }
        return SetTitleParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetTitleParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_THREAD_TS = 2L;
        private static final long INIT_BIT_TITLE = 4L;
        private long initBits = 7L;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SetTitleParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SetTitleParamsIF) {
                instance = (SetTitleParamsIF)object;
                this.setTitle(instance.getTitle());
                this.setThreadTs(instance.getThreadTs());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SetTitleParams build() {
            this.checkRequiredAttributes();
            return new SetTitleParams(this.channelId, this.threadTs, this.title);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            return "Cannot build SetTitleParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SetTitleParamsIF", generator="Immutables")
    static final class Json
    implements SetTitleParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String threadTs;
        @Nullable
        String title;

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }
    }
}

