/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.assistant.SetThreadStatusParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SetThreadStatusParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SetThreadStatusParams
implements SetThreadStatusParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String status;
    private final String threadTs;

    private SetThreadStatusParams(String channelId, String status, String threadTs) {
        this.channelId = channelId;
        this.status = status;
        this.threadTs = threadTs;
        this.channel = Objects.requireNonNull(SetThreadStatusParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    public final SetThreadStatusParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SetThreadStatusParams(newValue, this.status, this.threadTs);
    }

    public final SetThreadStatusParams withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new SetThreadStatusParams(this.channelId, newValue, this.threadTs);
    }

    public final SetThreadStatusParams withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new SetThreadStatusParams(this.channelId, this.status, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SetThreadStatusParams && this.equalTo(0, (SetThreadStatusParams)another);
    }

    private boolean equalTo(int synthetic, SetThreadStatusParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.status.equals(another.status) && this.threadTs.equals(another.threadTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        return h;
    }

    public String toString() {
        return "SetThreadStatusParams{channelId=" + this.channelId + ", channel=" + this.channel + ", status=" + this.status + ", threadTs=" + this.threadTs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SetThreadStatusParams fromJson(Json json) {
        Builder builder = SetThreadStatusParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.status != null) {
            builder.setStatus(json.status);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        return builder.build();
    }

    public static SetThreadStatusParams copyOf(SetThreadStatusParamsIF instance) {
        if (instance instanceof SetThreadStatusParams) {
            return (SetThreadStatusParams)instance;
        }
        return SetThreadStatusParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetThreadStatusParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long INIT_BIT_THREAD_TS = 4L;
        private long initBits = 7L;
        @Nullable
        private String channelId;
        @Nullable
        private String status;
        @Nullable
        private String threadTs;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SetThreadStatusParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SetThreadStatusParamsIF) {
                instance = (SetThreadStatusParamsIF)object;
                this.setThreadTs(instance.getThreadTs());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
                this.setStatus(instance.getStatus());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStatus(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SetThreadStatusParams build() {
            this.checkRequiredAttributes();
            return new SetThreadStatusParams(this.channelId, this.status, this.threadTs);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean statusIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.statusIsSet()) {
                attributes.add("status");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            return "Cannot build SetThreadStatusParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SetThreadStatusParamsIF", generator="Immutables")
    static final class Json
    implements SetThreadStatusParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String status;
        @Nullable
        String threadTs;

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }
    }
}

