/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.assistant.Prompt;
import com.hubspot.slack.client.methods.params.assistant.SetSuggestedPromptsParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SetSuggestedPromptsParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SetSuggestedPromptsParams
implements SetSuggestedPromptsParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String threadTs;
    @Nullable
    private final String title;
    private final List<Prompt> prompts;

    private SetSuggestedPromptsParams(String channelId, String threadTs, @Nullable String title, List<Prompt> prompts) {
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.title = title;
        this.prompts = prompts;
        this.channel = Objects.requireNonNull(SetSuggestedPromptsParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public final SetSuggestedPromptsParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SetSuggestedPromptsParams(newValue, this.threadTs, this.title, this.prompts);
    }

    public final SetSuggestedPromptsParams withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new SetSuggestedPromptsParams(this.channelId, newValue, this.title, this.prompts);
    }

    public final SetSuggestedPromptsParams withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new SetSuggestedPromptsParams(this.channelId, this.threadTs, newValue, this.prompts);
    }

    public final SetSuggestedPromptsParams withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new SetSuggestedPromptsParams(this.channelId, this.threadTs, value, this.prompts);
    }

    public final SetSuggestedPromptsParams withPrompts(Prompt ... elements) {
        List<Prompt> newValue = SetSuggestedPromptsParams.createUnmodifiableList(false, SetSuggestedPromptsParams.createSafeList(Arrays.asList(elements), true, false));
        return new SetSuggestedPromptsParams(this.channelId, this.threadTs, this.title, newValue);
    }

    public final SetSuggestedPromptsParams withPrompts(Iterable<? extends Prompt> elements) {
        if (this.prompts == elements) {
            return this;
        }
        List<Prompt> newValue = SetSuggestedPromptsParams.createUnmodifiableList(false, SetSuggestedPromptsParams.createSafeList(elements, true, false));
        return new SetSuggestedPromptsParams(this.channelId, this.threadTs, this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SetSuggestedPromptsParams && this.equalTo(0, (SetSuggestedPromptsParams)another);
    }

    private boolean equalTo(int synthetic, SetSuggestedPromptsParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.threadTs.equals(another.threadTs) && Objects.equals(this.title, another.title) && this.prompts.equals(another.prompts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + this.prompts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SetSuggestedPromptsParams{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("threadTs=").append(this.threadTs);
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        builder.append(", ");
        builder.append("prompts=").append(this.prompts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SetSuggestedPromptsParams fromJson(Json json) {
        Builder builder = SetSuggestedPromptsParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.prompts != null) {
            builder.addAllPrompts(json.prompts);
        }
        return builder.build();
    }

    public static SetSuggestedPromptsParams copyOf(SetSuggestedPromptsParamsIF instance) {
        if (instance instanceof SetSuggestedPromptsParams) {
            return (SetSuggestedPromptsParams)instance;
        }
        return SetSuggestedPromptsParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SetSuggestedPromptsParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_THREAD_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String title;
        private List<Prompt> prompts = new ArrayList<Prompt>();

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SetSuggestedPromptsParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof SetSuggestedPromptsParamsIF) {
                instance = (SetSuggestedPromptsParamsIF)object;
                Optional<String> titleOptional = instance.getTitle();
                if (titleOptional.isPresent()) {
                    this.setTitle(titleOptional);
                }
                this.setThreadTs(instance.getThreadTs());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
                this.addAllPrompts(instance.getPrompts());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder addPrompts(Prompt element) {
            this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            return this;
        }

        public final Builder addPrompts(Prompt ... elements) {
            for (Prompt element : elements) {
                this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            }
            return this;
        }

        public final Builder setPrompts(Iterable<? extends Prompt> elements) {
            this.prompts.clear();
            return this.addAllPrompts(elements);
        }

        public final Builder addAllPrompts(Iterable<? extends Prompt> elements) {
            for (Prompt prompt : elements) {
                this.prompts.add(Objects.requireNonNull(prompt, "prompts element"));
            }
            return this;
        }

        public SetSuggestedPromptsParams build() {
            this.checkRequiredAttributes();
            return new SetSuggestedPromptsParams(this.channelId, this.threadTs, this.title, SetSuggestedPromptsParams.createUnmodifiableList(true, this.prompts));
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            return "Cannot build SetSuggestedPromptsParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SetSuggestedPromptsParamsIF", generator="Immutables")
    static final class Json
    implements SetSuggestedPromptsParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String threadTs;
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        List<Prompt> prompts = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setPrompts(List<Prompt> prompts) {
            this.prompts = prompts;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Prompt> getPrompts() {
            throw new UnsupportedOperationException();
        }
    }
}

