/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.assistant.PromptIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="PromptIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Prompt
implements PromptIF {
    private final String title;
    private final String message;

    private Prompt(String title, String message) {
        this.title = title;
        this.message = message;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    public final Prompt withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new Prompt(newValue, this.message);
    }

    public final Prompt withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new Prompt(this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Prompt && this.equalTo(0, (Prompt)another);
    }

    private boolean equalTo(int synthetic, Prompt another) {
        return this.title.equals(another.title) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "Prompt{title=" + this.title + ", message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Prompt fromJson(Json json) {
        Builder builder = Prompt.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        return builder.build();
    }

    public static Prompt copyOf(PromptIF instance) {
        if (instance instanceof Prompt) {
            return (Prompt)instance;
        }
        return Prompt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PromptIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String title;
        @Nullable
        private String message;

        private Builder() {
        }

        public final Builder from(PromptIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            this.setMessage(instance.getMessage());
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessage(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Prompt build() {
            this.checkRequiredAttributes();
            return new Prompt(this.title, this.message);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            return "Cannot build Prompt, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PromptIF", generator="Immutables")
    static final class Json
    implements PromptIF {
        @Nullable
        String title;
        @Nullable
        String message;

        Json() {
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

