/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.views.HomeTabViewPayloadBase;
import com.hubspot.slack.client.models.views.HomeTabViewPayloadIF;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="HomeTabViewPayloadIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class HomeTabViewPayload
implements HomeTabViewPayloadIF {
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;
    private final transient String type;
    private final List<Block> blocks;

    private HomeTabViewPayload(Iterable<? extends Block> blocks) {
        this.blocks = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(blocks, true, false));
        this.privateMetadata = null;
        this.callbackId = null;
        this.externalId = null;
        this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
    }

    private HomeTabViewPayload(@Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId, List<Block> blocks) {
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.blocks = blocks;
        this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public final HomeTabViewPayload withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(newValue, this.callbackId, this.externalId, this.blocks);
    }

    public final HomeTabViewPayload withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new HomeTabViewPayload(value, this.callbackId, this.externalId, this.blocks);
    }

    public final HomeTabViewPayload withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(this.privateMetadata, newValue, this.externalId, this.blocks);
    }

    public final HomeTabViewPayload withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new HomeTabViewPayload(this.privateMetadata, value, this.externalId, this.blocks);
    }

    public final HomeTabViewPayload withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(this.privateMetadata, this.callbackId, newValue, this.blocks);
    }

    public final HomeTabViewPayload withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new HomeTabViewPayload(this.privateMetadata, this.callbackId, value, this.blocks);
    }

    public final HomeTabViewPayload withBlocks(Block ... elements) {
        List<Block> newValue = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(Arrays.asList(elements), true, false));
        return new HomeTabViewPayload(this.privateMetadata, this.callbackId, this.externalId, newValue);
    }

    public final HomeTabViewPayload withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(elements, true, false));
        return new HomeTabViewPayload(this.privateMetadata, this.callbackId, this.externalId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HomeTabViewPayload && this.equalTo(0, (HomeTabViewPayload)another);
    }

    private boolean equalTo(int synthetic, HomeTabViewPayload another) {
        return Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId) && this.type.equals(another.type) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.privateMetadata);
        h += (h << 5) + Objects.hashCode(this.callbackId);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HomeTabViewPayload{");
        if (this.privateMetadata != null) {
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("externalId=").append(this.externalId);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static HomeTabViewPayload fromJson(Json json) {
        Builder builder = HomeTabViewPayload.builder();
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        return builder.build();
    }

    public static HomeTabViewPayload of(List<Block> blocks) {
        return HomeTabViewPayload.of(blocks);
    }

    public static HomeTabViewPayload of(Iterable<? extends Block> blocks) {
        return new HomeTabViewPayload(blocks);
    }

    public static HomeTabViewPayload copyOf(HomeTabViewPayloadIF instance) {
        if (instance instanceof HomeTabViewPayload) {
            return (HomeTabViewPayload)instance;
        }
        return HomeTabViewPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HomeTabViewPayloadIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;
        private List<Block> blocks = new ArrayList<Block>();

        private Builder() {
        }

        public final Builder from(HomeTabViewPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HomeTabViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> callbackIdOptional;
            Optional<String> privateMetadataOptional;
            Optional<String> externalIdOptional;
            ViewPayloadBase instance;
            long bits = 0L;
            if (object instanceof HomeTabViewPayloadIF) {
                instance = (HomeTabViewPayloadIF)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof HomeTabViewPayloadBase) {
                instance = (HomeTabViewPayloadBase)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewPayloadBase) {
                instance = (ViewPayloadBase)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public HomeTabViewPayload build() {
            return new HomeTabViewPayload(this.privateMetadata, this.callbackId, this.externalId, HomeTabViewPayload.createUnmodifiableList(true, this.blocks));
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HomeTabViewPayloadIF", generator="Immutables")
    static final class Json
    implements HomeTabViewPayloadIF {
        @Nullable
        Optional<String> privateMetadata = Optional.empty();
        @Nullable
        Optional<String> callbackId = Optional.empty();
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        List<Block> blocks = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }
    }
}

