/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.usergroups.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.usergroups.users.UsergroupUsersUpdateResponseIF;
import com.hubspot.slack.client.models.usergroups.SlackUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsergroupUsersUpdateResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsergroupUsersUpdateResponse
implements UsergroupUsersUpdateResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final SlackUsergroup usergroup;

    private UsergroupUsersUpdateResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, SlackUsergroup usergroup) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.usergroup = usergroup;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public SlackUsergroup getUsergroup() {
        return this.usergroup;
    }

    public final UsergroupUsersUpdateResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new UsergroupUsersUpdateResponse(value, this.responseMetadata, this.usergroup);
    }

    public final UsergroupUsersUpdateResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsergroupUsersUpdateResponse(this.ok, newValue, this.usergroup);
    }

    public final UsergroupUsersUpdateResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsergroupUsersUpdateResponse(this.ok, value, this.usergroup);
    }

    public final UsergroupUsersUpdateResponse withUsergroup(SlackUsergroup value) {
        if (this.usergroup == value) {
            return this;
        }
        SlackUsergroup newValue = Objects.requireNonNull(value, "usergroup");
        return new UsergroupUsersUpdateResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupUsersUpdateResponse && this.equalTo(0, (UsergroupUsersUpdateResponse)another);
    }

    private boolean equalTo(int synthetic, UsergroupUsersUpdateResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.usergroup.equals(another.usergroup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.usergroup.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupUsersUpdateResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("usergroup=").append(this.usergroup);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsergroupUsersUpdateResponse fromJson(Json json) {
        Builder builder = UsergroupUsersUpdateResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.usergroup != null) {
            builder.setUsergroup(json.usergroup);
        }
        return builder.build();
    }

    public static UsergroupUsersUpdateResponse copyOf(UsergroupUsersUpdateResponseIF instance) {
        if (instance instanceof UsergroupUsersUpdateResponse) {
            return (UsergroupUsersUpdateResponse)instance;
        }
        return UsergroupUsersUpdateResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UsergroupUsersUpdateResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_USERGROUP = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private SlackUsergroup usergroup;

        private Builder() {
        }

        public final Builder from(UsergroupUsersUpdateResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof UsergroupUsersUpdateResponseIF) {
                instance = (UsergroupUsersUpdateResponseIF)object;
                this.setUsergroup(instance.getUsergroup());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setUsergroup(SlackUsergroup usergroup) {
            this.usergroup = Objects.requireNonNull(usergroup, "usergroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UsergroupUsersUpdateResponse build() {
            this.checkRequiredAttributes();
            return new UsergroupUsersUpdateResponse(this.ok, this.responseMetadata, this.usergroup);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean usergroupIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.usergroupIsSet()) {
                attributes.add("usergroup");
            }
            return "Cannot build UsergroupUsersUpdateResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsergroupUsersUpdateResponseIF", generator="Immutables")
    static final class Json
    implements UsergroupUsersUpdateResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        SlackUsergroup usergroup;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setUsergroup(SlackUsergroup usergroup) {
            this.usergroup = usergroup;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUsergroup getUsergroup() {
            throw new UnsupportedOperationException();
        }
    }
}

