/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.team;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.team.TeamInfoResponseIF;
import com.hubspot.slack.client.models.teams.SlackTeam;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TeamInfoResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class TeamInfoResponse
implements TeamInfoResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final SlackTeam slackTeam;

    private TeamInfoResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, SlackTeam slackTeam) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.slackTeam = slackTeam;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty(value="team")
    public SlackTeam getSlackTeam() {
        return this.slackTeam;
    }

    public final TeamInfoResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new TeamInfoResponse(value, this.responseMetadata, this.slackTeam);
    }

    public final TeamInfoResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new TeamInfoResponse(this.ok, newValue, this.slackTeam);
    }

    public final TeamInfoResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new TeamInfoResponse(this.ok, value, this.slackTeam);
    }

    public final TeamInfoResponse withSlackTeam(SlackTeam value) {
        if (this.slackTeam == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "slackTeam");
        return new TeamInfoResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TeamInfoResponse && this.equalTo(0, (TeamInfoResponse)another);
    }

    private boolean equalTo(int synthetic, TeamInfoResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.slackTeam.equals(another.slackTeam);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.slackTeam.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TeamInfoResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("slackTeam=").append(this.slackTeam);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TeamInfoResponse fromJson(Json json) {
        Builder builder = TeamInfoResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.slackTeam != null) {
            builder.setSlackTeam(json.slackTeam);
        }
        return builder.build();
    }

    public static TeamInfoResponse copyOf(TeamInfoResponseIF instance) {
        if (instance instanceof TeamInfoResponse) {
            return (TeamInfoResponse)instance;
        }
        return TeamInfoResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamInfoResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_SLACK_TEAM = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private SlackTeam slackTeam;

        private Builder() {
        }

        public final Builder from(TeamInfoResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof TeamInfoResponseIF) {
                instance = (TeamInfoResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setSlackTeam(instance.getSlackTeam());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setSlackTeam(SlackTeam slackTeam) {
            this.slackTeam = Objects.requireNonNull(slackTeam, "slackTeam");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public TeamInfoResponse build() {
            this.checkRequiredAttributes();
            return new TeamInfoResponse(this.ok, this.responseMetadata, this.slackTeam);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean slackTeamIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.slackTeamIsSet()) {
                attributes.add("slackTeam");
            }
            return "Cannot build TeamInfoResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamInfoResponseIF", generator="Immutables")
    static final class Json
    implements TeamInfoResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        SlackTeam slackTeam;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty(value="team")
        public void setSlackTeam(SlackTeam slackTeam) {
            this.slackTeam = slackTeam;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getSlackTeam() {
            throw new UnsupportedOperationException();
        }
    }
}

