/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.MessagePage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.search.SearchMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SearchMessageResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SearchMessageResponse
implements SearchMessageResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String query;
    private final MessagePage messages;

    private SearchMessageResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String query, MessagePage messages) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.query = query;
        this.messages = messages;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @Override
    @JsonProperty
    public MessagePage getMessages() {
        return this.messages;
    }

    public final SearchMessageResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new SearchMessageResponse(value, this.responseMetadata, this.query, this.messages);
    }

    public final SearchMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new SearchMessageResponse(this.ok, newValue, this.query, this.messages);
    }

    public final SearchMessageResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new SearchMessageResponse(this.ok, value, this.query, this.messages);
    }

    public final SearchMessageResponse withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new SearchMessageResponse(this.ok, this.responseMetadata, newValue, this.messages);
    }

    public final SearchMessageResponse withMessages(MessagePage value) {
        if (this.messages == value) {
            return this;
        }
        MessagePage newValue = Objects.requireNonNull(value, "messages");
        return new SearchMessageResponse(this.ok, this.responseMetadata, this.query, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SearchMessageResponse && this.equalTo(0, (SearchMessageResponse)another);
    }

    private boolean equalTo(int synthetic, SearchMessageResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.query.equals(another.query) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SearchMessageResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("query=").append(this.query);
        builder.append(", ");
        builder.append("messages=").append(this.messages);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SearchMessageResponse fromJson(Json json) {
        Builder builder = SearchMessageResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.query != null) {
            builder.setQuery(json.query);
        }
        if (json.messages != null) {
            builder.setMessages(json.messages);
        }
        return builder.build();
    }

    public static SearchMessageResponse copyOf(SearchMessageResponseIF instance) {
        if (instance instanceof SearchMessageResponse) {
            return (SearchMessageResponse)instance;
        }
        return SearchMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SearchMessageResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long INIT_BIT_MESSAGES = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String query;
        @Nullable
        private MessagePage messages;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SearchMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SearchMessageResponseIF) {
                instance = (SearchMessageResponseIF)object;
                this.setMessages(instance.getMessages());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setQuery(instance.getQuery());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setQuery(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMessages(MessagePage messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SearchMessageResponse build() {
            this.checkRequiredAttributes();
            return new SearchMessageResponse(this.ok, this.responseMetadata, this.query, this.messages);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean queryIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean messagesIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.queryIsSet()) {
                attributes.add("query");
            }
            if (!this.messagesIsSet()) {
                attributes.add("messages");
            }
            return "Cannot build SearchMessageResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchMessageResponseIF", generator="Immutables")
    static final class Json
    implements SearchMessageResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String query;
        @Nullable
        MessagePage messages;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setQuery(String query) {
            this.query = query;
        }

        @JsonProperty
        public void setMessages(MessagePage messages) {
            this.messages = messages;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessagePage getMessages() {
            throw new UnsupportedOperationException();
        }
    }
}

