/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.im;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.channel.ImChannel;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.im.ImOpenResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ImOpenResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImOpenResponse
implements ImOpenResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final boolean noOp;
    private final boolean alreadyOpen;
    @Nullable
    private final ImChannel channel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImOpenResponse(Builder builder) {
        this.ok = builder.ok;
        this.responseMetadata = builder.responseMetadata;
        this.channel = builder.channel;
        if (builder.noOpIsSet()) {
            this.initShim.setNoOp(builder.noOp);
        }
        if (builder.alreadyOpenIsSet()) {
            this.initShim.setAlreadyOpen(builder.alreadyOpen);
        }
        this.noOp = this.initShim.isNoOp();
        this.alreadyOpen = this.initShim.isAlreadyOpen();
        this.initShim = null;
    }

    private ImOpenResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, boolean noOp, boolean alreadyOpen, @Nullable ImChannel channel) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.noOp = noOp;
        this.alreadyOpen = alreadyOpen;
        this.channel = channel;
        this.initShim = null;
    }

    private boolean isNoOpInitialize() {
        return ImOpenResponseIF.super.isNoOp();
    }

    private boolean isAlreadyOpenInitialize() {
        return ImOpenResponseIF.super.isAlreadyOpen();
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public boolean isNoOp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isNoOp() : this.noOp;
    }

    @Override
    @JsonProperty
    public boolean isAlreadyOpen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAlreadyOpen() : this.alreadyOpen;
    }

    @Override
    @JsonProperty
    public Optional<ImChannel> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    public final ImOpenResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ImOpenResponse(value, this.responseMetadata, this.noOp, this.alreadyOpen, this.channel);
    }

    public final ImOpenResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ImOpenResponse(this.ok, newValue, this.noOp, this.alreadyOpen, this.channel);
    }

    public final ImOpenResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ImOpenResponse(this.ok, value, this.noOp, this.alreadyOpen, this.channel);
    }

    public final ImOpenResponse withNoOp(boolean value) {
        if (this.noOp == value) {
            return this;
        }
        return new ImOpenResponse(this.ok, this.responseMetadata, value, this.alreadyOpen, this.channel);
    }

    public final ImOpenResponse withAlreadyOpen(boolean value) {
        if (this.alreadyOpen == value) {
            return this;
        }
        return new ImOpenResponse(this.ok, this.responseMetadata, this.noOp, value, this.channel);
    }

    public final ImOpenResponse withChannel(@Nullable ImChannel value) {
        ImChannel newValue = value;
        if (this.channel == newValue) {
            return this;
        }
        return new ImOpenResponse(this.ok, this.responseMetadata, this.noOp, this.alreadyOpen, newValue);
    }

    public final ImOpenResponse withChannel(Optional<? extends ImChannel> optional) {
        ImChannel value = optional.orElse(null);
        if (this.channel == value) {
            return this;
        }
        return new ImOpenResponse(this.ok, this.responseMetadata, this.noOp, this.alreadyOpen, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImOpenResponse && this.equalTo(0, (ImOpenResponse)another);
    }

    private boolean equalTo(int synthetic, ImOpenResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.noOp == another.noOp && this.alreadyOpen == another.alreadyOpen && Objects.equals(this.channel, another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Boolean.hashCode(this.noOp);
        h += (h << 5) + Boolean.hashCode(this.alreadyOpen);
        h += (h << 5) + Objects.hashCode(this.channel);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ImOpenResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("noOp=").append(this.noOp);
        builder.append(", ");
        builder.append("alreadyOpen=").append(this.alreadyOpen);
        if (this.channel != null) {
            builder.append(", ");
            builder.append("channel=").append(this.channel);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImOpenResponse fromJson(Json json) {
        Builder builder = ImOpenResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.noOpIsSet) {
            builder.setNoOp(json.noOp);
        }
        if (json.alreadyOpenIsSet) {
            builder.setAlreadyOpen(json.alreadyOpen);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static ImOpenResponse copyOf(ImOpenResponseIF instance) {
        if (instance instanceof ImOpenResponse) {
            return (ImOpenResponse)instance;
        }
        return ImOpenResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ImOpenResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long OPT_BIT_NO_OP = 1L;
        private static final long OPT_BIT_ALREADY_OPEN = 2L;
        private long initBits = 1L;
        private long optBits;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private boolean noOp;
        private boolean alreadyOpen;
        @Nullable
        private ImChannel channel;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ImOpenResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ImOpenResponseIF) {
                instance = (ImOpenResponseIF)object;
                Optional<ImChannel> channelOptional = instance.getChannel();
                if (channelOptional.isPresent()) {
                    this.setChannel(channelOptional);
                }
                this.setAlreadyOpen(instance.isAlreadyOpen());
                this.setNoOp(instance.isNoOp());
                if ((bits & 1L) == 0L) {
                    Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setChannel(@Nullable ImChannel channel) {
            this.channel = channel;
            return this;
        }

        public final Builder setChannel(Optional<? extends ImChannel> channel) {
            this.channel = channel.orElse(null);
            return this;
        }

        public ImOpenResponse build() {
            this.checkRequiredAttributes();
            return new ImOpenResponse(this);
        }

        private boolean noOpIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean alreadyOpenIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ImOpenResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ImOpenResponseIF", generator="Immutables")
    static final class Json
    implements ImOpenResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        boolean noOp;
        boolean noOpIsSet;
        boolean alreadyOpen;
        boolean alreadyOpenIsSet;
        @Nullable
        Optional<ImChannel> channel = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.noOpIsSet = true;
        }

        @JsonProperty
        public void setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.alreadyOpenIsSet = true;
        }

        @JsonProperty
        public void setChannel(Optional<ImChannel> channel) {
            this.channel = channel;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNoOp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAlreadyOpen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ImChannel> getChannel() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ImOpenResponseIF", generator="Immutables")
    private final class InitShim {
        private byte noOpBuildStage = 0;
        private boolean noOp;
        private byte alreadyOpenBuildStage = 0;
        private boolean alreadyOpen;

        private InitShim() {
        }

        boolean isNoOp() {
            if (this.noOpBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.noOpBuildStage == 0) {
                this.noOpBuildStage = (byte)-1;
                this.noOp = ImOpenResponse.this.isNoOpInitialize();
                this.noOpBuildStage = 1;
            }
            return this.noOp;
        }

        void setNoOp(boolean noOp) {
            this.noOp = noOp;
            this.noOpBuildStage = 1;
        }

        boolean isAlreadyOpen() {
            if (this.alreadyOpenBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.alreadyOpenBuildStage == 0) {
                this.alreadyOpenBuildStage = (byte)-1;
                this.alreadyOpen = ImOpenResponse.this.isAlreadyOpenInitialize();
                this.alreadyOpenBuildStage = 1;
            }
            return this.alreadyOpen;
        }

        void setAlreadyOpen(boolean alreadyOpen) {
            this.alreadyOpen = alreadyOpen;
            this.alreadyOpenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.noOpBuildStage == -1) {
                attributes.add("noOp");
            }
            if (this.alreadyOpenBuildStage == -1) {
                attributes.add("alreadyOpen");
            }
            return "Cannot build ImOpenResponse, attribute initializers form cycle " + attributes;
        }
    }
}

