/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.dnd;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.json.InstantDeserializer;
import com.hubspot.slack.client.models.json.InstantSerializer;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.dnd.DndInfoResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DndInfoResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class DndInfoResponse
implements DndInfoResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final boolean dndEnabled;
    @Nullable
    private final Instant nextDndStart;
    @Nullable
    private final Instant nextDndEnd;
    private final boolean snoozeEnabled;
    @Nullable
    private final Instant snoozeEnd;
    @Nullable
    private final Integer snoozeRemaining;

    private DndInfoResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, boolean dndEnabled, @Nullable Instant nextDndStart, @Nullable Instant nextDndEnd, boolean snoozeEnabled, @Nullable Instant snoozeEnd, @Nullable Integer snoozeRemaining) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.dndEnabled = dndEnabled;
        this.nextDndStart = nextDndStart;
        this.nextDndEnd = nextDndEnd;
        this.snoozeEnabled = snoozeEnabled;
        this.snoozeEnd = snoozeEnd;
        this.snoozeRemaining = snoozeRemaining;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public boolean isDndEnabled() {
        return this.dndEnabled;
    }

    @Override
    @JsonProperty(value="next_dnd_start_ts")
    @JsonSerialize(contentUsing=InstantSerializer.class)
    @JsonDeserialize(contentUsing=InstantDeserializer.class)
    public Optional<Instant> getNextDndStart() {
        return Optional.ofNullable(this.nextDndStart);
    }

    @Override
    @JsonProperty(value="next_dnd_end_ts")
    @JsonSerialize(contentUsing=InstantSerializer.class)
    @JsonDeserialize(contentUsing=InstantDeserializer.class)
    public Optional<Instant> getNextDndEnd() {
        return Optional.ofNullable(this.nextDndEnd);
    }

    @Override
    @JsonProperty
    public boolean isSnoozeEnabled() {
        return this.snoozeEnabled;
    }

    @Override
    @JsonProperty(value="snooze_endtime")
    @JsonSerialize(contentUsing=InstantSerializer.class)
    @JsonDeserialize(contentUsing=InstantDeserializer.class)
    public Optional<Instant> getSnoozeEnd() {
        return Optional.ofNullable(this.snoozeEnd);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getSnoozeRemaining() {
        return Optional.ofNullable(this.snoozeRemaining);
    }

    public final DndInfoResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new DndInfoResponse(value, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new DndInfoResponse(this.ok, newValue, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, value, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withDndEnabled(boolean value) {
        if (this.dndEnabled == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, value, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withNextDndStart(@Nullable Instant value) {
        Instant newValue = value;
        if (this.nextDndStart == newValue) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, newValue, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withNextDndStart(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.nextDndStart == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, value, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withNextDndEnd(@Nullable Instant value) {
        Instant newValue = value;
        if (this.nextDndEnd == newValue) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, newValue, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withNextDndEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.nextDndEnd == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, value, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withSnoozeEnabled(boolean value) {
        if (this.snoozeEnabled == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, value, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndInfoResponse withSnoozeEnd(@Nullable Instant value) {
        Instant newValue = value;
        if (this.snoozeEnd == newValue) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, newValue, this.snoozeRemaining);
    }

    public final DndInfoResponse withSnoozeEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.snoozeEnd == value) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, value, this.snoozeRemaining);
    }

    public final DndInfoResponse withSnoozeRemaining(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.snoozeRemaining, newValue)) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, newValue);
    }

    public final DndInfoResponse withSnoozeRemaining(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.snoozeRemaining, value)) {
            return this;
        }
        return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DndInfoResponse && this.equalTo(0, (DndInfoResponse)another);
    }

    private boolean equalTo(int synthetic, DndInfoResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.dndEnabled == another.dndEnabled && Objects.equals(this.nextDndStart, another.nextDndStart) && Objects.equals(this.nextDndEnd, another.nextDndEnd) && this.snoozeEnabled == another.snoozeEnabled && Objects.equals(this.snoozeEnd, another.snoozeEnd) && Objects.equals(this.snoozeRemaining, another.snoozeRemaining);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Boolean.hashCode(this.dndEnabled);
        h += (h << 5) + Objects.hashCode(this.nextDndStart);
        h += (h << 5) + Objects.hashCode(this.nextDndEnd);
        h += (h << 5) + Boolean.hashCode(this.snoozeEnabled);
        h += (h << 5) + Objects.hashCode(this.snoozeEnd);
        h += (h << 5) + Objects.hashCode(this.snoozeRemaining);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DndInfoResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("dndEnabled=").append(this.dndEnabled);
        if (this.nextDndStart != null) {
            builder.append(", ");
            builder.append("nextDndStart=").append(this.nextDndStart);
        }
        if (this.nextDndEnd != null) {
            builder.append(", ");
            builder.append("nextDndEnd=").append(this.nextDndEnd);
        }
        builder.append(", ");
        builder.append("snoozeEnabled=").append(this.snoozeEnabled);
        if (this.snoozeEnd != null) {
            builder.append(", ");
            builder.append("snoozeEnd=").append(this.snoozeEnd);
        }
        if (this.snoozeRemaining != null) {
            builder.append(", ");
            builder.append("snoozeRemaining=").append(this.snoozeRemaining);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DndInfoResponse fromJson(Json json) {
        Builder builder = DndInfoResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.dndEnabledIsSet) {
            builder.setDndEnabled(json.dndEnabled);
        }
        if (json.nextDndStart != null) {
            builder.setNextDndStart(json.nextDndStart);
        }
        if (json.nextDndEnd != null) {
            builder.setNextDndEnd(json.nextDndEnd);
        }
        if (json.snoozeEnabledIsSet) {
            builder.setSnoozeEnabled(json.snoozeEnabled);
        }
        if (json.snoozeEnd != null) {
            builder.setSnoozeEnd(json.snoozeEnd);
        }
        if (json.snoozeRemaining != null) {
            builder.setSnoozeRemaining(json.snoozeRemaining);
        }
        return builder.build();
    }

    public static DndInfoResponse copyOf(DndInfoResponseIF instance) {
        if (instance instanceof DndInfoResponse) {
            return (DndInfoResponse)instance;
        }
        return DndInfoResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DndInfoResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_DND_ENABLED = 2L;
        private static final long INIT_BIT_SNOOZE_ENABLED = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private boolean dndEnabled;
        @Nullable
        private Instant nextDndStart;
        @Nullable
        private Instant nextDndEnd;
        private boolean snoozeEnabled;
        @Nullable
        private Instant snoozeEnd;
        @Nullable
        private Integer snoozeRemaining;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DndInfoResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof DndInfoResponseIF) {
                Optional<Integer> snoozeRemainingOptional;
                instance = (DndInfoResponseIF)object;
                Optional<Instant> nextDndEndOptional = instance.getNextDndEnd();
                if (nextDndEndOptional.isPresent()) {
                    this.setNextDndEnd(nextDndEndOptional);
                }
                this.setDndEnabled(instance.isDndEnabled());
                Optional<Instant> nextDndStartOptional = instance.getNextDndStart();
                if (nextDndStartOptional.isPresent()) {
                    this.setNextDndStart(nextDndStartOptional);
                }
                if ((snoozeRemainingOptional = instance.getSnoozeRemaining()).isPresent()) {
                    this.setSnoozeRemaining(snoozeRemainingOptional);
                }
                this.setSnoozeEnabled(instance.isSnoozeEnabled());
                Optional<Instant> snoozeEndOptional = instance.getSnoozeEnd();
                if (snoozeEndOptional.isPresent()) {
                    this.setSnoozeEnd(snoozeEndOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setDndEnabled(boolean dndEnabled) {
            this.dndEnabled = dndEnabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setNextDndStart(@Nullable Instant nextDndStart) {
            this.nextDndStart = nextDndStart;
            return this;
        }

        public final Builder setNextDndStart(Optional<? extends Instant> nextDndStart) {
            this.nextDndStart = nextDndStart.orElse(null);
            return this;
        }

        public final Builder setNextDndEnd(@Nullable Instant nextDndEnd) {
            this.nextDndEnd = nextDndEnd;
            return this;
        }

        public final Builder setNextDndEnd(Optional<? extends Instant> nextDndEnd) {
            this.nextDndEnd = nextDndEnd.orElse(null);
            return this;
        }

        public final Builder setSnoozeEnabled(boolean snoozeEnabled) {
            this.snoozeEnabled = snoozeEnabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setSnoozeEnd(@Nullable Instant snoozeEnd) {
            this.snoozeEnd = snoozeEnd;
            return this;
        }

        public final Builder setSnoozeEnd(Optional<? extends Instant> snoozeEnd) {
            this.snoozeEnd = snoozeEnd.orElse(null);
            return this;
        }

        public final Builder setSnoozeRemaining(@Nullable Integer snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining;
            return this;
        }

        public final Builder setSnoozeRemaining(Optional<Integer> snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining.orElse(null);
            return this;
        }

        public DndInfoResponse build() {
            this.checkRequiredAttributes();
            return new DndInfoResponse(this.ok, this.responseMetadata, this.dndEnabled, this.nextDndStart, this.nextDndEnd, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean dndEnabledIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean snoozeEnabledIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.dndEnabledIsSet()) {
                attributes.add("dndEnabled");
            }
            if (!this.snoozeEnabledIsSet()) {
                attributes.add("snoozeEnabled");
            }
            return "Cannot build DndInfoResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DndInfoResponseIF", generator="Immutables")
    static final class Json
    implements DndInfoResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        boolean dndEnabled;
        boolean dndEnabledIsSet;
        @Nullable
        Optional<Instant> nextDndStart = Optional.empty();
        @Nullable
        Optional<Instant> nextDndEnd = Optional.empty();
        boolean snoozeEnabled;
        boolean snoozeEnabledIsSet;
        @Nullable
        Optional<Instant> snoozeEnd = Optional.empty();
        @Nullable
        Optional<Integer> snoozeRemaining = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setDndEnabled(boolean dndEnabled) {
            this.dndEnabled = dndEnabled;
            this.dndEnabledIsSet = true;
        }

        @JsonProperty(value="next_dnd_start_ts")
        @JsonSerialize(contentUsing=InstantSerializer.class)
        @JsonDeserialize(contentUsing=InstantDeserializer.class)
        public void setNextDndStart(Optional<Instant> nextDndStart) {
            this.nextDndStart = nextDndStart;
        }

        @JsonProperty(value="next_dnd_end_ts")
        @JsonSerialize(contentUsing=InstantSerializer.class)
        @JsonDeserialize(contentUsing=InstantDeserializer.class)
        public void setNextDndEnd(Optional<Instant> nextDndEnd) {
            this.nextDndEnd = nextDndEnd;
        }

        @JsonProperty
        public void setSnoozeEnabled(boolean snoozeEnabled) {
            this.snoozeEnabled = snoozeEnabled;
            this.snoozeEnabledIsSet = true;
        }

        @JsonProperty(value="snooze_endtime")
        @JsonSerialize(contentUsing=InstantSerializer.class)
        @JsonDeserialize(contentUsing=InstantDeserializer.class)
        public void setSnoozeEnd(Optional<Instant> snoozeEnd) {
            this.snoozeEnd = snoozeEnd;
        }

        @JsonProperty
        public void setSnoozeRemaining(Optional<Integer> snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDndEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getNextDndStart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getNextDndEnd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSnoozeEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getSnoozeEnd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getSnoozeRemaining() {
            throw new UnsupportedOperationException();
        }
    }
}

