/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsInfoResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChannelsInfoResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelsInfoResponse
implements ChannelsInfoResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final SlackChannel channel;

    private ChannelsInfoResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, SlackChannel channel) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.channel = channel;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    public final ChannelsInfoResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChannelsInfoResponse(value, this.responseMetadata, this.channel);
    }

    public final ChannelsInfoResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChannelsInfoResponse(this.ok, newValue, this.channel);
    }

    public final ChannelsInfoResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChannelsInfoResponse(this.ok, value, this.channel);
    }

    public final ChannelsInfoResponse withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new ChannelsInfoResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsInfoResponse && this.equalTo(0, (ChannelsInfoResponse)another);
    }

    private boolean equalTo(int synthetic, ChannelsInfoResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsInfoResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelsInfoResponse fromJson(Json json) {
        Builder builder = ChannelsInfoResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static ChannelsInfoResponse copyOf(ChannelsInfoResponseIF instance) {
        if (instance instanceof ChannelsInfoResponse) {
            return (ChannelsInfoResponse)instance;
        }
        return ChannelsInfoResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelsInfoResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChannelsInfoResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelsInfoResponseIF) {
                instance = (ChannelsInfoResponseIF)object;
                this.setChannel(instance.getChannel());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ChannelsInfoResponse build() {
            this.checkRequiredAttributes();
            return new ChannelsInfoResponse(this.ok, this.responseMetadata, this.channel);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build ChannelsInfoResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelsInfoResponseIF", generator="Immutables")
    static final class Json
    implements ChannelsInfoResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

