/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.channels.AbstractChannelsHistoryResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractChannelsHistoryResponse", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelsHistoryResponse
extends AbstractChannelsHistoryResponse {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    @Nullable
    private final Boolean inclusive;
    @Nullable
    private final String newestTimestamp;
    @Nullable
    private final String oldestTimestamp;
    private final transient PagingDirection pagingDirection;
    private final boolean hasMore;
    private final List<LiteMessage> messages;

    private ChannelsHistoryResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, @Nullable Boolean inclusive, @Nullable String newestTimestamp, @Nullable String oldestTimestamp, boolean hasMore, List<LiteMessage> messages) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.inclusive = inclusive;
        this.newestTimestamp = newestTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.hasMore = hasMore;
        this.messages = messages;
        this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty(value="inclusive")
    public Optional<Boolean> isInclusive() {
        return Optional.ofNullable(this.inclusive);
    }

    @Override
    @JsonProperty(value="latest")
    public Optional<String> getNewestTimestamp() {
        return Optional.ofNullable(this.newestTimestamp);
    }

    @Override
    @JsonProperty(value="oldest")
    public Optional<String> getOldestTimestamp() {
        return Optional.ofNullable(this.oldestTimestamp);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public PagingDirection getPagingDirection() {
        return this.pagingDirection;
    }

    @Override
    @JsonProperty(value="has_more")
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    @JsonProperty
    public List<LiteMessage> getMessages() {
        return this.messages;
    }

    public final ChannelsHistoryResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChannelsHistoryResponse(value, this.responseMetadata, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, newValue, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, value, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withInclusive(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.inclusive, newValue)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, newValue, this.newestTimestamp, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withInclusive(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.inclusive, value)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, value, this.newestTimestamp, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withNewestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.newestTimestamp, newValue)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, newValue, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withNewestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.newestTimestamp, value)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, value, this.oldestTimestamp, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withOldestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.oldestTimestamp, newValue)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, newValue, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withOldestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.oldestTimestamp, value)) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, value, this.hasMore, this.messages);
    }

    public final ChannelsHistoryResponse withHasMore(boolean value) {
        if (this.hasMore == value) {
            return this;
        }
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, this.oldestTimestamp, value, this.messages);
    }

    public final ChannelsHistoryResponse withMessages(LiteMessage ... elements) {
        List<LiteMessage> newValue = ChannelsHistoryResponse.createUnmodifiableList(false, ChannelsHistoryResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, newValue);
    }

    public final ChannelsHistoryResponse withMessages(Iterable<? extends LiteMessage> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<LiteMessage> newValue = ChannelsHistoryResponse.createUnmodifiableList(false, ChannelsHistoryResponse.createSafeList(elements, true, false));
        return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsHistoryResponse && this.equalTo(0, (ChannelsHistoryResponse)another);
    }

    private boolean equalTo(int synthetic, ChannelsHistoryResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && Objects.equals(this.inclusive, another.inclusive) && Objects.equals(this.newestTimestamp, another.newestTimestamp) && Objects.equals(this.oldestTimestamp, another.oldestTimestamp) && this.pagingDirection.equals((Object)another.pagingDirection) && this.hasMore == another.hasMore && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Objects.hashCode(this.inclusive);
        h += (h << 5) + Objects.hashCode(this.newestTimestamp);
        h += (h << 5) + Objects.hashCode(this.oldestTimestamp);
        h += (h << 5) + this.pagingDirection.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasMore);
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsHistoryResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        if (this.inclusive != null) {
            builder.append(", ");
            builder.append("inclusive=").append(this.inclusive);
        }
        if (this.newestTimestamp != null) {
            builder.append(", ");
            builder.append("newestTimestamp=").append(this.newestTimestamp);
        }
        if (this.oldestTimestamp != null) {
            builder.append(", ");
            builder.append("oldestTimestamp=").append(this.oldestTimestamp);
        }
        builder.append(", ");
        builder.append("pagingDirection=").append((Object)this.pagingDirection);
        builder.append(", ");
        builder.append("hasMore=").append(this.hasMore);
        builder.append(", ");
        builder.append("messages=").append(this.messages);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelsHistoryResponse fromJson(Json json) {
        Builder builder = ChannelsHistoryResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.inclusive != null) {
            builder.setInclusive(json.inclusive);
        }
        if (json.newestTimestamp != null) {
            builder.setNewestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.setOldestTimestamp(json.oldestTimestamp);
        }
        if (json.hasMoreIsSet) {
            builder.setHasMore(json.hasMore);
        }
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        return builder.build();
    }

    public static ChannelsHistoryResponse copyOf(AbstractChannelsHistoryResponse instance) {
        if (instance instanceof ChannelsHistoryResponse) {
            return (ChannelsHistoryResponse)instance;
        }
        return ChannelsHistoryResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractChannelsHistoryResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_HAS_MORE = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private Boolean inclusive;
        @Nullable
        private String newestTimestamp;
        @Nullable
        private String oldestTimestamp;
        private boolean hasMore;
        private List<LiteMessage> messages = new ArrayList<LiteMessage>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractChannelsHistoryResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TimeIntervalFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> newestTimestampOptional;
            Optional<Boolean> inclusiveOptional;
            Optional<String> oldestTimestampOptional;
            Optional<ResponseMetadata> responseMetadataOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 0x10L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 0x10L;
                }
                if ((bits & 8L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof AbstractChannelsHistoryResponse) {
                instance = (AbstractChannelsHistoryResponse)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    inclusiveOptional = instance.isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
                this.setHasMore(((AbstractChannelsHistoryResponse)instance).hasMore());
                this.addAllMessages(((AbstractChannelsHistoryResponse)instance).getMessages());
                if ((bits & 8L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 0x10L;
                }
            }
            if (object instanceof TimeIntervalFilter) {
                instance = (TimeIntervalFilter)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    inclusiveOptional = instance.isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setInclusive(@Nullable Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final Builder setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive.orElse(null);
            return this;
        }

        public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
            return this;
        }

        public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp.orElse(null);
            return this;
        }

        public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
            return this;
        }

        public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp.orElse(null);
            return this;
        }

        public final Builder setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addMessages(LiteMessage element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(LiteMessage ... elements) {
            for (LiteMessage element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
            for (LiteMessage liteMessage : elements) {
                this.messages.add(Objects.requireNonNull(liteMessage, "messages element"));
            }
            return this;
        }

        public ChannelsHistoryResponse build() {
            this.checkRequiredAttributes();
            return new ChannelsHistoryResponse(this.ok, this.responseMetadata, this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.hasMore, ChannelsHistoryResponse.createUnmodifiableList(true, this.messages));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean hasMoreIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.hasMoreIsSet()) {
                attributes.add("hasMore");
            }
            return "Cannot build ChannelsHistoryResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractChannelsHistoryResponse", generator="Immutables")
    static final class Json
    extends AbstractChannelsHistoryResponse {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        Optional<Boolean> inclusive = Optional.empty();
        @Nullable
        Optional<String> newestTimestamp = Optional.empty();
        @Nullable
        Optional<String> oldestTimestamp = Optional.empty();
        boolean hasMore;
        boolean hasMoreIsSet;
        @Nullable
        List<LiteMessage> messages = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty(value="inclusive")
        public void setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive;
        }

        @JsonProperty(value="latest")
        public void setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldest")
        public void setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @JsonProperty(value="has_more")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @JsonProperty
        public void setMessages(List<LiteMessage> messages) {
            this.messages = messages;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isInclusive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public PagingDirection getPagingDirection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LiteMessage> getMessages() {
            throw new UnsupportedOperationException();
        }
    }
}

