/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.auth.AuthTestResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthTestResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class AuthTestResponse
implements AuthTestResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String url;
    private final String team;
    private final String teamId;
    @Nullable
    private final String user;
    @Nullable
    private final String userId;

    private AuthTestResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String url, String team, String teamId, @Nullable String user, @Nullable String userId) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.url = url;
        this.team = team;
        this.teamId = teamId;
        this.user = user;
        this.userId = userId;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty
    public String getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty
    public Optional<String> getUserId() {
        return Optional.ofNullable(this.userId);
    }

    public final AuthTestResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new AuthTestResponse(value, this.responseMetadata, this.url, this.team, this.teamId, this.user, this.userId);
    }

    public final AuthTestResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new AuthTestResponse(this.ok, newValue, this.url, this.team, this.teamId, this.user, this.userId);
    }

    public final AuthTestResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new AuthTestResponse(this.ok, value, this.url, this.team, this.teamId, this.user, this.userId);
    }

    public final AuthTestResponse withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, newValue, this.team, this.teamId, this.user, this.userId);
    }

    public final AuthTestResponse withTeam(String value) {
        String newValue = Objects.requireNonNull(value, "team");
        if (this.team.equals(newValue)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, newValue, this.teamId, this.user, this.userId);
    }

    public final AuthTestResponse withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, newValue, this.user, this.userId);
    }

    public final AuthTestResponse withUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.user, newValue)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, this.teamId, newValue, this.userId);
    }

    public final AuthTestResponse withUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, this.teamId, value, this.userId);
    }

    public final AuthTestResponse withUserId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.userId, newValue)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, this.teamId, this.user, newValue);
    }

    public final AuthTestResponse withUserId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userId, value)) {
            return this;
        }
        return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, this.teamId, this.user, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuthTestResponse && this.equalTo(0, (AuthTestResponse)another);
    }

    private boolean equalTo(int synthetic, AuthTestResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.url.equals(another.url) && this.team.equals(another.team) && this.teamId.equals(another.teamId) && Objects.equals(this.user, another.user) && Objects.equals(this.userId, another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.userId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AuthTestResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("url=").append(this.url);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        if (this.userId != null) {
            builder.append(", ");
            builder.append("userId=").append(this.userId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AuthTestResponse fromJson(Json json) {
        Builder builder = AuthTestResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        return builder.build();
    }

    public static AuthTestResponse copyOf(AuthTestResponseIF instance) {
        if (instance instanceof AuthTestResponse) {
            return (AuthTestResponse)instance;
        }
        return AuthTestResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthTestResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_TEAM = 4L;
        private static final long INIT_BIT_TEAM_ID = 8L;
        private long initBits = 15L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String url;
        @Nullable
        private String team;
        @Nullable
        private String teamId;
        @Nullable
        private String user;
        @Nullable
        private String userId;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AuthTestResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AuthTestResponseIF) {
                Optional<String> userOptional;
                Optional<String> userIdOptional;
                instance = (AuthTestResponseIF)object;
                this.setTeamId(instance.getTeamId());
                this.setTeam(instance.getTeam());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((userIdOptional = instance.getUserId()).isPresent()) {
                    this.setUserId(userIdOptional);
                }
                if ((userOptional = instance.getUser()).isPresent()) {
                    this.setUser(userOptional);
                }
                this.setUrl(instance.getUrl());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeam(String team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder setUser(Optional<String> user) {
            this.user = user.orElse(null);
            return this;
        }

        public final Builder setUserId(@Nullable String userId) {
            this.userId = userId;
            return this;
        }

        public final Builder setUserId(Optional<String> userId) {
            this.userId = userId.orElse(null);
            return this;
        }

        public AuthTestResponse build() {
            this.checkRequiredAttributes();
            return new AuthTestResponse(this.ok, this.responseMetadata, this.url, this.team, this.teamId, this.user, this.userId);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            return "Cannot build AuthTestResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthTestResponseIF", generator="Immutables")
    static final class Json
    implements AuthTestResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String url;
        @Nullable
        String team;
        @Nullable
        String teamId;
        @Nullable
        Optional<String> user = Optional.empty();
        @Nullable
        Optional<String> userId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setTeam(String team) {
            this.team = team;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setUser(Optional<String> user) {
            this.user = user;
        }

        @JsonProperty
        public void setUserId(Optional<String> userId) {
            this.userId = userId;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

