/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackError;
import com.hubspot.slack.client.models.response.SlackErrorResponseIF;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackErrorResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackErrorResponse
implements SlackErrorResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    @Nullable
    private final SlackError error;
    private final List<SlackError> errors;

    private SlackErrorResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, @Nullable SlackError error, List<SlackError> errors) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.error = error;
        this.errors = errors;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public Optional<SlackError> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    @JsonProperty
    public List<SlackError> getErrors() {
        return this.errors;
    }

    public final SlackErrorResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new SlackErrorResponse(value, this.responseMetadata, this.error, this.errors);
    }

    public final SlackErrorResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new SlackErrorResponse(this.ok, newValue, this.error, this.errors);
    }

    public final SlackErrorResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new SlackErrorResponse(this.ok, value, this.error, this.errors);
    }

    public final SlackErrorResponse withError(@Nullable SlackError value) {
        SlackError newValue = value;
        if (this.error == newValue) {
            return this;
        }
        return new SlackErrorResponse(this.ok, this.responseMetadata, newValue, this.errors);
    }

    public final SlackErrorResponse withError(Optional<? extends SlackError> optional) {
        SlackError value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new SlackErrorResponse(this.ok, this.responseMetadata, value, this.errors);
    }

    public final SlackErrorResponse withErrors(SlackError ... elements) {
        List<SlackError> newValue = SlackErrorResponse.createUnmodifiableList(false, SlackErrorResponse.createSafeList(Arrays.asList(elements), true, false));
        return new SlackErrorResponse(this.ok, this.responseMetadata, this.error, newValue);
    }

    public final SlackErrorResponse withErrors(Iterable<? extends SlackError> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<SlackError> newValue = SlackErrorResponse.createUnmodifiableList(false, SlackErrorResponse.createSafeList(elements, true, false));
        return new SlackErrorResponse(this.ok, this.responseMetadata, this.error, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackErrorResponse && this.equalTo(0, (SlackErrorResponse)another);
    }

    private boolean equalTo(int synthetic, SlackErrorResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && Objects.equals(this.error, another.error) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackErrorResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        if (this.error != null) {
            builder.append(", ");
            builder.append("error=").append(this.error);
        }
        builder.append(", ");
        builder.append("errors=").append(this.errors);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackErrorResponse fromJson(Json json) {
        Builder builder = SlackErrorResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.error != null) {
            builder.setError(json.error);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        return builder.build();
    }

    public static SlackErrorResponse copyOf(SlackErrorResponseIF instance) {
        if (instance instanceof SlackErrorResponse) {
            return (SlackErrorResponse)instance;
        }
        return SlackErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackErrorResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private SlackError error;
        private List<SlackError> errors = new ArrayList<SlackError>();

        private Builder() {
        }

        public final Builder from(SlackErrorResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackErrorResponseIF) {
                Optional<SlackError> errorOptional;
                instance = (SlackErrorResponseIF)object;
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((errorOptional = instance.getError()).isPresent()) {
                    this.setError(errorOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllErrors(instance.getErrors());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setError(@Nullable SlackError error) {
            this.error = error;
            return this;
        }

        public final Builder setError(Optional<? extends SlackError> error) {
            this.error = error.orElse(null);
            return this;
        }

        public final Builder addErrors(SlackError element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder addErrors(SlackError ... elements) {
            for (SlackError element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        public final Builder setErrors(Iterable<? extends SlackError> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends SlackError> elements) {
            for (SlackError slackError : elements) {
                this.errors.add(Objects.requireNonNull(slackError, "errors element"));
            }
            return this;
        }

        public SlackErrorResponse build() {
            this.checkRequiredAttributes();
            return new SlackErrorResponse(this.ok, this.responseMetadata, this.error, SlackErrorResponse.createUnmodifiableList(true, this.errors));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build SlackErrorResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackErrorResponseIF", generator="Immutables")
    static final class Json
    implements SlackErrorResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        Optional<SlackError> error = Optional.empty();
        @Nullable
        List<SlackError> errors = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setError(Optional<SlackError> error) {
            this.error = error;
        }

        @JsonProperty
        public void setErrors(List<SlackError> errors) {
            this.errors = errors;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackError> getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackError> getErrors() {
            throw new UnsupportedOperationException();
        }
    }
}

