/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.PagingIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="PagingIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Paging
implements PagingIF {
    private final int count;
    private final int total;
    private final int page;
    private final int pages;

    private Paging(int count, int total, int page, int pages) {
        this.count = count;
        this.total = total;
        this.page = page;
        this.pages = pages;
    }

    @Override
    @JsonProperty
    public int getCount() {
        return this.count;
    }

    @Override
    @JsonProperty
    public int getTotal() {
        return this.total;
    }

    @Override
    @JsonProperty
    public int getPage() {
        return this.page;
    }

    @Override
    @JsonProperty
    public int getPages() {
        return this.pages;
    }

    public final Paging withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new Paging(value, this.total, this.page, this.pages);
    }

    public final Paging withTotal(int value) {
        if (this.total == value) {
            return this;
        }
        return new Paging(this.count, value, this.page, this.pages);
    }

    public final Paging withPage(int value) {
        if (this.page == value) {
            return this;
        }
        return new Paging(this.count, this.total, value, this.pages);
    }

    public final Paging withPages(int value) {
        if (this.pages == value) {
            return this;
        }
        return new Paging(this.count, this.total, this.page, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Paging && this.equalTo(0, (Paging)another);
    }

    private boolean equalTo(int synthetic, Paging another) {
        return this.count == another.count && this.total == another.total && this.page == another.page && this.pages == another.pages;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.count;
        h += (h << 5) + this.total;
        h += (h << 5) + this.page;
        h += (h << 5) + this.pages;
        return h;
    }

    public String toString() {
        return "Paging{count=" + this.count + ", total=" + this.total + ", page=" + this.page + ", pages=" + this.pages + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Paging fromJson(Json json) {
        Builder builder = Paging.builder();
        if (json.countIsSet) {
            builder.setCount(json.count);
        }
        if (json.totalIsSet) {
            builder.setTotal(json.total);
        }
        if (json.pageIsSet) {
            builder.setPage(json.page);
        }
        if (json.pagesIsSet) {
            builder.setPages(json.pages);
        }
        return builder.build();
    }

    public static Paging copyOf(PagingIF instance) {
        if (instance instanceof Paging) {
            return (Paging)instance;
        }
        return Paging.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PagingIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_TOTAL = 2L;
        private static final long INIT_BIT_PAGE = 4L;
        private static final long INIT_BIT_PAGES = 8L;
        private long initBits = 15L;
        private int count;
        private int total;
        private int page;
        private int pages;

        private Builder() {
        }

        public final Builder from(PagingIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setCount(instance.getCount());
            this.setTotal(instance.getTotal());
            this.setPage(instance.getPage());
            this.setPages(instance.getPages());
            return this;
        }

        public final Builder setCount(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTotal(int total) {
            this.total = total;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPage(int page) {
            this.page = page;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setPages(int pages) {
            this.pages = pages;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Paging build() {
            this.checkRequiredAttributes();
            return new Paging(this.count, this.total, this.page, this.pages);
        }

        private boolean countIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean totalIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean pageIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean pagesIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.countIsSet()) {
                attributes.add("count");
            }
            if (!this.totalIsSet()) {
                attributes.add("total");
            }
            if (!this.pageIsSet()) {
                attributes.add("page");
            }
            if (!this.pagesIsSet()) {
                attributes.add("pages");
            }
            return "Cannot build Paging, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PagingIF", generator="Immutables")
    static final class Json
    implements PagingIF {
        int count;
        boolean countIsSet;
        int total;
        boolean totalIsSet;
        int page;
        boolean pageIsSet;
        int pages;
        boolean pagesIsSet;

        Json() {
        }

        @JsonProperty
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty
        public void setTotal(int total) {
            this.total = total;
            this.totalIsSet = true;
        }

        @JsonProperty
        public void setPage(int page) {
            this.page = page;
            this.pageIsSet = true;
        }

        @JsonProperty
        public void setPages(int pages) {
            this.pages = pages;
            this.pagesIsSet = true;
        }

        @Override
        public int getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPages() {
            throw new UnsupportedOperationException();
        }
    }
}

