/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Message;
import com.hubspot.slack.client.models.response.MessagePageIF;
import com.hubspot.slack.client.models.response.Paging;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MessagePageIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class MessagePage
implements MessagePageIF {
    private final int total;
    private final Paging paging;
    private final List<Message> matches;

    private MessagePage(int total, Paging paging, List<Message> matches) {
        this.total = total;
        this.paging = paging;
        this.matches = matches;
    }

    @Override
    @JsonProperty
    public int getTotal() {
        return this.total;
    }

    @Override
    @JsonProperty
    public Paging getPaging() {
        return this.paging;
    }

    @Override
    @JsonProperty
    public List<Message> getMatches() {
        return this.matches;
    }

    public final MessagePage withTotal(int value) {
        if (this.total == value) {
            return this;
        }
        return new MessagePage(value, this.paging, this.matches);
    }

    public final MessagePage withPaging(Paging value) {
        if (this.paging == value) {
            return this;
        }
        Paging newValue = Objects.requireNonNull(value, "paging");
        return new MessagePage(this.total, newValue, this.matches);
    }

    public final MessagePage withMatches(Message ... elements) {
        List<Message> newValue = MessagePage.createUnmodifiableList(false, MessagePage.createSafeList(Arrays.asList(elements), true, false));
        return new MessagePage(this.total, this.paging, newValue);
    }

    public final MessagePage withMatches(Iterable<? extends Message> elements) {
        if (this.matches == elements) {
            return this;
        }
        List<Message> newValue = MessagePage.createUnmodifiableList(false, MessagePage.createSafeList(elements, true, false));
        return new MessagePage(this.total, this.paging, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessagePage && this.equalTo(0, (MessagePage)another);
    }

    private boolean equalTo(int synthetic, MessagePage another) {
        return this.total == another.total && this.paging.equals(another.paging) && this.matches.equals(another.matches);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.total;
        h += (h << 5) + this.paging.hashCode();
        h += (h << 5) + this.matches.hashCode();
        return h;
    }

    public String toString() {
        return "MessagePage{total=" + this.total + ", paging=" + this.paging + ", matches=" + this.matches + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MessagePage fromJson(Json json) {
        Builder builder = MessagePage.builder();
        if (json.totalIsSet) {
            builder.setTotal(json.total);
        }
        if (json.paging != null) {
            builder.setPaging(json.paging);
        }
        if (json.matches != null) {
            builder.addAllMatches(json.matches);
        }
        return builder.build();
    }

    public static MessagePage copyOf(MessagePageIF instance) {
        if (instance instanceof MessagePage) {
            return (MessagePage)instance;
        }
        return MessagePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MessagePageIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL = 1L;
        private static final long INIT_BIT_PAGING = 2L;
        private long initBits = 3L;
        private int total;
        @Nullable
        private Paging paging;
        private List<Message> matches = new ArrayList<Message>();

        private Builder() {
        }

        public final Builder from(MessagePageIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTotal(instance.getTotal());
            this.setPaging(instance.getPaging());
            this.addAllMatches(instance.getMatches());
            return this;
        }

        public final Builder setTotal(int total) {
            this.total = total;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPaging(Paging paging) {
            this.paging = Objects.requireNonNull(paging, "paging");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addMatches(Message element) {
            this.matches.add(Objects.requireNonNull(element, "matches element"));
            return this;
        }

        public final Builder addMatches(Message ... elements) {
            for (Message element : elements) {
                this.matches.add(Objects.requireNonNull(element, "matches element"));
            }
            return this;
        }

        public final Builder setMatches(Iterable<? extends Message> elements) {
            this.matches.clear();
            return this.addAllMatches(elements);
        }

        public final Builder addAllMatches(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.matches.add(Objects.requireNonNull(message, "matches element"));
            }
            return this;
        }

        public MessagePage build() {
            this.checkRequiredAttributes();
            return new MessagePage(this.total, this.paging, MessagePage.createUnmodifiableList(true, this.matches));
        }

        private boolean totalIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean pagingIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.totalIsSet()) {
                attributes.add("total");
            }
            if (!this.pagingIsSet()) {
                attributes.add("paging");
            }
            return "Cannot build MessagePage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessagePageIF", generator="Immutables")
    static final class Json
    implements MessagePageIF {
        int total;
        boolean totalIsSet;
        @Nullable
        Paging paging;
        @Nullable
        List<Message> matches = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotal(int total) {
            this.total = total;
            this.totalIsSet = true;
        }

        @JsonProperty
        public void setPaging(Paging paging) {
            this.paging = paging;
        }

        @JsonProperty
        public void setMatches(List<Message> matches) {
            this.matches = matches;
        }

        @Override
        public int getTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Paging getPaging() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Message> getMatches() {
            throw new UnsupportedOperationException();
        }
    }
}

