/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import com.hubspot.slack.client.models.interaction.views.ViewUrlInputIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewUrlInputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewUrlInput
implements ViewUrlInputIF {
    private final ViewInputType type;
    @Nullable
    private final String value;

    private ViewUrlInput(ViewInputType type, @Nullable String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public final ViewUrlInput withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewUrlInput(newValue, this.value);
    }

    public final ViewUrlInput withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new ViewUrlInput(this.type, newValue);
    }

    public final ViewUrlInput withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ViewUrlInput(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewUrlInput && this.equalTo(0, (ViewUrlInput)another);
    }

    private boolean equalTo(int synthetic, ViewUrlInput another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewUrlInput{");
        builder.append("type=").append((Object)this.type);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewUrlInput fromJson(Json json) {
        Builder builder = ViewUrlInput.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        return builder.build();
    }

    public static ViewUrlInput copyOf(ViewUrlInputIF instance) {
        if (instance instanceof ViewUrlInput) {
            return (ViewUrlInput)instance;
        }
        return ViewUrlInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewUrlInputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewUrlInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewUrlInputIF) {
                Optional<String> valueOptional;
                instance = (ViewUrlInputIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((valueOptional = instance.getValue()).isPresent()) {
                    this.setValue(valueOptional);
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public ViewUrlInput build() {
            this.checkRequiredAttributes();
            return new ViewUrlInput(this.type, this.value);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewUrlInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewUrlInputIF", generator="Immutables")
    static final class Json
    implements ViewUrlInputIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> value = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

