/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.interaction.views.ViewExternalSelectIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewExternalSelectIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewExternalSelect
implements ViewExternalSelectIF {
    private final ViewInputType type;
    @Nullable
    private final Option selectedOption;

    private ViewExternalSelect(ViewInputType type, @Nullable Option selectedOption) {
        this.type = type;
        this.selectedOption = selectedOption;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<Option> getSelectedOption() {
        return Optional.ofNullable(this.selectedOption);
    }

    public final ViewExternalSelect withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewExternalSelect(newValue, this.selectedOption);
    }

    public final ViewExternalSelect withSelectedOption(@Nullable Option value) {
        Option newValue = value;
        if (this.selectedOption == newValue) {
            return this;
        }
        return new ViewExternalSelect(this.type, newValue);
    }

    public final ViewExternalSelect withSelectedOption(Optional<? extends Option> optional) {
        Option value = optional.orElse(null);
        if (this.selectedOption == value) {
            return this;
        }
        return new ViewExternalSelect(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewExternalSelect && this.equalTo(0, (ViewExternalSelect)another);
    }

    private boolean equalTo(int synthetic, ViewExternalSelect another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.selectedOption, another.selectedOption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.selectedOption);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewExternalSelect{");
        builder.append("type=").append((Object)this.type);
        if (this.selectedOption != null) {
            builder.append(", ");
            builder.append("selectedOption=").append(this.selectedOption);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewExternalSelect fromJson(Json json) {
        Builder builder = ViewExternalSelect.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.selectedOption != null) {
            builder.setSelectedOption(json.selectedOption);
        }
        return builder.build();
    }

    public static ViewExternalSelect copyOf(ViewExternalSelectIF instance) {
        if (instance instanceof ViewExternalSelect) {
            return (ViewExternalSelect)instance;
        }
        return ViewExternalSelect.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewExternalSelectIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private Option selectedOption;

        private Builder() {
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewExternalSelectIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewExternalSelectIF) {
                Optional<Option> selectedOptionOptional;
                instance = (ViewExternalSelectIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((selectedOptionOptional = instance.getSelectedOption()).isPresent()) {
                    this.setSelectedOption(selectedOptionOptional);
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSelectedOption(@Nullable Option selectedOption) {
            this.selectedOption = selectedOption;
            return this;
        }

        public final Builder setSelectedOption(Optional<? extends Option> selectedOption) {
            this.selectedOption = selectedOption.orElse(null);
            return this;
        }

        public ViewExternalSelect build() {
            this.checkRequiredAttributes();
            return new ViewExternalSelect(this.type, this.selectedOption);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewExternalSelect, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewExternalSelectIF", generator="Immutables")
    static final class Json
    implements ViewExternalSelectIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<Option> selectedOption = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        public void setSelectedOption(Optional<Option> selectedOption) {
            this.selectedOption = selectedOption;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Option> getSelectedOption() {
            throw new UnsupportedOperationException();
        }
    }
}

