/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewDateTimePickerIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewDateTimePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewDateTimePicker
implements ViewDateTimePickerIF {
    private final ViewInputType type;
    @Nullable
    private final String stringValue;
    @Nullable
    private final Integer selectedDateTime;

    private ViewDateTimePicker(ViewInputType type, @Nullable String stringValue, @Nullable Integer selectedDateTime) {
        this.type = type;
        this.stringValue = stringValue;
        this.selectedDateTime = selectedDateTime;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.stringValue);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getSelectedDateTime() {
        return Optional.ofNullable(this.selectedDateTime);
    }

    public final ViewDateTimePicker withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewDateTimePicker(newValue, this.stringValue, this.selectedDateTime);
    }

    public final ViewDateTimePicker withStringValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.stringValue, newValue)) {
            return this;
        }
        return new ViewDateTimePicker(this.type, newValue, this.selectedDateTime);
    }

    public final ViewDateTimePicker withStringValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stringValue, value)) {
            return this;
        }
        return new ViewDateTimePicker(this.type, value, this.selectedDateTime);
    }

    public final ViewDateTimePicker withSelectedDateTime(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.selectedDateTime, newValue)) {
            return this;
        }
        return new ViewDateTimePicker(this.type, this.stringValue, newValue);
    }

    public final ViewDateTimePicker withSelectedDateTime(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.selectedDateTime, value)) {
            return this;
        }
        return new ViewDateTimePicker(this.type, this.stringValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewDateTimePicker && this.equalTo(0, (ViewDateTimePicker)another);
    }

    private boolean equalTo(int synthetic, ViewDateTimePicker another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.stringValue, another.stringValue) && Objects.equals(this.selectedDateTime, another.selectedDateTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.stringValue);
        h += (h << 5) + Objects.hashCode(this.selectedDateTime);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewDateTimePicker{");
        builder.append("type=").append((Object)this.type);
        if (this.stringValue != null) {
            builder.append(", ");
            builder.append("stringValue=").append(this.stringValue);
        }
        if (this.selectedDateTime != null) {
            builder.append(", ");
            builder.append("selectedDateTime=").append(this.selectedDateTime);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewDateTimePicker fromJson(Json json) {
        Builder builder = ViewDateTimePicker.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.stringValue != null) {
            builder.setStringValue(json.stringValue);
        }
        if (json.selectedDateTime != null) {
            builder.setSelectedDateTime(json.selectedDateTime);
        }
        return builder.build();
    }

    public static ViewDateTimePicker copyOf(ViewDateTimePickerIF instance) {
        if (instance instanceof ViewDateTimePicker) {
            return (ViewDateTimePicker)instance;
        }
        return ViewDateTimePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewDateTimePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String stringValue;
        @Nullable
        private Integer selectedDateTime;

        private Builder() {
        }

        public final Builder from(ViewDateTimePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewDateTimePickerIF) {
                Optional<Integer> selectedDateTimeOptional;
                instance = (ViewDateTimePickerIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((selectedDateTimeOptional = instance.getSelectedDateTime()).isPresent()) {
                    this.setSelectedDateTime(selectedDateTimeOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStringValue(@Nullable String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Builder setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue.orElse(null);
            return this;
        }

        public final Builder setSelectedDateTime(@Nullable Integer selectedDateTime) {
            this.selectedDateTime = selectedDateTime;
            return this;
        }

        public final Builder setSelectedDateTime(Optional<Integer> selectedDateTime) {
            this.selectedDateTime = selectedDateTime.orElse(null);
            return this;
        }

        public ViewDateTimePicker build() {
            this.checkRequiredAttributes();
            return new ViewDateTimePicker(this.type, this.stringValue, this.selectedDateTime);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewDateTimePicker, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewDateTimePickerIF", generator="Immutables")
    static final class Json
    implements ViewDateTimePickerIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> stringValue = Optional.empty();
        @Nullable
        Optional<Integer> selectedDateTime = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        @JsonIgnore
        public void setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue;
        }

        @JsonProperty
        public void setSelectedDateTime(Optional<Integer> selectedDateTime) {
            this.selectedDateTime = selectedDateTime;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStringValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getSelectedDateTime() {
            throw new UnsupportedOperationException();
        }
    }
}

