/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewDatePickerIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewDatePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewDatePicker
implements ViewDatePickerIF {
    private final ViewInputType type;
    @Nullable
    private final String stringValue;
    @Nullable
    private final LocalDate selectedDate;

    private ViewDatePicker(ViewInputType type, @Nullable String stringValue, @Nullable LocalDate selectedDate) {
        this.type = type;
        this.stringValue = stringValue;
        this.selectedDate = selectedDate;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.stringValue);
    }

    @Override
    @JsonProperty
    public Optional<LocalDate> getSelectedDate() {
        return Optional.ofNullable(this.selectedDate);
    }

    public final ViewDatePicker withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewDatePicker(newValue, this.stringValue, this.selectedDate);
    }

    public final ViewDatePicker withStringValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.stringValue, newValue)) {
            return this;
        }
        return new ViewDatePicker(this.type, newValue, this.selectedDate);
    }

    public final ViewDatePicker withStringValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stringValue, value)) {
            return this;
        }
        return new ViewDatePicker(this.type, value, this.selectedDate);
    }

    public final ViewDatePicker withSelectedDate(@Nullable LocalDate value) {
        LocalDate newValue = value;
        if (this.selectedDate == newValue) {
            return this;
        }
        return new ViewDatePicker(this.type, this.stringValue, newValue);
    }

    public final ViewDatePicker withSelectedDate(Optional<? extends LocalDate> optional) {
        LocalDate value = optional.orElse(null);
        if (this.selectedDate == value) {
            return this;
        }
        return new ViewDatePicker(this.type, this.stringValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewDatePicker && this.equalTo(0, (ViewDatePicker)another);
    }

    private boolean equalTo(int synthetic, ViewDatePicker another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.stringValue, another.stringValue) && Objects.equals(this.selectedDate, another.selectedDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.stringValue);
        h += (h << 5) + Objects.hashCode(this.selectedDate);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewDatePicker{");
        builder.append("type=").append((Object)this.type);
        if (this.stringValue != null) {
            builder.append(", ");
            builder.append("stringValue=").append(this.stringValue);
        }
        if (this.selectedDate != null) {
            builder.append(", ");
            builder.append("selectedDate=").append(this.selectedDate);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewDatePicker fromJson(Json json) {
        Builder builder = ViewDatePicker.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.stringValue != null) {
            builder.setStringValue(json.stringValue);
        }
        if (json.selectedDate != null) {
            builder.setSelectedDate(json.selectedDate);
        }
        return builder.build();
    }

    public static ViewDatePicker copyOf(ViewDatePickerIF instance) {
        if (instance instanceof ViewDatePicker) {
            return (ViewDatePicker)instance;
        }
        return ViewDatePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewDatePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String stringValue;
        @Nullable
        private LocalDate selectedDate;

        private Builder() {
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewDatePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ViewDatePickerIF) {
                Optional<LocalDate> selectedDateOptional;
                instance = (ViewDatePickerIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((selectedDateOptional = instance.getSelectedDate()).isPresent()) {
                    this.setSelectedDate(selectedDateOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStringValue(@Nullable String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Builder setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue.orElse(null);
            return this;
        }

        public final Builder setSelectedDate(@Nullable LocalDate selectedDate) {
            this.selectedDate = selectedDate;
            return this;
        }

        public final Builder setSelectedDate(Optional<? extends LocalDate> selectedDate) {
            this.selectedDate = selectedDate.orElse(null);
            return this;
        }

        public ViewDatePicker build() {
            this.checkRequiredAttributes();
            return new ViewDatePicker(this.type, this.stringValue, this.selectedDate);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewDatePicker, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewDatePickerIF", generator="Immutables")
    static final class Json
    implements ViewDatePickerIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> stringValue = Optional.empty();
        @Nullable
        Optional<LocalDate> selectedDate = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        @JsonIgnore
        public void setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue;
        }

        @JsonProperty
        public void setSelectedDate(Optional<LocalDate> selectedDate) {
            this.selectedDate = selectedDate;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStringValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalDate> getSelectedDate() {
            throw new UnsupportedOperationException();
        }
    }
}

