/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.interaction.ViewInteractionPayload;
import com.hubspot.slack.client.models.interaction.ViewSubmissionIF;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewSubmissionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewSubmission
implements ViewSubmissionIF {
    private final InteractiveCallbackType type;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final ViewInteractionPayload view;
    @Nullable
    private final String callbackId;

    private ViewSubmission(InteractiveCallbackType type, String token, SlackTeam team, SlackUserLite user, ViewInteractionPayload view, @Nullable String callbackId) {
        this.type = type;
        this.token = token;
        this.team = team;
        this.user = user;
        this.view = view;
        this.callbackId = callbackId;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public ViewInteractionPayload getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getCallbackId() {
        return this.callbackId;
    }

    public final ViewSubmission withType(InteractiveCallbackType value) {
        InteractiveCallbackType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewSubmission(newValue, this.token, this.team, this.user, this.view, this.callbackId);
    }

    public final ViewSubmission withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ViewSubmission(this.type, newValue, this.team, this.user, this.view, this.callbackId);
    }

    public final ViewSubmission withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new ViewSubmission(this.type, this.token, newValue, this.user, this.view, this.callbackId);
    }

    public final ViewSubmission withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new ViewSubmission(this.type, this.token, this.team, newValue, this.view, this.callbackId);
    }

    public final ViewSubmission withView(ViewInteractionPayload value) {
        if (this.view == value) {
            return this;
        }
        ViewInteractionPayload newValue = Objects.requireNonNull(value, "view");
        return new ViewSubmission(this.type, this.token, this.team, this.user, newValue, this.callbackId);
    }

    public final ViewSubmission withCallbackId(@Nullable String value) {
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new ViewSubmission(this.type, this.token, this.team, this.user, this.view, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewSubmission && this.equalTo(0, (ViewSubmission)another);
    }

    private boolean equalTo(int synthetic, ViewSubmission another) {
        return this.type.equals((Object)another.type) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.view.equals(another.view) && Objects.equals(this.callbackId, another.callbackId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.view.hashCode();
        h += (h << 5) + Objects.hashCode(this.callbackId);
        return h;
    }

    public String toString() {
        return "ViewSubmission{type=" + this.type + ", token=" + this.token + ", team=" + this.team + ", user=" + this.user + ", view=" + this.view + ", callbackId=" + this.callbackId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewSubmission fromJson(Json json) {
        Builder builder = ViewSubmission.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        return builder.build();
    }

    public static ViewSubmission copyOf(ViewSubmissionIF instance) {
        if (instance instanceof ViewSubmission) {
            return (ViewSubmission)instance;
        }
        return ViewSubmission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewSubmissionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TOKEN = 2L;
        private static final long INIT_BIT_TEAM = 4L;
        private static final long INIT_BIT_USER = 8L;
        private static final long INIT_BIT_VIEW = 16L;
        private long initBits = 31L;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private ViewInteractionPayload view;
        @Nullable
        private String callbackId;

        private Builder() {
        }

        public final Builder from(ViewSubmissionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String callbackIdValue;
            SlackInteractiveCallback instance;
            long bits = 0L;
            if (object instanceof ViewSubmissionIF) {
                instance = (ViewSubmissionIF)object;
                this.setView(instance.getView());
                if ((bits & 1L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    callbackIdValue = instance.getCallbackId();
                    if (callbackIdValue != null) {
                        this.setCallbackId(callbackIdValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 4L;
                }
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                if ((bits & 1L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    callbackIdValue = instance.getCallbackId();
                    if (callbackIdValue != null) {
                        this.setCallbackId(callbackIdValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 4L;
                }
            }
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setView(ViewInteractionPayload view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public ViewSubmission build() {
            this.checkRequiredAttributes();
            return new ViewSubmission(this.type, this.token, this.team, this.user, this.view, this.callbackId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean viewIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            return "Cannot build ViewSubmission, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewSubmissionIF", generator="Immutables")
    static final class Json
    implements ViewSubmissionIF {
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        ViewInteractionPayload view;
        @Nullable
        String callbackId;

        Json() {
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setView(ViewInteractionPayload view) {
            this.view = view;
        }

        @JsonProperty
        public void setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ViewInteractionPayload getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }
    }
}

