/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.Container;
import com.hubspot.slack.client.models.interaction.ContainerType;
import com.hubspot.slack.client.models.interaction.MessageContainerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MessageContainerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class MessageContainer
implements MessageContainerIF {
    private final ContainerType type;
    private final String messageTs;
    private final String channelId;
    private final boolean ephemeral;

    private MessageContainer(ContainerType type, String messageTs, String channelId, boolean ephemeral) {
        this.type = type;
        this.messageTs = messageTs;
        this.channelId = channelId;
        this.ephemeral = ephemeral;
    }

    @Override
    @JsonProperty
    public ContainerType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="is_ephemeral")
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public final MessageContainer withType(ContainerType value) {
        ContainerType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new MessageContainer(newValue, this.messageTs, this.channelId, this.ephemeral);
    }

    public final MessageContainer withMessageTs(String value) {
        String newValue = Objects.requireNonNull(value, "messageTs");
        if (this.messageTs.equals(newValue)) {
            return this;
        }
        return new MessageContainer(this.type, newValue, this.channelId, this.ephemeral);
    }

    public final MessageContainer withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new MessageContainer(this.type, this.messageTs, newValue, this.ephemeral);
    }

    public final MessageContainer withEphemeral(boolean value) {
        if (this.ephemeral == value) {
            return this;
        }
        return new MessageContainer(this.type, this.messageTs, this.channelId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageContainer && this.equalTo(0, (MessageContainer)another);
    }

    private boolean equalTo(int synthetic, MessageContainer another) {
        return this.type.equals((Object)another.type) && this.messageTs.equals(another.messageTs) && this.channelId.equals(another.channelId) && this.ephemeral == another.ephemeral;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.messageTs.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.ephemeral);
        return h;
    }

    public String toString() {
        return "MessageContainer{type=" + this.type + ", messageTs=" + this.messageTs + ", channelId=" + this.channelId + ", ephemeral=" + this.ephemeral + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MessageContainer fromJson(Json json) {
        Builder builder = MessageContainer.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.ephemeralIsSet) {
            builder.setEphemeral(json.ephemeral);
        }
        return builder.build();
    }

    public static MessageContainer copyOf(MessageContainerIF instance) {
        if (instance instanceof MessageContainer) {
            return (MessageContainer)instance;
        }
        return MessageContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MessageContainerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_MESSAGE_TS = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_EPHEMERAL = 8L;
        private long initBits = 15L;
        @Nullable
        private ContainerType type;
        @Nullable
        private String messageTs;
        @Nullable
        private String channelId;
        private boolean ephemeral;

        private Builder() {
        }

        public final Builder from(Container instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageContainerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Container instance;
            long bits = 0L;
            if (object instanceof Container) {
                instance = (Container)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageContainerIF) {
                instance = (MessageContainerIF)object;
                this.setEphemeral(instance.isEphemeral());
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setMessageTs(instance.getMessageTs());
                this.setChannelId(instance.getChannelId());
            }
        }

        public final Builder setType(ContainerType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setEphemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public MessageContainer build() {
            this.checkRequiredAttributes();
            return new MessageContainer(this.type, this.messageTs, this.channelId, this.ephemeral);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean ephemeralIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.ephemeralIsSet()) {
                attributes.add("ephemeral");
            }
            return "Cannot build MessageContainer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageContainerIF", generator="Immutables")
    static final class Json
    implements MessageContainerIF {
        @Nullable
        ContainerType type;
        @Nullable
        String messageTs;
        @Nullable
        String channelId;
        boolean ephemeral;
        boolean ephemeralIsSet;

        Json() {
        }

        @JsonProperty
        public void setType(ContainerType type) {
            this.type = type;
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="is_ephemeral")
        public void setEphemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
            this.ephemeralIsSet = true;
        }

        @Override
        public ContainerType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEphemeral() {
            throw new UnsupportedOperationException();
        }
    }
}

