/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hubspot.slack.client.models.files.SlackCsvFile;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackGifFile;
import com.hubspot.slack.client.models.files.SlackJavaScriptFile;
import com.hubspot.slack.client.models.files.SlackJpgFile;
import com.hubspot.slack.client.models.files.SlackPngFile;
import com.hubspot.slack.client.models.files.SlackTextFile;
import com.hubspot.slack.client.models.files.SlackUnknownFiletype;
import com.hubspot.slack.client.models.files.SlackXlsFile;
import com.hubspot.slack.client.models.files.SlackXlsxFile;
import java.util.Optional;
import java.util.stream.Stream;

public enum SlackFileType {
    TEXT("text", SlackTextFile.class),
    GIF("gif", SlackGifFile.class),
    CSV("csv", SlackCsvFile.class),
    JPG("jpg", SlackJpgFile.class),
    PNG("png", SlackPngFile.class),
    JAVASCRIPT("javascript", SlackJavaScriptFile.class),
    XLSX("xlsx", SlackXlsxFile.class),
    XLS("xls", SlackXlsFile.class),
    UNKNOWN("unknown", SlackUnknownFiletype.class);

    final String type;
    private final Class<? extends SlackFile> clazz;

    private SlackFileType(String type, Class<? extends SlackFile> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static SlackFileType parse(String field) {
        return SlackFileType.tryParse(field).orElseThrow(() -> new IllegalArgumentException(field + " doesn't match any known slack file type"));
    }

    public static Optional<SlackFileType> tryParse(String field) {
        return Stream.of(SlackFileType.values()).filter(val -> val.getType().equalsIgnoreCase(field)).findFirst();
    }

    public Class<? extends SlackFile> getFileTypeClass() {
        return this.clazz;
    }
}

