/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.slack.client.models.files.SlackFileType;
import com.hubspot.slack.client.models.files.json.SlackFileDeserializer;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(using=SlackFileDeserializer.class)
public interface SlackFile {
    public String getId();

    @JsonProperty(value="created")
    public long getCreatedEpochSeconds();

    @JsonProperty(value="timestamp")
    public long getTimestampEpochSeconds();

    public String getName();

    public String getTitle();

    public String getMimetype();

    public SlackFileType getFiletype();

    public String getPrettyType();

    @JsonProperty(value="user")
    public String getUserId();

    public boolean isEditable();

    public long getSize();

    public String getMode();

    @JsonProperty(value="is_external")
    public boolean isExternal();

    @JsonProperty(value="is_public")
    public boolean isPublic();

    public boolean isPublicUrlShared();

    public boolean getDisplayAsBot();

    public String getUsername();

    public String getUrlPrivate();

    public Optional<String> getUrlPrivateDownload();

    public String getPermalink();

    public Optional<String> getPermalinkPublic();

    @Value.Default
    default public int getCommentsCount() {
        return 0;
    }

    @JsonProperty(value="is_starred")
    public Optional<Boolean> isStarred();

    @JsonProperty(value="channels")
    public List<String> getChannelIds();

    @JsonProperty(value="groups")
    public List<String> getGroupIds();

    @JsonProperty(value="ims")
    public List<String> getImIds();
}

